/*
 * Decompiled with CFR 0.152.
 */
package openblocks.shapes;

import openmods.shapes.IShapeGenerator;
import openmods.shapes.ShapeCuboidGenerator;
import openmods.shapes.ShapeCylinderGenerator;
import openmods.shapes.ShapeDomeGenerator;
import openmods.shapes.ShapeEquilateral2dGenerator;
import openmods.shapes.ShapeSphereGenerator;

public enum GuideShape {
    Sphere(false, (IShapeGenerator)new ShapeSphereGenerator()),
    Cylinder(false, (IShapeGenerator)new ShapeCylinderGenerator()),
    Cuboid(false, (IShapeGenerator)new ShapeCuboidGenerator()),
    Dome(false, (IShapeGenerator)new ShapeDomeGenerator()),
    Triangle(true, (IShapeGenerator)new ShapeEquilateral2dGenerator(3)),
    Pentagon(true, (IShapeGenerator)new ShapeEquilateral2dGenerator(5)),
    Hexagon(true, (IShapeGenerator)new ShapeEquilateral2dGenerator(6)),
    Octagon(true, (IShapeGenerator)new ShapeEquilateral2dGenerator(8));

    private final String displayName;
    public final boolean fixedRatio;
    public final IShapeGenerator generator;

    private GuideShape(boolean fixedRatio, IShapeGenerator generator) {
        this(null, fixedRatio, generator);
    }

    private GuideShape(String displayName, boolean fixedRatio, IShapeGenerator generator) {
        this.displayName = displayName;
        this.fixedRatio = fixedRatio;
        this.generator = generator;
    }

    public String getDisplayName() {
        return this.displayName == null ? this.name() : this.displayName;
    }
}

