/*
 * Decompiled with CFR 0.152.
 */
package openblocks.integration;

import com.google.common.base.Preconditions;
import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IHostedPeripheral;
import dan200.computer.api.ILuaContext;
import dan200.turtle.api.ITurtleAccess;
import dan200.turtle.api.TurtleSide;
import java.lang.ref.WeakReference;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import openblocks.Config;
import openblocks.common.entity.EntityMagnet;
import openblocks.integration.CCUtils;
import openmods.Log;

public class MagnetControlPeripheral
implements IHostedPeripheral {
    private WeakReference<EntityMagnet> magnet = new WeakReference<Object>(null);
    private Owner magnetOwner;
    private TurtleSide side;
    private final ITurtleAccess turtle;
    private int fuelTick = 0;

    public MagnetControlPeripheral(ITurtleAccess turtle, TurtleSide side) {
        this.turtle = turtle;
        this.side = side;
    }

    public String getType() {
        return "magnet";
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
    }

    public boolean canAttachToSide(int side) {
        return true;
    }

    public void attach(IComputerAccess computer) {
    }

    public void detach(IComputerAccess computer) {
    }

    public String[] getMethodNames() {
        return new String[]{"activate", "deactivate", "setTarget", "getPosition", "toggle", "isAboveEntity", "isGrabbing", "toTarget"};
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                return this.spawnMagnet();
            }
            case 1: {
                return this.despawnMagnet(true);
            }
            case 2: {
                if (this.magnetOwner == null) {
                    return CCUtils.wrap(false, "Magnet not active");
                }
                Preconditions.checkArgument((arguments.length == 3 ? 1 : 0) != 0, (Object)"Method needs three numbers");
                double x = CCUtils.toDouble(arguments[0]);
                double y = CCUtils.toDouble(arguments[1]);
                double z = CCUtils.toDouble(arguments[2]);
                if (!MagnetControlPeripheral.checkTargetRange(x, y, z)) {
                    return CCUtils.wrap(false, "Target out of range");
                }
                this.magnetOwner.setTarget(x, y, z);
                return CCUtils.TRUE;
            }
            case 3: {
                EntityMagnet magnet = (EntityMagnet)((Object)this.magnet.get());
                if (magnet == null || magnet.field_70128_L) {
                    return CCUtils.wrap(false, "Magnet not active");
                }
                Vec3 rotated = MagnetControlPeripheral.getRelativeDistance(this.turtle, magnet);
                return CCUtils.wrap(rotated.field_72450_a, rotated.field_72448_b, rotated.field_72449_c);
            }
            case 4: {
                EntityMagnet magnet = (EntityMagnet)((Object)this.magnet.get());
                if (magnet == null || magnet.field_70128_L) {
                    return CCUtils.wrap(false, "Magnet not active");
                }
                return CCUtils.wrap(magnet.toggleMagnet());
            }
            case 5: {
                EntityMagnet magnet = (EntityMagnet)((Object)this.magnet.get());
                if (magnet == null || magnet.field_70128_L) {
                    return CCUtils.wrap(false, "Magnet not active");
                }
                return CCUtils.wrap(magnet.isAboveTarget());
            }
            case 6: {
                EntityMagnet magnet = (EntityMagnet)((Object)this.magnet.get());
                if (magnet == null || magnet.field_70128_L) {
                    return CCUtils.wrap(false, "Magnet not active");
                }
                return CCUtils.wrap(magnet.isLocked());
            }
            case 7: {
                EntityMagnet magnet = (EntityMagnet)((Object)this.magnet.get());
                if (magnet == null || magnet.field_70128_L) {
                    return CCUtils.wrap(false, "Magnet not active");
                }
                Vec3 current = MagnetControlPeripheral.getRelativeDistance(this.turtle, magnet);
                Vec3 target = this.magnetOwner.target;
                Vec3 dist = target.func_72444_a(current);
                return CCUtils.wrap(dist.field_72450_a, dist.field_72448_b, dist.field_72449_c);
            }
        }
        throw new IllegalArgumentException("Invalid method id: " + method);
    }

    public void update() {
        EntityMagnet magnet = (EntityMagnet)((Object)this.magnet.get());
        if (magnet != null && !magnet.field_70128_L && ++this.fuelTick >= 20) {
            int fuel;
            this.fuelTick = 0;
            int n = fuel = magnet.isLocked() ? 2 : 1;
            if (!this.turtle.consumeFuel(fuel)) {
                this.despawnMagnet(false);
            }
        }
    }

    private static boolean checkTargetRange(double x, double y, double z) {
        return Math.abs(x) <= Config.turtleMagnetRange && Math.abs(y) <= Config.turtleMagnetRange && Math.abs(z) <= Config.turtleMagnetRange;
    }

    private static Vec3 getRelativeDistance(ITurtleAccess turtle, EntityMagnet magnet) {
        Vec3 magnetPos = Vec3.func_72443_a((double)magnet.field_70165_t, (double)magnet.field_70163_u, (double)magnet.field_70161_v);
        Vec3 turtlePos = turtle.getPosition().func_72441_c(0.5, 0.5, 0.5);
        Vec3 dist = turtlePos.func_72444_a(magnetPos);
        ForgeDirection side = ForgeDirection.getOrientation((int)turtle.getFacingDir());
        switch (side) {
            case NORTH: {
                return Vec3.func_72443_a((double)(-dist.field_72449_c), (double)dist.field_72448_b, (double)dist.field_72450_a);
            }
            case SOUTH: {
                return Vec3.func_72443_a((double)dist.field_72449_c, (double)dist.field_72448_b, (double)(-dist.field_72450_a));
            }
            case EAST: {
                return Vec3.func_72443_a((double)dist.field_72450_a, (double)dist.field_72448_b, (double)dist.field_72449_c);
            }
            case WEST: {
                return Vec3.func_72443_a((double)(-dist.field_72450_a), (double)dist.field_72448_b, (double)(-dist.field_72449_c));
            }
        }
        return dist;
    }

    private boolean canSpawn(World world) {
        ForgeDirection facing = ForgeDirection.getOrientation((int)this.turtle.getFacingDir());
        ForgeDirection spawnSide = facing.getRotation(this.side == TurtleSide.Left ? ForgeDirection.DOWN : ForgeDirection.UP);
        Vec3 position = this.turtle.getPosition();
        int x = MathHelper.func_76128_c((double)position.field_72450_a) + spawnSide.offsetX;
        int y = MathHelper.func_76128_c((double)position.field_72448_b) + spawnSide.offsetY;
        int z = MathHelper.func_76128_c((double)position.field_72449_c) + spawnSide.offsetZ;
        return world.func_72799_c(x, y, z);
    }

    private Object[] spawnMagnet() {
        EntityMagnet magnet = (EntityMagnet)((Object)this.magnet.get());
        if (magnet != null && !magnet.field_70128_L) {
            return CCUtils.wrap(false, "Magnet already active");
        }
        World world = this.turtle.getWorld();
        if (world == null) {
            Log.warn((String)"Trying to spawn magnet, but turtle is unloaded", (Object[])new Object[0]);
            return CCUtils.wrap(false, "WTF?");
        }
        if (!this.canSpawn(world)) {
            return CCUtils.wrap(false, "Can't deploy magnet");
        }
        if (!this.turtle.consumeFuel(5)) {
            return CCUtils.wrap(false, "No fuel");
        }
        this.magnetOwner = new Owner(this.turtle);
        ((Owner)this.magnetOwner).target.field_72449_c = this.side == TurtleSide.Left ? -1.0 : 1.0;
        magnet = new EntityMagnet(world, this.magnetOwner, true);
        world.func_72838_d((Entity)magnet);
        magnet.func_85030_a("mob.endermen.portal", 1.0f, 1.0f);
        this.magnet = new WeakReference<EntityMagnet>(magnet);
        return CCUtils.TRUE;
    }

    private Object[] despawnMagnet(boolean checkPosition) {
        EntityMagnet magnet = (EntityMagnet)((Object)this.magnet.get());
        if (magnet == null) {
            return CCUtils.wrap(false, "Magnet not active");
        }
        Vec3 magnetPos = Vec3.func_72443_a((double)magnet.field_70165_t, (double)magnet.field_70163_u, (double)magnet.field_70161_v);
        Vec3 turtlePos = this.turtle.getPosition().func_72441_c(0.5, 0.5, 0.5);
        if (checkPosition && magnetPos.func_72436_e(turtlePos) > 1.44) {
            return CCUtils.wrap(false, "Magnet too far");
        }
        magnet.func_85030_a("mob.endermen.portal", 1.0f, 1.0f);
        magnet.func_70106_y();
        this.magnet.clear();
        this.magnetOwner = null;
        return CCUtils.TRUE;
    }

    public static class Owner
    implements EntityMagnet.IOwner {
        private final Vec3 target;
        private WeakReference<ITurtleAccess> turtle;

        public Owner(ITurtleAccess turtle) {
            this.turtle = new WeakReference<ITurtleAccess>(turtle);
            this.target = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        }

        public synchronized void setTarget(double x, double y, double z) {
            this.target.field_72450_a = x;
            this.target.field_72448_b = y;
            this.target.field_72449_c = z;
        }

        @Override
        public synchronized Vec3 getTarget() {
            ITurtleAccess turtle = (ITurtleAccess)this.turtle.get();
            if (turtle == null) {
                return null;
            }
            Vec3 pos = turtle.getPosition().func_72441_c(0.5, 0.5, 0.5);
            pos.field_72448_b += this.target.field_72448_b;
            ForgeDirection side = ForgeDirection.getOrientation((int)turtle.getFacingDir());
            switch (side) {
                case NORTH: {
                    pos.field_72450_a += this.target.field_72449_c;
                    pos.field_72449_c -= this.target.field_72450_a;
                    break;
                }
                case SOUTH: {
                    pos.field_72450_a -= this.target.field_72449_c;
                    pos.field_72449_c += this.target.field_72450_a;
                    break;
                }
                case WEST: {
                    pos.field_72450_a -= this.target.field_72450_a;
                    pos.field_72449_c -= this.target.field_72449_c;
                    break;
                }
                case EAST: {
                    pos.field_72450_a += this.target.field_72450_a;
                    pos.field_72449_c += this.target.field_72449_c;
                    break;
                }
            }
            return pos;
        }

        @Override
        public boolean isValid(EntityMagnet magnet) {
            ITurtleAccess turtle = (ITurtleAccess)this.turtle.get();
            return turtle != null && turtle.getWorld() != null;
        }
    }
}

