/*
 * Decompiled with CFR 0.152.
 */
package openblocks.events;

import openblocks.common.MapDataManager;
import openblocks.events.PlayerActionEvent;
import openblocks.events.PlayerMovementEvent;
import openblocks.events.StencilCraftEvent;
import openmods.network.EventPacket;
import openmods.network.EventPacketManager;
import openmods.network.IEventPacketType;
import openmods.network.PacketDirection;

public enum EventTypes implements IEventPacketType
{
    MAP_DATA_REQUEST{

        public EventPacket createPacket() {
            return new MapDataManager.MapDataRequestEvent();
        }

        public PacketDirection getDirection() {
            return PacketDirection.FROM_CLIENT;
        }
    }
    ,
    MAP_DATA_RESPONSE{

        public EventPacket createPacket() {
            return new MapDataManager.MapDataResponseEvent();
        }

        public PacketDirection getDirection() {
            return PacketDirection.TO_CLIENT;
        }

        @Override
        public boolean isCompressed() {
            return true;
        }
    }
    ,
    MAP_UPDATES{

        public EventPacket createPacket() {
            return new MapDataManager.MapUpdatesEvent();
        }

        public PacketDirection getDirection() {
            return PacketDirection.TO_CLIENT;
        }
    }
    ,
    PLAYER_MOVEMENT{

        public EventPacket createPacket() {
            return new PlayerMovementEvent();
        }

        public PacketDirection getDirection() {
            return PacketDirection.FROM_CLIENT;
        }
    }
    ,
    STENCIL_CRAFT{

        public EventPacket createPacket() {
            return new StencilCraftEvent();
        }

        public PacketDirection getDirection() {
            return PacketDirection.FROM_CLIENT;
        }
    }
    ,
    PLAYER_ACTION{

        public EventPacket createPacket() {
            return new PlayerActionEvent();
        }

        public PacketDirection getDirection() {
            return PacketDirection.FROM_CLIENT;
        }
    };


    public boolean isCompressed() {
        return false;
    }

    public boolean isChunked() {
        return false;
    }

    public int getId() {
        return 1024 + this.ordinal();
    }

    public static void registerTypes() {
        for (EventTypes type : EventTypes.values()) {
            EventPacketManager.registerType((IEventPacketType)type);
        }
    }
}

