/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.ForgeDirection;
import openblocks.Config;
import openmods.api.INeighbourAwareTile;
import openmods.api.ISurfaceAttachment;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncableBoolean;
import openmods.tileentity.SyncedTileEntity;

public class TileEntityTarget
extends SyncedTileEntity
implements ISurfaceAttachment,
INeighbourAwareTile {
    private int strength = 0;
    private int tickCounter = -1;
    private SyncableBoolean active;

    protected void createSyncedFields() {
        this.active = new SyncableBoolean();
    }

    public void func_70316_g() {
        super.func_70316_g();
        --this.tickCounter;
        if (this.tickCounter == 0) {
            this.tickCounter = -1;
            this.strength = 0;
            this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, Config.blockTargetId);
        }
    }

    public void setEnabled(boolean en) {
        this.active.setValue(en);
    }

    public boolean isEnabled() {
        return this.active.getValue();
    }

    public float getTargetRotation() {
        return this.isEnabled() ? 0.0f : -1.5707964f;
    }

    public int getStrength() {
        return this.strength;
    }

    public void setStrength(int strength) {
        this.strength = strength;
        this.tickCounter = 10;
        this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, Config.blockTargetId);
    }

    private void onRedstoneChanged() {
        boolean isPowered = this.field_70331_k.func_72864_z(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        if (isPowered == this.isEnabled()) {
            return;
        }
        if (!isPowered) {
            List arrows = this.field_70331_k.func_72872_a(EntityArrow.class, AxisAlignedBB.func_72332_a().func_72299_a((double)this.field_70329_l - 0.1, (double)this.field_70330_m - 0.1, (double)this.field_70327_n - 0.1, (double)this.field_70329_l + 1.1, (double)this.field_70330_m + 1.1, (double)this.field_70327_n + 1.1));
            if (arrows.size() > 0) {
                ItemStack newStack = new ItemStack(Item.field_77704_l, arrows.size(), 0);
                EntityItem item = new EntityItem(this.field_70331_k, (double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5, newStack);
                this.field_70331_k.func_72838_d((Entity)item);
            }
            for (EntityArrow arrow : arrows) {
                arrow.func_70106_y();
            }
        }
        this.field_70331_k.func_72908_a((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5, isPowered ? "openblocks:open" : "openblocks:close", 0.5f, 1.0f);
        this.setEnabled(isPowered);
        this.sync();
    }

    public ForgeDirection getSurfaceDirection() {
        return ForgeDirection.DOWN;
    }

    @SideOnly(value=Side.CLIENT)
    public void prepareForInventoryRender(Block block, int metadata) {
        super.prepareForInventoryRender(block, metadata);
        this.setEnabled(true);
    }

    public void onSynced(Set<ISyncableObject> changes) {
    }

    public void onNeighbourChanged(int blockId) {
        this.onRedstoneChanged();
    }
}

