/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import openblocks.Config;
import openblocks.OpenBlocks;
import openmods.api.IActivateAwareTile;
import openmods.api.INeighbourAwareTile;
import openmods.api.IPlaceAwareTile;
import openmods.include.IExtendable;
import openmods.include.IncludeInterface;
import openmods.include.IncludeOverride;
import openmods.liquids.GenericFluidHandler;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncableTank;
import openmods.tileentity.SyncedTileEntity;
import openmods.utils.EnchantmentUtils;
import openmods.utils.ItemUtils;

public class TileEntityTank
extends SyncedTileEntity
implements INeighbourAwareTile,
IPlaceAwareTile,
IActivateAwareTile,
IExtendable {
    private SyncableTank tank;
    private double flowTimer = Math.random() * 100.0;
    private int previousFluidId = 0;
    @IncludeInterface(value=IFluidHandler.class)
    private final GenericFluidHandler tankWrapper = new GenericFluidHandler((IFluidTank)this.tank);
    public HashMap<ForgeDirection, WeakReference<TileEntityTank>> neighbours = new HashMap();
    public HashMap<ForgeDirection, Boolean> surroundingBlocks = new HashMap();
    public static final ForgeDirection[] horizontalDirections = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.EAST, ForgeDirection.WEST};
    protected Comparator<TileEntityTank> sortBySpace = new Comparator<TileEntityTank>(){

        @Override
        public int compare(TileEntityTank c1, TileEntityTank c2) {
            return c2.getSpace() - c1.getSpace();
        }
    };

    public static int getTankCapacity() {
        return 1000 * Config.bucketsPerTank;
    }

    protected void createSyncedFields() {
        this.tank = new SyncableTank(TileEntityTank.getTankCapacity(), new FluidStack[0]);
    }

    protected void updateNeighbours() {
        TileEntityTank up = this.getTankInDirection(ForgeDirection.UP);
        TileEntityTank down = this.getTankInDirection(ForgeDirection.DOWN);
        TileEntityTank north = this.getTankInDirection(ForgeDirection.NORTH);
        TileEntityTank south = this.getTankInDirection(ForgeDirection.SOUTH);
        TileEntityTank east = this.getTankInDirection(ForgeDirection.EAST);
        TileEntityTank west = this.getTankInDirection(ForgeDirection.WEST);
        if (up != null) {
            up.findNeighbours();
        }
        if (down != null) {
            down.findNeighbours();
        }
        if (north != null) {
            north.findNeighbours();
        }
        if (south != null) {
            south.findNeighbours();
        }
        if (east != null) {
            east.findNeighbours();
        }
        if (west != null) {
            west.findNeighbours();
        }
    }

    protected void findNeighbours() {
        this.neighbours.clear();
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity neighbour = this.getTileInDirection(direction);
            if (neighbour != null && neighbour instanceof TileEntityTank) {
                this.neighbours.put(direction, new WeakReference<TileEntityTank>((TileEntityTank)neighbour));
            }
            this.surroundingBlocks.put(direction, !this.field_70331_k.func_72799_c(this.field_70329_l + direction.offsetX, this.field_70330_m + direction.offsetY, this.field_70327_n + direction.offsetZ));
        }
        if (!this.field_70331_k.field_72995_K) {
            this.sendBlockEvent(0, 0);
        }
    }

    public boolean hasBlockOnSide(ForgeDirection side) {
        return this.surroundingBlocks.containsKey(side) && this.surroundingBlocks.get(side) != false;
    }

    public TileEntityTank getTankInDirection(ForgeDirection direction) {
        WeakReference<TileEntityTank> neighbour;
        if (this.neighbours.containsKey(direction) && (neighbour = this.neighbours.get(direction)) != null) {
            TileEntityTank otherTank = (TileEntityTank)((Object)neighbour.get());
            if (otherTank == null) {
                return null;
            }
            if (otherTank.func_70320_p()) {
                return null;
            }
            if (otherTank.canReceiveLiquid(this.getTank().getFluid())) {
                return otherTank;
            }
        }
        return null;
    }

    public TileEntityTank[] getSurroundingTanks() {
        ArrayList<TileEntityTank> tanks = new ArrayList<TileEntityTank>();
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            TileEntityTank t = this.getTankInDirection(direction);
            if (t == null) continue;
            tanks.add(t);
        }
        return tanks.toArray(new TileEntityTank[tanks.size()]);
    }

    public ArrayList<TileEntityTank> getHorizontalTanksOrdererdBySpace(HashSet<TileEntityTank> except) {
        ArrayList<TileEntityTank> horizontalTanks = new ArrayList<TileEntityTank>();
        for (ForgeDirection direction : horizontalDirections) {
            TileEntityTank tank = this.getTankInDirection(direction);
            if (tank == null || except.contains((Object)tank)) continue;
            horizontalTanks.add(tank);
        }
        Collections.sort(horizontalTanks, this.sortBySpace);
        return horizontalTanks;
    }

    public void onNeighbourChanged(int blockId) {
        this.findNeighbours();
    }

    public boolean func_70315_b(int eventId, int eventParam) {
        if (this.field_70331_k.field_72995_K) {
            this.findNeighbours();
        }
        return true;
    }

    public boolean containsValidLiquid() {
        return this.tank.getFluid() != null;
    }

    protected void initialize() {
        this.findNeighbours();
        this.updateNeighbours();
    }

    public void func_70316_g() {
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K) {
            HashSet<TileEntityTank> except = new HashSet<TileEntityTank>();
            except.add(this);
            if (this.tank.getFluid() != null) {
                FluidStack myLiquid;
                TileEntityTank below = this.getTankInDirection(ForgeDirection.DOWN);
                if (below != null && below.getSpace() > 0 && below.canReceiveLiquid(myLiquid = this.tank.getFluid().copy())) {
                    int toFill;
                    myLiquid.amount = toFill = Math.min(below.getSpace(), myLiquid.amount);
                    int filled = below.fill(myLiquid, true, except);
                    this.tank.drain(filled, true);
                }
                if (this.containsValidLiquid()) {
                    ArrayList<TileEntityTank> horizontals = this.getHorizontalTanksOrdererdBySpace(except);
                    for (TileEntityTank horizontal : horizontals) {
                        int difference;
                        FluidStack liquid;
                        if (!horizontal.canReceiveLiquid(liquid = this.tank.getFluid()) || liquid == null || (difference = this.tank.getFluidAmount() - horizontal.getTank().getFluidAmount()) <= 0) continue;
                        int halfDifference = Math.max(difference / 2, 1);
                        FluidStack liquidCopy = liquid.copy();
                        liquidCopy.amount = Math.min(500, halfDifference);
                        int filled = horizontal.fill(liquidCopy, true, except);
                        this.tank.drain(filled, true);
                    }
                }
            }
            this.sync();
        } else {
            this.flowTimer += (double)0.1f;
        }
    }

    public boolean canReceiveLiquid(FluidStack liquid) {
        if (this.tank.getFluid() == null) {
            return true;
        }
        if (liquid == null) {
            return true;
        }
        FluidStack otherLiquid = this.tank.getFluid();
        if (otherLiquid != null) {
            return otherLiquid.isFluidEqual(liquid);
        }
        return true;
    }

    public IFluidTank getTank() {
        return this.tank;
    }

    public boolean isFull() {
        return this.tank.getSpace() == 0;
    }

    public int getSpace() {
        return this.tank.getSpace();
    }

    public int fill(FluidStack resource, boolean doFill, HashSet<TileEntityTank> except) {
        ArrayList<TileEntityTank> horizontals;
        TileEntityTank above;
        TileEntityTank below = this.getTankInDirection(ForgeDirection.DOWN);
        int filled = 0;
        if (except == null) {
            except = new HashSet();
        }
        if (resource == null) {
            return 0;
        }
        int startAmount = resource.amount;
        if (except.contains((Object)this)) {
            return 0;
        }
        except.add(this);
        resource = resource.copy();
        if (below != null && below.getSpace() > 0) {
            filled = below.fill(resource, doFill, except);
            resource.amount -= filled;
        }
        if (resource.amount > 0) {
            filled = this.tank.fill(resource, doFill);
            resource.amount -= filled;
        }
        if (resource.amount > 0 && (above = this.getTankInDirection(ForgeDirection.UP)) != null) {
            filled = above.fill(resource, doFill, except);
            resource.amount -= filled;
        }
        if (resource.amount > 0 && this.canReceiveLiquid(resource) && (horizontals = this.getHorizontalTanksOrdererdBySpace(except)).size() > 0) {
            int amountPerSide = resource.amount / horizontals.size();
            for (TileEntityTank sideTank : horizontals) {
                FluidStack copy = resource.copy();
                copy.amount = amountPerSide;
                filled = sideTank.fill(copy, doFill, except);
                resource.amount -= filled;
            }
        }
        return startAmount - resource.amount;
    }

    public void onSynced(Set<ISyncableObject> changes) {
        int newFluidId;
        int n = newFluidId = this.tank.getFluid() == null ? 0 : this.tank.getFluid().fluidID;
        if (newFluidId != this.previousFluidId) {
            this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
        this.previousFluidId = newFluidId;
    }

    public void onBlockPlacedBy(EntityPlayer player, ForgeDirection side, ItemStack stack, float hitX, float hitY, float hitZ) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("tank")) {
            NBTTagCompound tankTag = stack.func_77978_p().func_74775_l("tank");
            this.tank.readFromNBT(tankTag);
        }
    }

    public int countDownwardsTanks() {
        int count = 1;
        TileEntityTank below = this.getTankInDirection(ForgeDirection.DOWN);
        if (below != null) {
            count += below.countDownwardsTanks();
        }
        return count;
    }

    public boolean onBlockActivated(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        int currentXP;
        int currentLevel;
        int nextXP;
        int requiredXP;
        int requiredXPJuice;
        FluidStack drained;
        ForgeDirection direction = ForgeDirection.getOrientation((int)side);
        ItemStack current = player.field_71071_by.func_70448_g();
        if (current != null) {
            ItemStack filled;
            FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)current);
            if (liquid != null) {
                int qty = this.fill(direction, liquid, true);
                if (qty != 0 && !player.field_71075_bZ.field_75098_d) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemUtils.consumeItem((ItemStack)current));
                }
                return true;
            }
            FluidStack available = this.tank.getFluid();
            if (this.field_70331_k.field_72995_K && this.getTank().getFluidAmount() > 0) {
                return true;
            }
            if (available != null && (liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)(filled = FluidContainerRegistry.fillFluidContainer((FluidStack)available, (ItemStack)current)))) != null) {
                if (!player.field_71075_bZ.field_75098_d) {
                    if (current.field_77994_a > 1) {
                        if (!player.field_71071_by.func_70441_a(filled)) {
                            return false;
                        }
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemUtils.consumeItem((ItemStack)current));
                    } else {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemUtils.consumeItem((ItemStack)current));
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, filled);
                    }
                }
                this.tank.drain(liquid.amount, true);
                return true;
            }
        } else if (this.tank.getFluid() != null && this.tank.getFluid().isFluidEqual(OpenBlocks.XP_FLUID) && (drained = this.tank.drain(requiredXPJuice = EnchantmentUtils.XPToLiquidRatio((int)(requiredXP = (nextXP = EnchantmentUtils.getExperienceForLevel((int)((currentLevel = EnchantmentUtils.getLevelForExperience((int)(currentXP = EnchantmentUtils.getPlayerXP((EntityPlayer)player)))) + 1))) - currentXP)), true)) != null) {
            EnchantmentUtils.addPlayerXP((EntityPlayer)player, (int)EnchantmentUtils.liquidToXPRatio((int)drained.amount));
        }
        return false;
    }

    public double getHeightForRender() {
        return (double)this.tank.getFluidAmount() / (double)this.tank.getCapacity();
    }

    public double getPercentFull() {
        return this.tank.getPercentFull();
    }

    public double getFlowOffset() {
        return Math.sin(this.flowTimer) / 35.0;
    }

    public double getLiquidHeightForSide(ForgeDirection ... sides) {
        if (this.containsValidLiquid()) {
            double percentFull = this.getHeightForRender();
            if (percentFull > 0.98) {
                return 1.0;
            }
            double fullness = percentFull + this.getFlowOffset();
            int count = 1;
            for (ForgeDirection side : sides) {
                TileEntityTank sideTank = this.getTankInDirection(side);
                if (sideTank == null || !sideTank.canReceiveLiquid(this.tank.getFluid())) continue;
                fullness += sideTank.getHeightForRender() + sideTank.getFlowOffset();
                ++count;
            }
            return Math.max(0.0, Math.min(1.0, fullness / (double)count));
        }
        return 0.0;
    }

    public NBTTagCompound getItemNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.tank.writeToNBT(nbt);
        return nbt;
    }

    @IncludeOverride
    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.fill(resource, doFill, null);
    }

    public int getFluidLightLevel() {
        FluidStack fluid = this.tank.getFluid();
        if (fluid != null) {
            try {
                return fluid.getFluid().getLuminosity();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }
}

