/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import openblocks.client.gui.GuiProjector;
import openblocks.common.HeightMapData;
import openblocks.common.MapDataManager;
import openblocks.common.container.ContainerProjector;
import openblocks.common.item.ItemEmptyMap;
import openblocks.common.item.ItemHeightMap;
import openmods.GenericInventory;
import openmods.IInventoryProvider;
import openmods.api.IHasGui;
import openmods.api.IInventoryCallback;
import openmods.include.IExtendable;
import openmods.include.IncludeInterface;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncableByte;
import openmods.sync.SyncableInt;
import openmods.tileentity.SyncedTileEntity;

public class TileEntityProjector
extends SyncedTileEntity
implements IHasGui,
IInventoryProvider,
IExtendable {
    private GenericInventory inventory = new GenericInventory("openblocks.projector", false, 1){

        public boolean func_94041_b(int i, ItemStack stack) {
            return stack == null || stack.func_77973_b() instanceof ItemHeightMap;
        }

        public int func_70297_j_() {
            return 1;
        }

        public void onInventoryChanged(int slotNumber) {
            super.onInventoryChanged(slotNumber);
            if (!TileEntityProjector.this.func_70320_p()) {
                if (!TileEntityProjector.this.field_70331_k.field_72995_K) {
                    ItemStack stack = this.func_70301_a(slotNumber);
                    if (stack != null && stack.field_77994_a == 1) {
                        Item item = stack.func_77973_b();
                        if (item instanceof ItemHeightMap) {
                            int mapId = stack.func_77960_j();
                            TileEntityProjector.this.mapId.setValue(mapId);
                        } else if (item instanceof ItemEmptyMap && TileEntityProjector.this.field_70331_k != null) {
                            ItemStack newStack = ItemEmptyMap.upgradeToMap(TileEntityProjector.this.field_70331_k, stack);
                            this.func_70299_a(slotNumber, newStack);
                        } else {
                            TileEntityProjector.this.mapId.setValue(-1);
                        }
                    } else {
                        TileEntityProjector.this.mapId.setValue(-1);
                    }
                    TileEntityProjector.this.sync();
                }
                TileEntityProjector.this.field_70331_k.func_72944_b(TileEntityProjector.this.field_70329_l, TileEntityProjector.this.field_70330_m, TileEntityProjector.this.field_70327_n, (TileEntity)TileEntityProjector.this);
            }
        }
    };
    private SyncableByte rotation;
    private SyncableInt mapId;

    public GenericInventory addUpdateCallback(MapInventory inventory, TileEntity te) {
        inventory.addCallback(new IInventoryCallback(){

            public void onInventoryChanged(IInventory inventory, int slotNumber) {
            }
        });
        return inventory;
    }

    protected void createSyncedFields() {
        this.rotation = new SyncableByte();
        this.mapId = new SyncableInt(-1);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72332_a().func_72299_a((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, (double)(this.field_70329_l + 1), (double)(this.field_70330_m + 5), (double)(this.field_70327_n + 1));
    }

    public void func_70312_q() {
        super.func_70312_q();
        this.inventory.onInventoryChanged(0);
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0 || pass == 1;
    }

    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        this.inventory.readFromNBT(tag);
    }

    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        this.inventory.writeToNBT(tag);
    }

    public Object getServerGui(EntityPlayer player) {
        return new ContainerProjector((IInventory)player.field_71071_by, this);
    }

    public Object getClientGui(EntityPlayer player) {
        return new GuiProjector(new ContainerProjector((IInventory)player.field_71071_by, this));
    }

    public boolean canOpenGui(EntityPlayer player) {
        return true;
    }

    public void onSynced(Set<ISyncableObject> changes) {
        int mapId;
        if (this.field_70331_k.field_72995_K && changes.contains(this.mapId) && (mapId = this.mapId.getValue()) >= 0 && MapDataManager.getMapData(this.field_70331_k, mapId).isEmpty()) {
            MapDataManager.requestMapData(this.field_70331_k, mapId);
        }
    }

    public void rotate(int delta) {
        int value = this.rotation.getValue() + delta;
        this.rotation.setValue((byte)(value & 3));
        this.sync();
    }

    public byte rotation() {
        return this.rotation.getValue();
    }

    public int mapId() {
        return this.mapId.getValue();
    }

    public HeightMapData getMap() {
        int mapId = this.mapId.getValue();
        if (this.field_70331_k == null || mapId < 0) {
            return null;
        }
        return MapDataManager.getMapData(this.field_70331_k, mapId);
    }

    public void markMapDirty() {
        int mapId = this.mapId.getValue();
        if (this.field_70331_k != null || mapId < 0) {
            MapDataManager.instance.markDataUpdated(this.field_70331_k, mapId);
        }
    }

    public void fetchMap() {
        int mapId = this.mapId.getValue();
        if (this.field_70331_k != null && mapId >= 0) {
            MapDataManager.getMapData(this.field_70331_k, mapId);
        }
    }

    @IncludeInterface
    public IInventory getInventory() {
        return this.inventory;
    }

    public static class MapInventory
    extends GenericInventory {
        public MapInventory(String name, boolean isInvNameLocalized, int size) {
            super(name, isInvNameLocalized, size);
        }
    }
}

