/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;
import openblocks.OpenBlocks;
import openblocks.client.gui.GuiPaintMixer;
import openblocks.common.container.ContainerPaintMixer;
import openblocks.common.item.ItemPaintCan;
import openmods.GenericInventory;
import openmods.IInventoryProvider;
import openmods.api.IHasGui;
import openmods.api.IInventoryCallback;
import openmods.include.IExtendable;
import openmods.include.IncludeInterface;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncableFlags;
import openmods.sync.SyncableFloat;
import openmods.sync.SyncableInt;
import openmods.sync.SyncableProgress;
import openmods.tileentity.SyncedTileEntity;
import openmods.utils.ColorUtils;

public class TileEntityPaintMixer
extends SyncedTileEntity
implements IInventoryProvider,
IHasGui,
IInventoryCallback,
IExtendable {
    private static final ItemStack PAINT_CAN = new ItemStack((Block)OpenBlocks.Blocks.paintCan);
    private static final ItemStack MILK_BUCKET = new ItemStack(Item.field_77771_aG);
    private static final int PROGRESS_TICKS = 300;
    private static EnumMap<Slots, Integer> ALLOWED_COLORS = Maps.newEnumMap(Slots.class);
    private SyncableInt canColor;
    private SyncableInt color;
    private boolean isWorking;
    private SyncableProgress progress;
    private SyncableFlags flags;
    private int chosenColor;
    public SyncableFloat lvlCyan;
    public SyncableFloat lvlMagenta;
    public SyncableFloat lvlYellow;
    public SyncableFloat lvlBlack;
    private GenericInventory inventory = new GenericInventory("paintmixer", true, 6){

        public boolean func_94041_b(int slotId, ItemStack stack) {
            Slots[] values = Slots.values();
            if (stack == null || slotId < 0 || slotId > values.length) {
                return false;
            }
            Slots slot = values[slotId];
            if (slot == Slots.paint) {
                return PAINT_CAN.func_77969_a(stack) || MILK_BUCKET.func_77969_a(stack);
            }
            return TileEntityPaintMixer.isValidForSlot(slot, stack);
        }
    };

    public TileEntityPaintMixer() {
        this.inventory.addCallback((IInventoryCallback)this);
    }

    public void initialize() {
        if (!this.field_70331_k.field_72995_K) {
            this.sync();
        }
    }

    public void func_70316_g() {
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K) {
            if (this.chosenColor != this.color.getValue()) {
                this.progress.reset();
                this.isWorking = false;
            }
            if (this.isWorking) {
                if (!this.hasValidInput() || !this.hasCMYK()) {
                    this.progress.reset();
                    this.isWorking = false;
                    return;
                }
                if (!this.progress.isComplete()) {
                    this.progress.increase();
                } else {
                    this.consumeInk();
                    ItemStack output = ItemPaintCan.createStack(this.color.getValue(), 30);
                    this.inventory.func_70299_a(Slots.paint.ordinal(), output);
                    this.canColor.setValue(this.color.getValue());
                    this.progress.reset();
                    this.isWorking = false;
                }
            }
            this.checkAutoConsumption();
            this.sync();
        }
    }

    private void checkAutoConsumption() {
        if (this.lvlCyan.getValue() <= 1.0f && this.tryUseInk(Slots.dyeCyan, 1)) {
            this.lvlCyan.setValue(this.lvlCyan.getValue() + 1.0f);
        }
        if (this.lvlMagenta.getValue() <= 1.0f && this.tryUseInk(Slots.dyeMagenta, 1)) {
            this.lvlMagenta.setValue(this.lvlMagenta.getValue() + 1.0f);
        }
        if (this.lvlYellow.getValue() <= 1.0f && this.tryUseInk(Slots.dyeYellow, 1)) {
            this.lvlYellow.setValue(this.lvlYellow.getValue() + 1.0f);
        }
        if (this.lvlBlack.getValue() <= 1.0f && this.tryUseInk(Slots.dyeBlack, 1)) {
            this.lvlBlack.setValue(this.lvlBlack.getValue() + 1.0f);
        }
    }

    public boolean hasCMYK() {
        return this.hasSufficientInk();
    }

    private void consumeInk() {
        ColorUtils.CYMK cymk = new ColorUtils.RGB(this.color.getValue()).toCYMK();
        this.lvlCyan.setValue(this.lvlCyan.getValue() - cymk.getCyan());
        this.lvlBlack.setValue(this.lvlBlack.getValue() - cymk.getKey());
        this.lvlYellow.setValue(this.lvlYellow.getValue() - cymk.getYellow());
        this.lvlMagenta.setValue(this.lvlMagenta.getValue() - cymk.getMagenta());
    }

    private boolean hasSufficientInk() {
        ColorUtils.CYMK cymk = new ColorUtils.RGB(this.color.getValue()).toCYMK();
        if (cymk.getCyan() > this.lvlCyan.getValue()) {
            if (this.tryUseInk(Slots.dyeCyan, 1)) {
                this.lvlCyan.setValue(this.lvlCyan.getValue() + 1.0f);
            } else {
                return false;
            }
        }
        if (cymk.getYellow() > this.lvlYellow.getValue()) {
            if (this.tryUseInk(Slots.dyeYellow, 1)) {
                this.lvlYellow.setValue(this.lvlYellow.getValue() + 1.0f);
            } else {
                return false;
            }
        }
        if (cymk.getMagenta() > this.lvlMagenta.getValue()) {
            if (this.tryUseInk(Slots.dyeMagenta, 1)) {
                this.lvlMagenta.setValue(this.lvlMagenta.getValue() + 1.0f);
            } else {
                return false;
            }
        }
        if (cymk.getKey() > this.lvlBlack.getValue()) {
            if (this.tryUseInk(Slots.dyeBlack, 1)) {
                this.lvlBlack.setValue(this.lvlBlack.getValue() + 1.0f);
            } else {
                return false;
            }
        }
        return true;
    }

    public boolean tryUseInk(Slots slot, int consume) {
        ItemStack stack = this.inventory.getStackInSlot((Enum)slot);
        return TileEntityPaintMixer.isValidForSlot(slot, stack) && this.inventory.func_70298_a(slot.ordinal(), consume) != null;
    }

    private static boolean isValidForSlot(Slots slot, ItemStack stack) {
        Integer allowedColor = ALLOWED_COLORS.get((Object)slot);
        return allowedColor != null && stack != null && OreDictionary.getOreID((ItemStack)stack) == allowedColor;
    }

    protected void createSyncedFields() {
        this.color = new SyncableInt(0xFF0000);
        this.flags = new SyncableFlags();
        this.progress = new SyncableProgress(300);
        this.lvlBlack = new SyncableFloat();
        this.lvlCyan = new SyncableFloat();
        this.lvlMagenta = new SyncableFloat();
        this.lvlYellow = new SyncableFloat();
        this.canColor = new SyncableInt(0xFFFFFF);
    }

    public SyncableInt getColor() {
        return this.color;
    }

    public boolean hasPaint() {
        return this.flags.get((Enum)Flags.hasPaint);
    }

    public void onSynced(Set<ISyncableObject> changes) {
    }

    public void onSync() {
    }

    public Object getServerGui(EntityPlayer player) {
        return new ContainerPaintMixer((IInventory)player.field_71071_by, this);
    }

    public Object getClientGui(EntityPlayer player) {
        return new GuiPaintMixer(new ContainerPaintMixer((IInventory)player.field_71071_by, this));
    }

    public boolean canOpenGui(EntityPlayer player) {
        return true;
    }

    public void tryStartMixer() {
        if (!this.field_70331_k.field_72995_K) {
            this.isWorking = true;
            this.chosenColor = this.color.getValue();
        }
    }

    public SyncableProgress getProgress() {
        return this.progress;
    }

    public int getCanColor() {
        return this.canColor.getValue();
    }

    public boolean isEnabled() {
        return this.progress.getValue() > 0;
    }

    public boolean hasValidInput() {
        return this.hasStack(Slots.paint, PAINT_CAN) || this.hasStack(Slots.paint, MILK_BUCKET);
    }

    private static Integer getColor(ItemStack stack) {
        if (stack.func_77969_a(PAINT_CAN)) {
            return ItemPaintCan.getColorFromStack(stack);
        }
        if (stack.func_77969_a(MILK_BUCKET)) {
            return 0xFFFFFF;
        }
        return null;
    }

    public void onInventoryChanged(IInventory invent, int slotNumber) {
        if (!this.field_70331_k.field_72995_K) {
            Integer c;
            boolean hasPaint = false;
            ItemStack can = this.inventory.getStackInSlot((Enum)Slots.paint);
            if (can != null && (c = TileEntityPaintMixer.getColor(can)) != null) {
                this.color.setValue(c.intValue());
                this.canColor.setValue(c.intValue());
                hasPaint = true;
            }
            this.flags.set((Enum)Flags.hasPaint, hasPaint);
            this.sync();
        }
    }

    private boolean hasStack(Slots slot, ItemStack stack) {
        ItemStack gotStack = this.inventory.getStackInSlot((Enum)slot);
        if (gotStack == null) {
            return false;
        }
        return gotStack.func_77969_a(stack);
    }

    @IncludeInterface
    public IInventory getInventory() {
        return this.inventory;
    }

    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        this.inventory.writeToNBT(tag);
    }

    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        this.inventory.readFromNBT(tag);
    }

    static {
        ALLOWED_COLORS.put(Slots.dyeBlack, OreDictionary.getOreID((String)"dyeBlack"));
        ALLOWED_COLORS.put(Slots.dyeCyan, OreDictionary.getOreID((String)"dyeCyan"));
        ALLOWED_COLORS.put(Slots.dyeMagenta, OreDictionary.getOreID((String)"dyeMagenta"));
        ALLOWED_COLORS.put(Slots.dyeYellow, OreDictionary.getOreID((String)"dyeYellow"));
    }

    public static enum Flags {
        hasPaint;

    }

    public static enum Slots {
        paint,
        reserved,
        dyeCyan,
        dyeMagenta,
        dyeYellow,
        dyeBlack;

    }
}

