/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.common.ForgeDirection;
import openblocks.api.IShapeProvider;
import openblocks.shapes.GuideShape;
import openmods.Log;
import openmods.shapes.IShapeable;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncableInt;
import openmods.tileentity.SyncedTileEntity;
import openmods.utils.CompatibilityUtils;

public class TileEntityGuide
extends SyncedTileEntity
implements IShapeable,
IShapeProvider {
    private boolean[][][] shape;
    private boolean[][][] previousShape;
    private float timeSinceChange = 0.0f;
    protected SyncableInt width;
    protected SyncableInt height;
    protected SyncableInt depth;
    protected SyncableInt mode;

    protected void createSyncedFields() {
        this.width = new SyncableInt(8);
        this.height = new SyncableInt(8);
        this.depth = new SyncableInt(8);
        this.mode = new SyncableInt(0);
    }

    public int getWidth() {
        return this.width.getValue();
    }

    public int getHeight() {
        return this.height.getValue();
    }

    public int getDepth() {
        return this.depth.getValue();
    }

    public void setWidth(int w) {
        this.width.setValue(w);
    }

    public void setDepth(int d) {
        this.depth.setValue(d);
    }

    public void setHeight(int h) {
        this.height.setValue(h);
    }

    public GuideShape getCurrentMode() {
        return GuideShape.values()[this.mode.getValue()];
    }

    public void func_70316_g() {
        if (this.field_70331_k.field_72995_K && (double)this.timeSinceChange < 1.0) {
            this.timeSinceChange = (float)Math.min(1.0, (double)this.timeSinceChange + 0.1);
        }
    }

    public float getTimeSinceChange() {
        return this.timeSinceChange;
    }

    private void recreateShape() {
        this.previousShape = this.shape;
        this.shape = new boolean[this.getHeight() * 2 + 1][this.getWidth() * 2 + 1][this.getDepth() * 2 + 1];
        this.getCurrentMode().generator.generateShape(this.getWidth(), this.getHeight(), this.getDepth(), (IShapeable)this);
        this.timeSinceChange = 0.0f;
    }

    public void setBlock(int x, int y, int z) {
        try {
            this.shape[this.getHeight() + y][this.getWidth() + x][this.getDepth() + z] = true;
        }
        catch (IndexOutOfBoundsException iobe) {
            Log.warn((Throwable)iobe, (String)"Index out of bounds setting block at %d,%d,%d", (Object[])new Object[]{x, y, z});
        }
    }

    public boolean[][][] getShape() {
        return this.shape;
    }

    public boolean[][][] getPreviousShape() {
        return this.previousShape;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB box = super.getRenderBoundingBox();
        return box.func_72314_b((double)this.getWidth(), (double)this.getHeight(), (double)this.getDepth());
    }

    public void switchMode(EntityPlayer player) {
        this.switchMode();
        if (player != null) {
            CompatibilityUtils.sendChatToPlayer((EntityPlayer)player, (String)String.format("Changing to %s mode", this.getCurrentMode().getDisplayName()));
        }
    }

    public void switchMode() {
        int nextMode = this.mode.getValue() + 1;
        if (nextMode >= GuideShape.values().length) {
            nextMode = 0;
        }
        this.mode.setValue(nextMode);
        if (this.getCurrentMode().fixedRatio) {
            this.setHeight(this.getWidth());
            this.setDepth(this.getWidth());
        }
        this.recreateShape();
        this.sync();
    }

    public void changeDimensions(EntityPlayer player, ForgeDirection orientation) {
        this.changeDimensions(orientation);
        CompatibilityUtils.sendChatToPlayer((EntityPlayer)player, (String)String.format("Changing size to %sx%sx%s", this.width.getValue(), this.height.getValue(), this.depth.getValue()));
    }

    public void changeDimensions(ForgeDirection orientation) {
        if (this.width.getValue() > 0 && orientation == ForgeDirection.EAST) {
            this.width.modify(-1);
        } else if (orientation == ForgeDirection.WEST) {
            this.width.modify(1);
        } else if (orientation == ForgeDirection.NORTH) {
            this.depth.modify(1);
        } else if (this.depth.getValue() > 0 && orientation == ForgeDirection.SOUTH) {
            this.depth.modify(-1);
        } else if (orientation == ForgeDirection.UP) {
            this.height.modify(1);
        } else if (this.height.getValue() > 0 && orientation == ForgeDirection.DOWN) {
            this.height.modify(-1);
        }
        if (this.getCurrentMode().fixedRatio) {
            int h = this.getHeight();
            int w = this.getWidth();
            int d = this.getDepth();
            if (w != h && w != d) {
                this.setHeight(w);
                this.setDepth(w);
            } else if (h != w && h != d) {
                this.depth.setValue(h);
                this.width.setValue(h);
            } else if (d != w && d != h) {
                this.width.setValue(d);
                this.height.setValue(d);
            }
        }
        this.recreateShape();
        if (!this.field_70331_k.field_72995_K) {
            this.sync();
        }
    }

    @Override
    public ChunkCoordinates[] getShapeCoordinates() {
        if (this.shape == null) {
            this.recreateShape();
        }
        ArrayList<ChunkCoordinates> coords = new ArrayList<ChunkCoordinates>();
        if (this.shape != null) {
            for (int y2 = 0; y2 < this.shape.length; ++y2) {
                for (int x2 = 0; x2 < this.shape[y2].length; ++x2) {
                    for (int z2 = 0; z2 < this.shape[y2][x2].length; ++z2) {
                        if (!this.shape[y2][x2][z2]) continue;
                        coords.add(new ChunkCoordinates(this.field_70329_l + x2 - this.getWidth(), this.field_70330_m + y2 - this.getHeight(), this.field_70327_n + z2 - this.getDepth()));
                    }
                }
            }
        }
        return coords.toArray(new ChunkCoordinates[coords.size()]);
    }

    public void onSynced(Set<ISyncableObject> changes) {
        this.recreateShape();
    }

    public void fill(EntityPlayer player) {
        ItemStack held;
        if (player.func_70694_bm() != null && (held = player.func_70694_bm()).func_77973_b() instanceof ItemBlock) {
            ItemBlock itemblock = (ItemBlock)held.func_77973_b();
            for (ChunkCoordinates coord : this.getShapeCoordinates()) {
                this.field_70331_k.func_72832_d(coord.field_71574_a, coord.field_71572_b, coord.field_71573_c, itemblock.func_77883_f(), held.func_77960_j(), 3);
            }
        }
    }
}

