/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import openblocks.common.entity.EntityMutant;
import openmods.OpenMods;
import openmods.api.IPlaceAwareTile;
import openmods.entity.EntityBlock;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncableInt;
import openmods.tileentity.SyncedTileEntity;

public class TileEntityGoldenEgg
extends SyncedTileEntity
implements IPlaceAwareTile {
    private static final String TALLY_NBT_KEY = "tally";
    private static final int STAGE_CHANGE_TICK = 600;
    public static final int ANIMATION_TIME = 400;
    private static final double STAGE_CHANGE_CHANCE = 0.8;
    public int animationStageTicks = 0;
    public float rotation;
    private ArrayList<EntityBlock> blocks = new ArrayList();
    private HashMap<String, Integer> dnas = new HashMap();
    private SyncableInt stage;
    private String owner;

    protected void createSyncedFields() {
        this.stage = new SyncableInt(0);
    }

    private boolean stageElapsed() {
        return this.animationStageTicks > 0 ? this.animationStageTicks >= 400 : OpenMods.proxy.getTicks(this.field_70331_k) % 600L == 0L && this.field_70331_k.field_73012_v.nextDouble() < 0.8;
    }

    public void func_70316_g() {
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K) {
            if (this.stageElapsed()) {
                this.incrementStage();
                System.out.println("Egg entering stage" + this.stage.getValue());
            }
            if (this.stage.getValue() >= 1) {
                // empty if block
            }
            if (this.stage.getValue() >= 2) {
                // empty if block
            }
            if (this.stage.getValue() >= 3) {
                // empty if block
            }
            if (this.stage.getValue() >= 4) {
                EntityBlock block;
                int posX = this.field_70329_l + this.field_70331_k.field_73012_v.nextInt(20) - 10;
                int posY = this.field_70330_m + this.field_70331_k.field_73012_v.nextInt(2) - 1;
                int posZ = this.field_70327_n + this.field_70331_k.field_73012_v.nextInt(20) - 10;
                if (this.blocks != null && posX != this.field_70329_l && posY != this.field_70330_m && posZ != this.field_70327_n && this.field_70331_k.field_73012_v.nextInt(10) == 0 && (block = EntityBlock.create((World)this.field_70331_k, (int)posX, (int)posY, (int)posZ)) != null) {
                    block.setHasAirResistance(false);
                    block.setHasGravity(false);
                    block.setShouldDrop(false);
                    block.field_70181_x = 0.1;
                    this.blocks.add(block);
                    this.field_70331_k.func_72838_d((Entity)block);
                }
                if (400 - this.animationStageTicks < 20 && this.blocks != null) {
                    for (EntityBlock block2 : this.blocks) {
                        block2.setShouldDrop(true);
                        block2.field_70181_x = -0.9;
                        block2.setHasGravity(true);
                    }
                    this.blocks.clear();
                    this.blocks = null;
                }
            }
            if (this.stage.getValue() >= 5) {
                this.field_70331_k.func_94571_i(this.field_70329_l, this.field_70330_m, this.field_70327_n);
                this.field_70331_k.func_72876_a(null, 0.5 + (double)this.field_70329_l, 0.5 + (double)this.field_70330_m, 0.5 + (double)this.field_70327_n, 2.0f, true);
                EntityMutant mutant = new EntityMutant(this.field_70331_k);
                mutant.func_70910_a(this.owner);
                mutant.setTraitsFromMap(this.dnas);
                mutant.func_70080_a(0.5 + (double)this.field_70329_l, 0.5 + (double)this.field_70330_m, 0.5 + (double)this.field_70327_n, 0.0f, 0.0f);
                this.field_70331_k.func_72838_d((Entity)mutant);
            }
        }
        if (this.stage.getValue() >= 4 && this.animationStageTicks < 400) {
            ++this.animationStageTicks;
        }
    }

    public int getStage() {
        return this.stage.getValue();
    }

    private void incrementStage() {
        if (this.dnas.size() > 0) {
            this.stage.modify(1);
            this.sync();
        }
    }

    public boolean addDNAFromItemStack(ItemStack itemStack) {
        NBTTagCompound tag;
        if (itemStack != null && this.stage.getValue() == 0 && (tag = itemStack.func_77978_p()) != null && tag.func_74764_b("entity")) {
            String entity = tag.func_74779_i("entity");
            int count = 0;
            if (this.dnas.containsKey(entity)) {
                count = this.dnas.get(entity);
            }
            this.dnas.put(entity, count + 1);
            return true;
        }
        return false;
    }

    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        NBTTagCompound entitiesTag = new NBTTagCompound();
        for (Map.Entry<String, Integer> dnaTally : this.dnas.entrySet()) {
            entitiesTag.func_74768_a(dnaTally.getKey(), dnaTally.getValue().intValue());
        }
        nbt.func_74766_a(TALLY_NBT_KEY, entitiesTag);
        nbt.func_74778_a("owner", this.owner);
    }

    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.dnas.clear();
        if (nbt.func_74764_b(TALLY_NBT_KEY)) {
            NBTTagCompound tallyTag = nbt.func_74775_l(TALLY_NBT_KEY);
            for (NBTBase tag : tallyTag.func_74758_c()) {
                this.dnas.put(tag.func_74740_e(), tallyTag.func_74762_e(tag.func_74740_e()));
            }
        }
        this.owner = nbt.func_74779_i("owner");
    }

    public void onSynced(Set<ISyncableObject> changes) {
    }

    public void onBlockPlacedBy(EntityPlayer player, ForgeDirection side, ItemStack stack, float hitX, float hitY, float hitZ) {
        if (player != null) {
            this.owner = player.field_71092_bJ;
        }
    }
}

