/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import com.google.common.base.Preconditions;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.ForgeDirection;
import openblocks.Config;
import openblocks.events.PlayerMovementEvent;
import openmods.network.events.TileEntityMessageEventPacket;
import openmods.tileentity.OpenTileEntity;
import openmods.utils.EnchantmentUtils;

public class TileEntityElevator
extends OpenTileEntity {
    private boolean canTeleportPlayer(int x, int y, int z) {
        int blockId = this.field_70331_k.func_72798_a(x, y, z);
        Block block = Block.field_71973_m[blockId];
        if (block == null || block.isAirBlock(this.field_70331_k, x, y, z)) {
            return true;
        }
        if (!Config.irregularBlocksArePassable) {
            return false;
        }
        AxisAlignedBB aabb = block.func_71872_e(this.field_70331_k, x, y, z);
        return aabb == null || aabb.func_72320_b() < 0.7;
    }

    private static boolean isPassable(int blockId) {
        return Config.elevatorIgnoreHalfBlocks && !Block.func_71932_i((int)blockId);
    }

    private int findLevel(ForgeDirection direction) {
        Preconditions.checkArgument((direction == ForgeDirection.UP || direction == ForgeDirection.DOWN ? 1 : 0) != 0, (Object)"Must be either up or down... for now");
        int thisColor = this.getMetadata();
        int blocksInTheWay = 0;
        int delta = direction.offsetY;
        int y = this.field_70330_m;
        for (int i = 0; i < Config.elevatorTravelDistance && this.field_70331_k.func_72899_e(this.field_70329_l, y += delta, this.field_70327_n); ++i) {
            int otherColor;
            TileEntity otherBlock;
            if (this.field_70331_k.func_72799_c(this.field_70329_l, y, this.field_70327_n)) continue;
            int blockId = this.field_70331_k.func_72798_a(this.field_70329_l, y, this.field_70327_n);
            if (blockId == Config.blockElevatorId && (otherBlock = this.field_70331_k.func_72796_p(this.field_70329_l, y, this.field_70327_n)) instanceof TileEntityElevator && (otherColor = otherBlock.func_70322_n()) == thisColor && this.canTeleportPlayer(this.field_70329_l, y + 1, this.field_70327_n) && this.canTeleportPlayer(this.field_70329_l, y + 2, this.field_70327_n)) {
                return y;
            }
            if (!TileEntityElevator.isPassable(blockId) && ++blocksInTheWay > Config.elevatorMaxBlockPassCount) break;
        }
        return -1;
    }

    protected void initialize() {
    }

    private void activate(EntityPlayer player, ForgeDirection dir) {
        int level = this.findLevel(dir);
        if (level >= 0) {
            int distance = (int)Math.abs(player.field_70163_u - (double)level);
            boolean drainXP = Config.elevatorDrainsXP && !player.field_71075_bZ.field_75098_d;
            boolean doTeleport = false;
            if (drainXP) {
                int playerXP = EnchantmentUtils.getPlayerXP((EntityPlayer)player);
                if (playerXP >= distance) {
                    EnchantmentUtils.drainPlayerXP((EntityPlayer)player, (int)distance);
                    doTeleport = true;
                }
            } else {
                doTeleport = true;
            }
            if (doTeleport) {
                player.func_70634_a((double)this.field_70329_l + 0.5, (double)level + 1.1, (double)this.field_70327_n + 0.5);
                this.field_70331_k.func_72956_a((Entity)player, "openblocks:teleport", 1.0f, 1.0f);
            }
        }
    }

    public void onEvent(TileEntityMessageEventPacket event) {
        if (event instanceof PlayerMovementEvent) {
            switch (((PlayerMovementEvent)event).type) {
                case JUMP: {
                    this.activate((EntityPlayer)event.player, ForgeDirection.UP);
                    break;
                }
                case SNEAK: {
                    this.activate((EntityPlayer)event.player, ForgeDirection.DOWN);
                }
            }
        }
    }
}

