/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import openblocks.OpenBlocks;
import openblocks.common.Stencil;
import openblocks.common.item.ItemPaintBrush;
import openblocks.common.item.ItemSqueegee;
import openblocks.common.item.ItemStencil;
import openblocks.common.sync.SyncableBlockLayers;
import openmods.api.IActivateAwareTile;
import openmods.api.IBreakAwareTile;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncableInt;
import openmods.sync.SyncableIntArray;
import openmods.tileentity.SyncedTileEntity;
import openmods.utils.BlockUtils;

public class TileEntityCanvas
extends SyncedTileEntity
implements IActivateAwareTile,
IBreakAwareTile {
    private static final int BASE_LAYER = -1;
    public static final int[] ALL_SIDES = new int[]{0, 1, 2, 3, 4, 5};
    public SyncableInt paintedBlockId;
    public SyncableInt paintedBlockMeta;
    private SyncableIntArray baseColors;
    public SyncableBlockLayers stencilsUp;
    public SyncableBlockLayers stencilsDown;
    public SyncableBlockLayers stencilsEast;
    public SyncableBlockLayers stencilsWest;
    public SyncableBlockLayers stencilsNorth;
    public SyncableBlockLayers stencilsSouth;
    public SyncableBlockLayers[] allSides;

    public void initialize() {
    }

    public void setupForItemRenderer() {
        this.createSyncedFields();
    }

    public SyncableIntArray getBaseColors() {
        return this.baseColors;
    }

    protected void createSyncedFields() {
        this.stencilsUp = new SyncableBlockLayers();
        this.stencilsDown = new SyncableBlockLayers();
        this.stencilsEast = new SyncableBlockLayers();
        this.stencilsWest = new SyncableBlockLayers();
        this.stencilsNorth = new SyncableBlockLayers();
        this.stencilsSouth = new SyncableBlockLayers();
        this.allSides = new SyncableBlockLayers[]{this.stencilsDown, this.stencilsUp, this.stencilsNorth, this.stencilsSouth, this.stencilsWest, this.stencilsEast};
        this.baseColors = new SyncableIntArray(new int[]{0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF});
        this.paintedBlockId = new SyncableInt(0);
        this.paintedBlockMeta = new SyncableInt(0);
    }

    public SyncableBlockLayers getLayersForSide(int side) {
        return this.allSides[side];
    }

    public void onSynced(Set<ISyncableObject> changes) {
        this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public SyncableBlockLayers.Layer getLayerForSide(int renderSide, int layerId) {
        SyncableBlockLayers layers = this.getLayersForSide(renderSide);
        if (layers != null) {
            return layers.getLayer(layerId);
        }
        return null;
    }

    public int getColorForRender(int renderSide, int layerId) {
        if (layerId == -1) {
            return this.baseColors.getValue(renderSide);
        }
        SyncableBlockLayers.Layer layer = this.getLayerForSide(renderSide, layerId);
        if (layer != null) {
            return layer.getColorForRender();
        }
        return 0xCCCCCC;
    }

    public Icon getTextureForRender(int renderSide, int layerId) {
        Stencil stencil;
        SyncableBlockLayers.Layer layer;
        if (layerId > -1 && (layer = this.getLayerForSide(renderSide, layerId)) != null && (stencil = layer.getStencil()) != null) {
            return layer.hasStencilCover() ? stencil.getCoverBlockIcon() : stencil.getBlockIcon();
        }
        return this.getBaseTexture(renderSide);
    }

    private Icon getBaseTexture(int side) {
        if (this.paintedBlockId.getValue() == 0) {
            return OpenBlocks.Blocks.canvas.baseIcon;
        }
        Block block = Block.field_71973_m[this.paintedBlockId.getValue()];
        if (block == null) {
            return OpenBlocks.Blocks.canvas.baseIcon;
        }
        return block.func_71858_a(side, this.paintedBlockMeta.getValue());
    }

    private boolean isBlockUnpainted() {
        for (int i = 0; i < this.allSides.length; ++i) {
            if (this.allSides[i].isEmpty() && this.baseColors.getValue(i) == 0xFFFFFF) continue;
            return false;
        }
        return true;
    }

    public void applyPaint(int color, int ... sides) {
        for (int side : sides) {
            SyncableBlockLayers layer = this.getLayersForSide(side);
            if (layer.isLastLayerStencil()) {
                layer.setLastLayerColor(color);
                layer.moveStencilToNextLayer();
                continue;
            }
            layer.clear();
            this.baseColors.setValue(side, color);
        }
        if (!this.field_70331_k.field_72995_K) {
            this.sync();
        }
    }

    private void dropStackFromSide(ItemStack stack, int side) {
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        ForgeDirection dropSide = ForgeDirection.getOrientation((int)side);
        double dropX = this.field_70329_l + dropSide.offsetX;
        double dropY = this.field_70330_m + dropSide.offsetY;
        double dropZ = this.field_70327_n + dropSide.offsetZ;
        BlockUtils.dropItemStackInWorld((World)this.field_70331_k, (double)dropX, (double)dropY, (double)dropZ, (ItemStack)stack);
    }

    public void removePaint(int ... sides) {
        for (int side : sides) {
            SyncableBlockLayers layer = this.getLayersForSide(side);
            if (layer.isLastLayerStencil()) {
                Stencil stencil = layer.getTopStencil();
                ItemStack dropStack = new ItemStack((Item)OpenBlocks.Items.stencil, 1, stencil.ordinal());
                this.dropStackFromSide(dropStack, side);
            }
            layer.clear();
            this.baseColors.setValue(side, 0xFFFFFF);
        }
        if (this.isBlockUnpainted() && this.paintedBlockId.getValue() != 0) {
            this.field_70331_k.func_72832_d(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.paintedBlockId.getValue(), this.paintedBlockMeta.getValue(), 2);
        }
        if (!this.field_70331_k.field_72995_K) {
            this.sync();
        }
    }

    public boolean useStencil(int side, Stencil stencil) {
        SyncableBlockLayers layer = this.getLayersForSide(side);
        if (layer.isLastLayerStencil()) {
            Stencil topStencil = layer.getTopStencil();
            if (topStencil == stencil) {
                return false;
            }
            ItemStack dropStack = new ItemStack((Item)OpenBlocks.Items.stencil, 1, topStencil.ordinal());
            this.dropStackFromSide(dropStack, side);
            layer.setLastLayerStencil(stencil);
        } else {
            layer.pushNewStencil(stencil);
        }
        if (!this.field_70331_k.field_72995_K) {
            this.sync();
        }
        return true;
    }

    public boolean onBlockActivated(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        Item heldItem;
        ItemStack held = player.func_70694_bm();
        if (held != null && ((heldItem = held.func_77973_b()) instanceof ItemSqueegee || heldItem instanceof ItemPaintBrush || heldItem instanceof ItemStencil)) {
            return false;
        }
        SyncableBlockLayers layer = this.getLayersForSide(side);
        if (layer.isLastLayerStencil()) {
            if (player.func_70093_af()) {
                if (!this.field_70331_k.field_72995_K) {
                    ItemStack dropStack = new ItemStack((Item)OpenBlocks.Items.stencil, 1, layer.getTopStencil().ordinal());
                    this.dropStackFromSide(dropStack, side);
                }
                layer.removeCover();
            } else {
                this.getLayersForSide(side).rotateCover();
            }
            if (!this.field_70331_k.field_72995_K) {
                this.sync();
            }
            return true;
        }
        return false;
    }

    public void onBlockBroken() {
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        for (SyncableBlockLayers sideLayers : this.allSides) {
            Stencil stencil;
            if (!sideLayers.isLastLayerStencil() || (stencil = sideLayers.getTopStencil()) == null) continue;
            BlockUtils.dropItemStackInWorld((World)this.field_70331_k, (double)((double)this.field_70329_l + 0.5), (double)((double)this.field_70330_m + 0.5), (double)((double)this.field_70327_n + 0.5), (ItemStack)new ItemStack((Item)OpenBlocks.Items.stencil, 1, stencil.ordinal()));
        }
    }
}

