/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatMessageComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeDirection;
import openblocks.api.IPointable;
import openblocks.common.entity.EntityItemProjectile;
import openmods.api.IActivateAwareTile;
import openmods.network.events.TileEntityMessageEventPacket;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncableDouble;
import openmods.tileentity.OpenTileEntity;
import openmods.tileentity.SyncedTileEntity;
import openmods.utils.InventoryUtils;
import openmods.utils.render.GeometryUtils;

public class TileEntityCannon
extends SyncedTileEntity
implements IActivateAwareTile,
IPointable {
    public SyncableDouble targetPitch;
    public SyncableDouble targetYaw;
    public SyncableDouble targetSpeed;
    public double currentPitch = 45.0;
    public double currentYaw = 0.0;
    public double currentSpeed = 1.4;
    public double motionX = 0.0;
    public double motionY = 0.0;
    public double motionZ = 0.0;
    public boolean renderLine = true;
    private int ticksSinceLastFire = Integer.MAX_VALUE;

    protected void createSyncedFields() {
        this.targetPitch = new SyncableDouble();
        this.targetYaw = new SyncableDouble();
        this.targetSpeed = new SyncableDouble(1.4);
    }

    @SideOnly(value=Side.CLIENT)
    public void prepareForInventoryRender(Block block, int metadata) {
        super.prepareForInventoryRender(block, metadata);
        this.renderLine = false;
    }

    public void func_70316_g() {
        super.func_70316_g();
        if (this.currentYaw < 0.0) {
            this.currentYaw += 360.0;
        }
        this.currentYaw %= 360.0;
        double rotationSpeed = 3.0;
        this.currentPitch -= (this.currentPitch - this.targetPitch.getValue()) / 20.0;
        this.currentYaw = Math.abs(this.currentYaw - this.targetYaw.getValue()) < rotationSpeed ? this.targetYaw.getValue() : (this.currentYaw += rotationSpeed * (double)GeometryUtils.getDirectionForRotation((double)this.currentYaw, (double)this.targetYaw.getValue()));
        this.currentSpeed -= (this.currentSpeed - this.targetSpeed.getValue()) / 20.0;
        this.getMotionFromAngles();
        if (!this.field_70331_k.field_72995_K) {
            if (this.field_70331_k.func_72820_D() % 20L == 0L && this.field_70331_k.func_72864_z(this.field_70329_l, this.field_70330_m, this.field_70327_n)) {
                for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                    ItemStack stack;
                    IInventory inventory = InventoryUtils.getInventory((World)this.field_70331_k, (int)this.field_70329_l, (int)this.field_70330_m, (int)this.field_70327_n, (ForgeDirection)direction);
                    if (inventory == null || (stack = InventoryUtils.removeNextItemStack((IInventory)inventory)) == null) continue;
                    this.getMotionFromAngles();
                    new TileEntityMessageEventPacket((OpenTileEntity)this).sendToWatchers((WorldServer)this.field_70331_k);
                    EntityItemProjectile item = new EntityItemProjectile(this.field_70331_k, (double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5, stack);
                    item.field_70293_c = 20;
                    item.field_70159_w = this.motionX * this.currentSpeed;
                    item.field_70181_x = this.motionY * this.currentSpeed;
                    item.field_70179_y = this.motionZ * this.currentSpeed;
                    this.field_70331_k.func_72838_d((Entity)item);
                    this.field_70331_k.func_72908_a((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5, "openblocks:cannon", 0.2f, 1.0f);
                    break;
                }
            }
        } else if (this.ticksSinceLastFire < 100) {
            ++this.ticksSinceLastFire;
        }
    }

    public void onEvent(TileEntityMessageEventPacket event) {
        this.ticksSinceLastFire = 0;
        double pitchRad = Math.toRadians(this.currentYaw - 90.0);
        double x = -0.5 * Math.cos(pitchRad);
        double z = -0.5 * Math.sin(pitchRad);
        for (int i = 0; i < 20; ++i) {
            this.field_70331_k.func_72869_a((i < 4 ? "large" : "") + "smoke", x + (double)this.field_70329_l + 0.3 + this.field_70331_k.field_73012_v.nextDouble() * 0.4, (double)this.field_70330_m + 0.7, z + (double)this.field_70327_n + 0.3 + this.field_70331_k.field_73012_v.nextDouble() * 0.4, 0.0, 0.0, 0.0);
        }
    }

    public int getTicksSinceLastFire() {
        return this.ticksSinceLastFire;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB box = super.getRenderBoundingBox();
        return box.func_72314_b(32.0, 32.0, 32.0);
    }

    public boolean onBlockActivated(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public void onSynced(Set<ISyncableObject> changes) {
        this.getMotionFromAngles();
    }

    private void getMotionFromAngles() {
        double p = Math.toRadians(this.currentPitch);
        double y = Math.toRadians(180.0 - this.currentYaw);
        double sinPitch = Math.sin(p);
        double cosPitch = Math.cos(p);
        double sinYaw = Math.sin(y);
        double cosYaw = Math.cos(y);
        this.motionX = -cosPitch * sinYaw;
        this.motionY = sinPitch;
        this.motionZ = -cosPitch * cosYaw;
    }

    public void setTarget(int x, int y, int z) {
        double dX = (double)this.field_70329_l + 0.5 - ((double)x + 0.5);
        double dY = -(this.field_70330_m - y);
        double dZ = (double)this.field_70327_n + 0.5 - ((double)z + 0.5);
        double yawDegrees = Math.toDegrees(Math.atan2(dZ, dX)) + 90.0;
        this.targetYaw.setValue(yawDegrees);
        this.currentYaw = this.targetYaw.getValue();
        double[] calc = TileEntityCannonLogic.getVariableVelocityTheta(dX, dY, dZ);
        double theta = Math.max(calc[0], calc[1]);
        this.targetPitch.setValue(Math.toDegrees(theta));
        this.currentPitch = this.targetPitch.getValue();
        double d = Math.sqrt(dX * dX + dZ * dZ);
        double v = Math.sqrt(d * 0.04000000000000001 / Math.sin(2.0 * theta));
        this.targetSpeed.setValue(v);
        this.sync();
    }

    public void disableLineRender() {
        this.renderLine = false;
    }

    @Override
    public void onPoint(ItemStack itemStack, EntityPlayer player, int x, int y, int z) {
        player.func_70006_a(ChatMessageComponent.func_111066_d((String)String.format("Pointed cannon at %s, %s, %s", x, y, z)));
        this.setTarget(x, y, z);
    }

    public void setSpeed(double speed) {
        this.targetSpeed.setValue(speed);
        this.sync();
    }

    public void setPitch(double pitch2) {
        this.targetPitch.setValue(pitch2);
        this.sync();
    }

    public void setYaw(double yaw2) {
        this.targetYaw.setValue(yaw2);
        this.sync();
    }

    static class TileEntityCannonLogic {
        public static final int HOURS_WASTED_ON_CANNON_LOGIC = 10;
        public static final double CANNON_VELOCITY = 0.4;
        public static final double WORLD_GRAVITY = -0.04000000000000001;

        TileEntityCannonLogic() {
        }

        public static double[] getThetaByAngle(double deltaX, double deltaY, double deltaZ, double v) {
            double r = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
            double e = Math.atan2(deltaY, r);
            double g = -0.04000000000000001;
            double c1 = Math.sqrt(Math.pow(v += 0.5, 4.0) - g * (g * r * r * Math.pow(Math.cos(e), 2.0) + 2.0 * (v * v) * r * Math.sin(e)));
            double c2 = g * r * Math.cos(e);
            return new double[]{Math.atan(v * v + c1 / c2), Math.atan(v * v - c1 * c2)};
        }

        public static double[] getVariableVelocityTheta(double deltaX, double deltaY, double deltaZ) {
            double velocity = 0.4;
            double[] theta = TileEntityCannonLogic.getThetaToPoint(deltaX, deltaY, deltaZ, velocity);
            int iterations = 100;
            while (Double.isNaN(theta[0]) && Double.isNaN(theta[1]) && --iterations > 0) {
                theta = TileEntityCannonLogic.getThetaToPoint(deltaX, deltaY, deltaZ, velocity += 0.025);
            }
            double[] result = new double[]{theta[0], theta[1], velocity};
            return result;
        }

        public static double[] getThetaToPoint(double deltaX, double deltaY, double deltaZ, double velocity) {
            double x = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
            double y = deltaY + 0.4;
            double v = velocity;
            double g = -0.04000000000000001;
            double[] theta = new double[2];
            double mComponent = v * v * v * v - g * (g * (x * x) + 2.0 * (y * (v * v)));
            if (mComponent < 0.0) {
                return new double[]{Double.NaN, Double.NaN};
            }
            mComponent *= 100.0;
            mComponent = Math.sqrt(mComponent);
            mComponent /= 10.0;
            theta[0] = Math.atan(v * v + (mComponent /= g * x));
            theta[1] = Math.atan(v * v - mComponent);
            return theta;
        }
    }
}

