/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import openblocks.Config;
import openblocks.OpenBlocks;
import openblocks.common.entity.EntityAssistant;
import openblocks.common.entity.EntityCartographer;

public class ItemCartographer
extends Item {
    public ItemCartographer() {
        super(Config.itemCartographerId);
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77637_a(OpenBlocks.tabOpenBlocks);
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_77650_f(ItemStack stack) {
        return ItemCartographer.getTypeFromItem(stack).icon;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister register) {
        for (AssistantType type : AssistantType.VALUES) {
            type.icon = register.func_94245_a(type.iconName);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77633_a(int id, CreativeTabs tab, List result) {
        for (AssistantType type : AssistantType.VALUES) {
            result.add(new ItemStack(id, 1, type.ordinal()));
        }
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        AssistantType type;
        if (!player.field_71075_bZ.field_75098_d) {
            --stack.field_77994_a;
        }
        if (!world.field_72995_K && (type = ItemCartographer.getTypeFromItem(stack)) != null) {
            EntityAssistant cartographer = type.createAssistant(world, player, stack);
            world.func_72838_d((Entity)cartographer);
        }
        return stack;
    }

    public static AssistantType getTypeFromItem(ItemStack stack) {
        int typeId = stack.func_77960_j();
        if (typeId < 0 || typeId > AssistantType.VALUES.length) {
            typeId = 0;
        }
        return AssistantType.VALUES[typeId];
    }

    public ItemStack createStack(AssistantType type) {
        return new ItemStack((Item)this, 1, type.ordinal());
    }

    public static enum AssistantType {
        CARTOGRAPHER("cartographer", "cartographer"){

            @Override
            public EntityAssistant createAssistant(World world, EntityPlayer owner, ItemStack stack) {
                return new EntityCartographer(world, owner, stack);
            }
        };

        public final String untranslatedName;
        public final String iconName;
        private Icon icon;
        public static final AssistantType[] VALUES;

        private AssistantType(String name, String iconName) {
            this.untranslatedName = "openblocks.assistant_" + name;
            this.iconName = "openblocks:assistant_" + iconName;
        }

        public abstract EntityAssistant createAssistant(World var1, EntityPlayer var2, ItemStack var3);

        static {
            VALUES = AssistantType.values();
        }
    }
}

