/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.block;

import com.google.common.collect.Lists;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.StepSound;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import openblocks.Config;
import openblocks.common.block.OpenBlock;
import openblocks.common.item.ItemImaginary;
import openblocks.common.tileentity.TileEntityImaginary;

public class BlockImaginary
extends OpenBlock {
    public Icon texturePencilBlock;
    public Icon textureCrayonBlock;
    public Icon texturePencilPanel;
    public Icon textureCrayonPanel;
    public Icon texturePencilHalfPanel;
    public Icon textureCrayonHalfPanel;
    public static final StepSound drawingSounds = new StepSound("cloth", 0.5f, 1.0f){

        public String func_82593_b() {
            return "openblocks:draw";
        }
    };

    public BlockImaginary() {
        super(Config.blockImaginaryId, Material.field_76264_q);
        this.func_71848_c(0.3f);
        this.field_72020_cn = drawingSounds;
    }

    public AxisAlignedBB func_71911_a_(World world, int x, int y, int z) {
        TileEntityImaginary te;
        if (world.field_72995_K && (te = (TileEntityImaginary)((Object)this.getTileEntity((IBlockAccess)world, x, y, z, TileEntityImaginary.class))) != null && te.is(TileEntityImaginary.Property.SELECTABLE)) {
            return te.getSelectionBox();
        }
        return AxisAlignedBB.func_72332_a().func_72299_a(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    public AxisAlignedBB func_71872_e(World world, int x, int y, int z) {
        return null;
    }

    public void func_71871_a(World world, int x, int y, int z, AxisAlignedBB region, List result, Entity entity) {
        TileEntityImaginary te = (TileEntityImaginary)((Object)this.getTileEntity((IBlockAccess)world, x, y, z, TileEntityImaginary.class));
        if (te != null && te.is(TileEntityImaginary.Property.SOLID, entity)) {
            te.addCollisions(region, result);
        }
    }

    public void func_71902_a(IBlockAccess access, int x, int y, int z) {
        TileEntityImaginary te = (TileEntityImaginary)((Object)this.getTileEntity(access, x, y, z, TileEntityImaginary.class));
        if (te != null && te.is(TileEntityImaginary.Property.SELECTABLE)) {
            AxisAlignedBB aabb = te.getBlockBounds();
            this.field_72026_ch = aabb.field_72340_a;
            this.field_72023_ci = aabb.field_72338_b;
            this.field_72024_cj = aabb.field_72339_c;
            this.field_72021_ck = aabb.field_72336_d;
            this.field_72022_cl = aabb.field_72337_e;
            this.field_72019_cm = aabb.field_72334_f;
        }
    }

    public MovingObjectPosition func_71878_a(World world, int x, int y, int z, Vec3 par5Vec3, Vec3 par6Vec3) {
        TileEntityImaginary te;
        if (world.field_72995_K && ((te = (TileEntityImaginary)((Object)this.getTileEntity((IBlockAccess)world, x, y, z, TileEntityImaginary.class))) == null || !te.is(TileEntityImaginary.Property.SELECTABLE))) {
            return null;
        }
        return super.func_71878_a(world, x, y, z, par5Vec3, par6Vec3);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister registry) {
        this.field_94336_cN = this.texturePencilBlock = registry.func_94245_a("openblocks:pencilBlock");
        this.textureCrayonBlock = registry.func_94245_a("openblocks:crayonBlock");
        this.texturePencilPanel = registry.func_94245_a("openblocks:pencilPanel");
        this.textureCrayonPanel = registry.func_94245_a("openblocks:crayonPanel");
        this.texturePencilHalfPanel = registry.func_94245_a("openblocks:pencilHalfPanel");
        this.textureCrayonHalfPanel = registry.func_94245_a("openblocks:crayonHalfPanel");
    }

    public boolean func_71886_c() {
        return false;
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean shouldRenderBlock() {
        return false;
    }

    public ArrayList<ItemStack> getBlockDropped(World world, int x, int y, int z, int metadata, int fortune) {
        return Lists.newArrayList();
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        TileEntityImaginary te = (TileEntityImaginary)((Object)this.getTileEntity((IBlockAccess)world, x, y, z, TileEntityImaginary.class));
        if (te != null) {
            int dmg = te.isPencil() ? 0 : 1;
            return ItemImaginary.setupValues(te.color, new ItemStack((Block)this, 1, dmg));
        }
        return null;
    }
}

