/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.block;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import openblocks.Config;
import openblocks.OpenBlocks;
import openblocks.common.Stencil;
import openblocks.common.block.OpenBlock;
import openblocks.common.tileentity.TileEntityCanvas;

public class BlockCanvas
extends OpenBlock {
    private int layer = 0;
    private int renderSide = 0;
    public Icon baseIcon;

    public BlockCanvas() {
        super(Config.blockCanvasId, Material.field_76248_c);
    }

    public BlockCanvas(int id, Material material) {
        super(id, material);
    }

    public void func_94332_a(IconRegister registry) {
        this.baseIcon = registry.func_94245_a("openblocks:canvas");
        for (Stencil stencil : Stencil.values()) {
            stencil.registerBlockIcons(registry);
        }
        super.func_94332_a(registry);
    }

    public ArrayList<ItemStack> getBlockDropped(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        TileEntityCanvas tile = (TileEntityCanvas)((Object)this.getTileEntity((IBlockAccess)world, x, y, z, TileEntityCanvas.class));
        if (tile != null) {
            int bId = tile.paintedBlockId.getValue();
            int bMeta = tile.paintedBlockMeta.getValue();
            if (bId > 0) {
                int droppedId = Block.field_71973_m[bId].func_71885_a(bMeta, world.field_73012_v, fortune);
                Block b = Block.field_71973_m[droppedId];
                for (int i = 0; i < b.func_71925_a(world.field_73012_v); ++i) {
                    ret.add(new ItemStack(b, 1, bMeta));
                }
            } else {
                return super.getBlockDropped(world, x, y, z, metadata, fortune);
            }
        }
        return ret;
    }

    public boolean shouldRenderBlock() {
        return true;
    }

    public void setLayerForRender(int layer) {
        this.layer = layer;
    }

    public void setSideForRender(int side) {
        this.renderSide = side;
    }

    public boolean func_71877_c(IBlockAccess world, int x, int y, int z, int side) {
        return side == this.renderSide && super.func_71877_c(world, x, y, z, side);
    }

    public int func_71920_b(IBlockAccess world, int x, int y, int z) {
        TileEntityCanvas tile = (TileEntityCanvas)((Object)this.getTileEntity(world, x, y, z, TileEntityCanvas.class));
        return tile != null ? tile.getColorForRender(this.renderSide, this.layer) : -1;
    }

    public Icon getUnrotatedTexture(ForgeDirection direction, IBlockAccess world, int x, int y, int z) {
        TileEntityCanvas tile = (TileEntityCanvas)((Object)this.getTileEntity(world, x, y, z, TileEntityCanvas.class));
        if (tile != null) {
            return tile.getTextureForRender(this.renderSide, this.layer);
        }
        return super.getUnrotatedTexture(direction, world, x, y, z);
    }

    public static void replaceBlock(World world, int x, int y, int z) {
        int id = world.func_72798_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        Material material = world.func_72803_f(x, y, z);
        if (material == Material.field_76264_q) {
            world.func_94575_c(x, y, z, OpenBlocks.Blocks.canvasGlass.field_71990_ca);
        } else {
            world.func_94575_c(x, y, z, OpenBlocks.Blocks.canvas.field_71990_ca);
        }
        TileEntityCanvas tile = (TileEntityCanvas)world.func_72796_p(x, y, z);
        tile.paintedBlockId.setValue(id);
        tile.paintedBlockMeta.setValue(meta);
    }
}

