/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.network.Player;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraftforge.event.ForgeSubscribe;
import openblocks.common.HeightMapData;
import openblocks.events.EventTypes;
import openmods.Log;
import openmods.network.EventPacket;
import openmods.network.IEventPacketType;
import openmods.utils.ByteUtils;

public class MapDataManager {
    public static final MapDataManager instance = new MapDataManager();
    private Set<Integer> mapsToUpdate = Sets.newHashSet();

    public static int createNewMap(World world, byte scale) {
        int id = world.func_72841_b("height_map");
        HeightMapData data = new HeightMapData(id, false);
        data.scale = scale;
        data.func_76185_a();
        world.func_72823_a(data.field_76190_i, (WorldSavedData)data);
        return id;
    }

    public static HeightMapData getMapData(World world, int mapId) {
        if (mapId < 0) {
            return HeightMapData.INVALID;
        }
        String name = HeightMapData.getMapName(mapId);
        HeightMapData result = (HeightMapData)world.func_72943_a(HeightMapData.class, name);
        return result != null ? result : HeightMapData.EMPTY;
    }

    public static void setMapData(World world, HeightMapData data) {
        world.func_72823_a(data.field_76190_i, (WorldSavedData)data);
    }

    private static World getPlayerWorld(Player player) {
        return ((EntityPlayer)player).field_70170_p;
    }

    @ForgeSubscribe
    public void onMapDataRequest(MapDataRequestEvent evt) {
        World world = MapDataManager.getPlayerWorld(evt.player);
        MapDataResponseEvent response = new MapDataResponseEvent();
        for (Integer mapId : evt.mapIds) {
            HeightMapData map = MapDataManager.getMapData(world, mapId);
            if (map != null) {
                response.maps.put(mapId, map);
                continue;
            }
            Log.info((String)"Player %s asked for non-existent map %d", (Object[])new Object[]{evt.player, mapId});
        }
        evt.reply(response);
    }

    @ForgeSubscribe
    public void onMapDataResponse(MapDataResponseEvent evt) {
        World world = MapDataManager.getPlayerWorld(evt.player);
        for (Map.Entry<Integer, HeightMapData> e : evt.maps.entrySet()) {
            HeightMapData mapData = e.getValue();
            world.func_72823_a(mapData.field_76190_i, (WorldSavedData)mapData);
        }
    }

    @ForgeSubscribe
    public void onMapUpdates(MapUpdatesEvent evt) {
        World world = MapDataManager.getPlayerWorld(evt.player);
        HashSet mapsToUpdate = Sets.newHashSet();
        for (Integer mapId : evt.mapIds) {
            HeightMapData map = MapDataManager.getMapData(world, mapId);
            if (map == null) continue;
            mapsToUpdate.add(mapId);
        }
        if (!mapsToUpdate.isEmpty()) {
            MapDataRequestEvent request = new MapDataRequestEvent();
            request.mapIds = Lists.newArrayList((Iterable)mapsToUpdate);
            evt.reply(request);
        }
    }

    public void sendUpdates(MinecraftServer server) {
        if (this.mapsToUpdate.isEmpty()) {
            return;
        }
        MapUpdatesEvent evt = new MapUpdatesEvent();
        evt.mapIds.addAll(this.mapsToUpdate);
        this.mapsToUpdate.clear();
        evt.sendToPlayers(server.func_71203_ab().field_72404_b);
    }

    public void markDataUpdated(World world, int mapId) {
        HeightMapData data = MapDataManager.getMapData(world, mapId);
        data.func_76185_a();
        this.mapsToUpdate.add(mapId);
    }

    public static void requestMapData(World world, int mapId) {
        if (world.field_72995_K) {
            MapDataRequestEvent evt = new MapDataRequestEvent();
            evt.mapIds.add(mapId);
            evt.sendToServer();
            HeightMapData stub = new HeightMapData(mapId, true);
            world.func_72823_a(stub.field_76190_i, (WorldSavedData)stub);
        }
    }

    public static class MapDataResponseEvent
    extends EventPacket {
        public Map<Integer, HeightMapData> maps = Maps.newHashMap();

        public IEventPacketType getType() {
            return EventTypes.MAP_DATA_RESPONSE;
        }

        protected void readFromStream(DataInput input) throws IOException {
            int length = ByteUtils.readVLI((DataInput)input);
            for (int i = 0; i < length; ++i) {
                int id = ByteUtils.readVLI((DataInput)input);
                HeightMapData data = new HeightMapData(id, false);
                data.readFromStream(input);
                this.maps.put(id, data);
            }
        }

        protected void writeToStream(DataOutput output) throws IOException {
            int size = 0;
            for (HeightMapData heightMapData : this.maps.values()) {
                if (!heightMapData.isValid()) continue;
                ++size;
            }
            ByteUtils.writeVLI((DataOutput)output, (int)size);
            for (Map.Entry entry : this.maps.entrySet()) {
                HeightMapData map = (HeightMapData)((Object)entry.getValue());
                if (map.isValid()) {
                    ByteUtils.writeVLI((DataOutput)output, (int)((Integer)entry.getKey()));
                    map.writeToStream(output);
                    continue;
                }
                Log.warn((String)"Trying to propagate invalid map data %d", (Object[])new Object[]{entry.getKey()});
            }
        }
    }

    public static class MapUpdatesEvent
    extends MapIdRequest {
        public IEventPacketType getType() {
            return EventTypes.MAP_UPDATES;
        }
    }

    public static class MapDataRequestEvent
    extends MapIdRequest {
        public IEventPacketType getType() {
            return EventTypes.MAP_DATA_REQUEST;
        }
    }

    public static abstract class MapIdRequest
    extends EventPacket {
        public List<Integer> mapIds = Lists.newArrayList();

        protected void readFromStream(DataInput input) throws IOException {
            int length = ByteUtils.readVLI((DataInput)input);
            for (int i = 0; i < length; ++i) {
                int id = ByteUtils.readVLI((DataInput)input);
                this.mapIds.add(id);
            }
        }

        protected void writeToStream(DataOutput output) throws IOException {
            ByteUtils.writeVLI((DataOutput)output, (int)this.mapIds.size());
            for (Integer id : this.mapIds) {
                ByteUtils.writeVLI((DataOutput)output, (int)id);
            }
        }
    }
}

