/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.tileentity;

import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.ResourceLocation;
import openblocks.OpenBlocks;
import openblocks.common.tileentity.TileEntityGuide;
import org.lwjgl.opengl.GL11;

public class TileEntityGuideRenderer
extends TileEntitySpecialRenderer {
    private final RenderBlocks renderBlocks = new RenderBlocks();
    private static final ResourceLocation texture = new ResourceLocation("openblocks", "textures/blocks/guide.png");

    public void func_76894_a(TileEntity tileentity, double x, double y, double z, float f) {
        TileEntityGuide guide = (TileEntityGuide)tileentity;
        this.func_110628_a(TextureMap.field_110575_b);
        float scaleDelta = guide.getTimeSinceChange();
        this.renderShape(guide.getShape(), guide.getHeight(), guide.getWidth(), guide.getDepth(), x, y, z, scaleDelta);
        if ((double)scaleDelta < 1.0) {
            this.renderShape(guide.getPreviousShape(), guide.getHeight(), guide.getWidth(), guide.getDepth(), x, y, z, 1.0f - scaleDelta);
        }
    }

    private void renderShape(boolean[][][] shape, int height, int width, int depth, double x, double y, double z, float scale) {
        if (shape == null) {
            return;
        }
        for (int y2 = 0; y2 < shape.length; ++y2) {
            for (int x2 = 0; x2 < shape[y2].length; ++x2) {
                for (int z2 = 0; z2 < shape[y2][x2].length; ++z2) {
                    if (!shape[y2][x2][z2]) continue;
                    GL11.glEnable((int)3042);
                    GL11.glBlendFunc((int)770, (int)771);
                    this.renderAt(x + (double)x2 - (double)width, y + (double)y2 - (double)height, z + (double)z2 - (double)depth, scale);
                    GL11.glDisable((int)3042);
                }
            }
        }
    }

    private void renderAt(double x, double y, double z, float scale) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y), (float)((float)z + 0.5f));
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        Tessellator t = Tessellator.field_78398_a;
        this.renderBlocks.func_83020_a(0.05, 0.05, 0.05, 0.95, 0.95, 0.95);
        t.func_78382_b();
        t.func_78370_a(255, 255, 255, 100);
        t.func_78380_c(200);
        this.func_110628_a(texture);
        Icon renderingIcon = OpenBlocks.Blocks.guide.func_71851_a(0);
        this.renderBlocks.func_78573_e((Block)OpenBlocks.Blocks.guide, -0.5, 0.0, -0.5, renderingIcon);
        this.renderBlocks.func_78605_f((Block)OpenBlocks.Blocks.guide, -0.5, 0.0, -0.5, renderingIcon);
        this.renderBlocks.func_78613_a((Block)OpenBlocks.Blocks.guide, -0.5, 0.0, -0.5, renderingIcon);
        this.renderBlocks.func_78617_b((Block)OpenBlocks.Blocks.guide, -0.5, 0.0, -0.5, renderingIcon);
        this.renderBlocks.func_78611_c((Block)OpenBlocks.Blocks.guide, -0.5, 0.0, -0.5, renderingIcon);
        this.renderBlocks.func_78622_d((Block)OpenBlocks.Blocks.guide, -0.5, 0.0, -0.5, renderingIcon);
        t.func_78381_a();
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }
}

