/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.gui;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiConfirmOpenLink;
import net.minecraft.client.gui.GuiScreen;
import openblocks.common.container.ContainerDonationStation;
import openblocks.common.tileentity.TileEntityDonationStation;
import openmods.container.ContainerBase;
import openmods.gui.BaseGuiContainer;
import openmods.gui.component.BaseComponent;
import openmods.gui.component.GuiComponentLabel;
import openmods.gui.component.GuiComponentTextButton;

public class GuiDonationStation
extends BaseGuiContainer<ContainerDonationStation>
implements BaseComponent.IComponentListener {
    private final int PROMPT_REPLY_ACTION = 0;
    private URI displayedURI = null;
    GuiComponentTextButton buttonDonate;
    GuiComponentLabel lblAuthors;

    public GuiDonationStation(ContainerDonationStation container) {
        super((ContainerBase)container, 176, 172, "openblocks.gui.donationstation");
        TileEntityDonationStation station = (TileEntityDonationStation)((Object)container.getOwner());
        this.root.addComponent(new GuiComponentLabel(55, 31, 100, 10, station.getModName()).setName("lblModName"));
        this.lblAuthors = new GuiComponentLabel(55, 42, 200, 18, station.getAuthors()).setScale(0.5f);
        this.root.addComponent(this.lblAuthors.setName("lblAuthors"));
        this.buttonDonate = new GuiComponentTextButton(31, 60, 115, 13, 0xFFFFFF);
        this.root.addComponent(this.buttonDonate.setText("Donate to the author").setName("btnDonate").addListener((BaseComponent.IComponentListener)this));
    }

    public void preRender(float mouseX, float mouseY) {
        super.preRender(mouseX, mouseY);
        String donateUrl = ((TileEntityDonationStation)((Object)((ContainerDonationStation)this.getContainer()).getOwner())).getDonateUrl();
        this.buttonDonate.setButtonEnabled(donateUrl != null && !donateUrl.isEmpty());
    }

    public void postRender(int mouseX, int mouseY) {
        super.postRender(mouseX, mouseY);
        if (this.lblAuthors.capturingMouse()) {
            List lines = this.field_73886_k.func_78271_c(this.lblAuthors.getText(), 150);
            if (lines.size() < this.lblAuthors.getMaxLines()) {
                return;
            }
            this.drawHoveringText(lines, mouseX - this.field_74198_m, mouseY - this.field_74197_n, this.field_73886_k);
        }
    }

    public void componentMouseDown(BaseComponent component, int offsetX, int offsetY, int button) {
        URI uri;
        if (component.getName().equals("btnDonate") && ((GuiComponentTextButton)component).isButtonEnabled() && (uri = URI.create(((TileEntityDonationStation)((Object)((ContainerDonationStation)this.getContainer()).getOwner())).getDonateUrl())) != null) {
            if (Minecraft.func_71410_x().field_71474_y.field_74358_q) {
                this.displayedURI = uri;
                this.field_73882_e.func_71373_a((GuiScreen)new GuiConfirmOpenLink((GuiScreen)this, this.displayedURI.toString(), 0, false));
            } else {
                this.openURI(uri);
            }
        }
    }

    private void openURI(URI uri) {
        try {
            Desktop.getDesktop().browse(uri);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ((TileEntityDonationStation)((Object)((ContainerDonationStation)this.getContainer()).getOwner())).showSomeLove();
    }

    public void func_73878_a(boolean result, int action) {
        if (action == 0 && result) {
            this.openURI(this.displayedURI);
            this.displayedURI = null;
        }
        this.field_73882_e.func_71373_a((GuiScreen)this);
    }

    public void componentMouseDrag(BaseComponent component, int offsetX, int offsetY, int button, long time) {
    }

    public void componentMouseMove(BaseComponent component, int offsetX, int offsetY) {
    }

    public void componentMouseUp(BaseComponent component, int offsetX, int offsetY, int button) {
    }

    public void componentKeyTyped(BaseComponent component, char par1, int par2) {
    }
}

