/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client;

import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import java.util.EnumSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import openblocks.client.SoundEventsManager;
import openblocks.common.entity.EntityHangGlider;
import openblocks.events.PlayerMovementEvent;
import openmods.tileentity.OpenTileEntity;

public class ClientTickHandler
implements ITickHandler {
    private static int ticks = 0;
    private boolean wasJumping = false;
    private boolean wasSneaking = false;

    public void tickStart(EnumSet<TickType> type, Object ... tickData) {
        if (type.contains(TickType.RENDER) && Minecraft.func_71410_x().field_71441_e != null) {
            this.preRenderTick(Minecraft.func_71410_x(), (World)Minecraft.func_71410_x().field_71441_e, ((Float)tickData[0]).floatValue());
        }
        if (type.contains(TickType.CLIENT)) {
            this.clientTick();
        }
    }

    public void tickEnd(EnumSet<TickType> type, Object ... tickData) {
    }

    public EnumSet<TickType> ticks() {
        return EnumSet.of(TickType.RENDER, TickType.CLIENT);
    }

    public String getLabel() {
        return "OpenBlocksClientTick";
    }

    public void preRenderTick(Minecraft mc, World world, float renderTick) {
        EntityHangGlider.updateGliders(world);
    }

    private static OpenTileEntity getTileUnderPlayer(EntityPlayer player) {
        int z;
        int y;
        int x;
        TileEntity te;
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world != null && player != null && (te = world.func_72796_p(x = MathHelper.func_76128_c((double)player.field_70165_t), y = MathHelper.func_76128_c((double)player.field_70121_D.field_72338_b) - 1, z = MathHelper.func_76128_c((double)player.field_70161_v))) instanceof OpenTileEntity) {
            return (OpenTileEntity)te;
        }
        return null;
    }

    public void clientTick() {
        EntityClientPlayerMP player;
        if (SoundEventsManager.isPlayerWearingGlasses()) {
            SoundEventsManager.instance.tickUpdate();
        }
        if ((player = Minecraft.func_71410_x().field_71439_g) != null) {
            OpenTileEntity target = ClientTickHandler.getTileUnderPlayer((EntityPlayer)player);
            if (target != null) {
                if (player.field_71158_b.field_78901_c && !this.wasJumping) {
                    new PlayerMovementEvent(target, PlayerMovementEvent.Type.JUMP).sendToServer();
                }
                if (player.field_71158_b.field_78899_d && !this.wasSneaking) {
                    new PlayerMovementEvent(target, PlayerMovementEvent.Type.SNEAK).sendToServer();
                }
            }
            this.wasJumping = player.field_71158_b.field_78901_c;
            this.wasSneaking = player.field_71158_b.field_78899_d;
        }
        ++ticks;
    }

    public static int getTicks() {
        return ticks;
    }
}

