/*
 * Decompiled with CFR 0.152.
 */
package openblocks;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Property;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import openblocks.OpenBlocks;
import openblocks.asm.EntityPlayerVisitor;
import openblocks.common.EnchantmentExplosive;
import openblocks.common.EntityEventHandler;
import openblocks.common.ExplosiveEnchantmentsHandler;
import openblocks.common.Stencil;
import openblocks.common.TrophyHandler;
import openblocks.common.block.BlockAutoAnvil;
import openblocks.common.block.BlockAutoEnchantmentTable;
import openblocks.common.block.BlockBearTrap;
import openblocks.common.block.BlockBigButton;
import openblocks.common.block.BlockBlockBreaker;
import openblocks.common.block.BlockBlockPlacer;
import openblocks.common.block.BlockCannon;
import openblocks.common.block.BlockCanvas;
import openblocks.common.block.BlockCanvasGlass;
import openblocks.common.block.BlockDonationStation;
import openblocks.common.block.BlockDrawingTable;
import openblocks.common.block.BlockElevator;
import openblocks.common.block.BlockFan;
import openblocks.common.block.BlockFlag;
import openblocks.common.block.BlockGrave;
import openblocks.common.block.BlockGuide;
import openblocks.common.block.BlockHeal;
import openblocks.common.block.BlockImaginary;
import openblocks.common.block.BlockItemDropper;
import openblocks.common.block.BlockLadder;
import openblocks.common.block.BlockMachineOreCrusher;
import openblocks.common.block.BlockPaintCan;
import openblocks.common.block.BlockPaintMixer;
import openblocks.common.block.BlockPath;
import openblocks.common.block.BlockProjector;
import openblocks.common.block.BlockRopeLadder;
import openblocks.common.block.BlockSponge;
import openblocks.common.block.BlockSprinkler;
import openblocks.common.block.BlockTank;
import openblocks.common.block.BlockTarget;
import openblocks.common.block.BlockTrophy;
import openblocks.common.block.BlockVacuumHopper;
import openblocks.common.block.BlockVillageHighlighter;
import openblocks.common.block.BlockXPBottler;
import openblocks.common.block.BlockXPDrain;
import openblocks.common.item.ItemCartographer;
import openblocks.common.item.ItemCraneBackpack;
import openblocks.common.item.ItemCraneControl;
import openblocks.common.item.ItemCursor;
import openblocks.common.item.ItemEmptyMap;
import openblocks.common.item.ItemFilledBucket;
import openblocks.common.item.ItemGoldenEye;
import openblocks.common.item.ItemHangGlider;
import openblocks.common.item.ItemHeightMap;
import openblocks.common.item.ItemImaginary;
import openblocks.common.item.ItemImaginationGlasses;
import openblocks.common.item.ItemLuggage;
import openblocks.common.item.ItemOBGeneric;
import openblocks.common.item.ItemOBGenericUnstackable;
import openblocks.common.item.ItemPaintBrush;
import openblocks.common.item.ItemSleepingBag;
import openblocks.common.item.ItemSlimalyzer;
import openblocks.common.item.ItemSonicGlasses;
import openblocks.common.item.ItemSqueegee;
import openblocks.common.item.ItemStencil;
import openblocks.common.item.ItemTastyClay;
import openblocks.common.item.MetasBucket;
import openblocks.common.item.MetasGeneric;
import openblocks.common.item.MetasGenericUnstackable;
import openblocks.common.recipe.CrayonGlassesRecipe;
import openblocks.common.recipe.CrayonMixingRecipe;
import openblocks.common.recipe.GoldenEyeRechargeRecipe;
import openblocks.common.recipe.MapCloneRecipe;
import openblocks.common.recipe.MapResizeRecipe;
import openmods.config.BlockId;
import openmods.config.ConfigProcessing;
import openmods.config.ConfigProperty;
import openmods.config.ItemId;
import openmods.utils.ColorUtils;

public class Config {
    @BlockId(description="The id of the ladder")
    public static int blockLadderId = 2540;
    @BlockId(description="The id of the guide")
    public static int blockGuideId = 2541;
    @BlockId(description="The id of the elevator block")
    public static int blockElevatorId = 2542;
    @BlockId(description="The id of the heal block")
    public static int blockHealId = 2543;
    @BlockId(description="The id of the target block")
    public static int blockTargetId = 2545;
    @BlockId(description="The id of the grave block")
    public static int blockGraveId = 2546;
    @BlockId(description="The id of the flag block")
    public static int blockFlagId = 2547;
    @BlockId(description="The id of the tank block")
    public static int blockTankId = 2548;
    @BlockId(description="The id of the trophy block")
    public static int blockTrophyId = 2549;
    @BlockId(description="The id of the bear trap")
    public static int blockBearTrapId = 2550;
    @BlockId(description="The id of the sprinkler block")
    public static int blockSprinklerId = 2551;
    @BlockId(description="The id of the cannon block")
    public static int blockCannonId = 2552;
    @BlockId(description="The id of the vacuum hopper block")
    public static int blockVacuumHopperId = 2553;
    @BlockId(description="The id of the sponge block")
    public static int blockSpongeId = 2554;
    @BlockId(description="The id of the big button block")
    public static int blockBigButton = 2555;
    @BlockId(description="The id of the imaginary block")
    public static int blockImaginaryId = 2556;
    @BlockId(description="The id of the xp bottler block")
    public static int blockXPBottlerId = 2557;
    @BlockId(description="The id of the village highlighter block")
    public static int blockVillageHighlighterId = 2558;
    @BlockId(description="The id of the path block")
    public static int blockPathId = 2559;
    @BlockId(description="The id of the auto anvil")
    public static int blockAutoAnvilId = 2560;
    @BlockId(description="The id of the auto enchantment table")
    public static int blockAutoEnchantmentTableId = 2561;
    @BlockId(description="The id of the xp drain block")
    public static int blockXPDrainId = 2562;
    @BlockId(description="The id of the block-breaker block")
    public static int blockBlockBreakerId = 2563;
    @BlockId(description="The id of the block-placer block")
    public static int blockBlockPlacerId = 2564;
    @BlockId(description="The id of the item-dropper block")
    public static int blockItemDropperId = 2565;
    @BlockId(description="The id of the rope ladder block")
    public static int blockRopeLadderId = 2566;
    @BlockId(description="The id of the donation station block")
    public static int blockDonationStationId = 2567;
    @BlockId(description="The id of the clay stainer block")
    public static int blockPaintMixer = 2568;
    @BlockId(description="The id of the canvas block")
    public static int blockCanvasId = 2569;
    @BlockId(description="The id of the Ore Crusher")
    public static int blockMachineOreCrusherId = 2570;
    @BlockId(description="The id of the paint tin")
    public static int blockPaintCanId = 2571;
    @BlockId(description="The id of the glass canvas block")
    public static int blockCanvasGlassId = 2572;
    @BlockId(description="The id of the map projector block")
    public static int blockProjectorId = 2573;
    @BlockId(description="The id of the drawing table")
    public static int blockDrawingTable = 2574;
    public static int blockGoldenEggId = 2575;
    @BlockId(description="The id of the fan block")
    public static int blockFanId = 2576;
    @ItemId(description="The id of the hang glider")
    public static int itemHangGliderId = 14975;
    @ItemId(description="The id of the generic item")
    public static int itemGenericId = 14976;
    @ItemId(description="The id of the luggage item")
    public static int itemLuggageId = 14977;
    @ItemId(description="The id of the sonic glasses item")
    public static int itemSonicGlassesId = 14978;
    @ItemId(description="The id of the imaginary pencil glasses item")
    public static int itemGlassesPencil = 14979;
    @ItemId(description="The id of the imaginary crayon glasses item")
    public static int itemGlassesCrayon = 14980;
    @ItemId(description="The id of the amazing technicolor glasses item")
    public static int itemGlassesTechnicolor = 14981;
    @ItemId(description="The id of the serious admin glasses item")
    public static int itemGlassesSerious = 14982;
    @ItemId(description="The id of the crane controller item")
    public static int itemCraneControl = 14983;
    @ItemId(description="The id of the crane backpack item")
    public static int itemCraneId = 14984;
    @ItemId(description="The id of slimalyzer item")
    public static int itemSlimalyzerId = 14985;
    @ItemId(description="The id of the filled bucket")
    public static int itemFilledBucketId = 14986;
    @ItemId(description="The id of the sleeping bag")
    public static int itemSleepingBagId = 14987;
    @ItemId(description="The id of the paint brush")
    public static int itemPaintBrushId = 14988;
    @ItemId(description="The id of the stencil")
    public static int itemStencilId = 14989;
    @ItemId(description="The id of the Squeegee")
    public static int itemSqueegeeId = 14990;
    @ItemId(description="The id of the height map item")
    public static int itemHeightMap = 14991;
    @ItemId(description="The id of the empty height map item")
    public static int itemEmptyMap = 14992;
    @ItemId(description="The id of the cartographer spawner item")
    public static int itemCartographerId = 14993;
    @ItemId(description="The id of the tasty clay item!")
    public static int itemTastyClay = 14994;
    @ItemId(description="The id of the golden eye item")
    public static int itemGoldenEyeId = 14995;
    @ItemId(description="The id of the cursor item")
    public static int itemCursorId = 14997;
    @ItemId(description="The id of the unstackable generic item")
    public static int itemGenericUnstackableId = 14996;
    @ConfigProperty(category="dropblock", name="searchDistance", comment="The range of the drop block")
    public static int elevatorTravelDistance = 20;
    @ConfigProperty(category="dropblock", name="mustFaceDirection", comment="Must the user face the direction they want to travel?")
    public static boolean elevatorBlockMustFaceDirection = false;
    @ConfigProperty(category="dropblock", name="ignoreHalfBlocks", comment="The elevator will ignore half blocks when counting the blocks it can pass through")
    public static boolean elevatorIgnoreHalfBlocks = false;
    @ConfigProperty(category="dropblock", name="maxPassThrough", comment="The maximum amount of blocks the elevator can pass through before the teleport fails. -1 disables this")
    public static int elevatorMaxBlockPassCount = 4;
    @ConfigProperty(category="dropblock", name="elevatorDrainsXP", comment="Does the elevator drain player XP when used?")
    public static boolean elevatorDrainsXP = true;
    @ConfigProperty(category="tanks", name="bucketsPerTank", comment="The amount of buckets each tank can hold")
    public static int bucketsPerTank = 16;
    @ConfigProperty(category="hacks", name="tryHookPlayerRenderer", comment="Allow OpenBlocks to hook the player renderer to apply special effects")
    public static boolean tryHookPlayerRenderer = true;
    @ConfigProperty(category="trophy", name="trophyDropChance", comment="The chance (from 0 to 1) of a trophy drop. for example, 0.001 for 1/1000")
    public static double trophyDropChance = 0.001;
    @ConfigProperty(category="dropblock", name="irregularBlocksArePassable", comment="The elevator will try to pass through blocks that have custom collision boxes")
    public static boolean irregularBlocksArePassable = true;
    @ConfigProperty(category="tanks", name="emitLight", comment="Tanks will emit light when they contain a liquid that glows (eg. lava)")
    public static boolean tanksEmitLight = true;
    @ConfigProperty(category="sprinkler", name="fertilizeChance", comment="1/chance that crops will be fertilized without bonemeal")
    public static int sprinklerFertilizeChance = 500;
    @ConfigProperty(category="sprinkler", name="bonemealFertilizeChance", comment="1/chance that crops will be fertilized with bonemeal")
    public static int sprinklerBonemealFertizizeChance = 200;
    @ConfigProperty(category="sprinkler", name="effectiveRange", comment="The range in each cardinal direction that crops will be affected.")
    public static int sprinklerEffectiveRange = 4;
    @ConfigProperty(category="glasses", name="opacity", comment="0.0 - no visible change to world, 1.0 - world fully obscured")
    public static double sonicGlassesOpacity = 0.95;
    @ConfigProperty(category="glasses", name="useTexture", comment="Use texture for obscuring world")
    public static boolean sonicGlassesUseTexture = true;
    @ConfigProperty(category="imaginary", name="fadingSpeed", comment="Speed of imaginary blocks fading/appearing")
    public static float imaginaryFadingSpeed = 0.0075f;
    @ConfigProperty(category="imaginary", name="numberOfUses", comment="Number of newly created crayon/pencil uses")
    public static float imaginaryItemUseCount = 10.0f;
    @ConfigProperty(category="crane", name="doCraneCollisionCheck", comment="Enable collision checking of crane arm")
    public static boolean doCraneCollisionCheck = false;
    @ConfigProperty(category="crane", name="boringMode", comment="Use shift to control crane direction (otherwise, toggle every time)")
    public static boolean craneShiftControl = true;
    @ConfigProperty(category="crane", name="turtleMagnetRange", comment="Range of magnet CC peripheral")
    public static double turtleMagnetRange = 4.0;
    @ConfigProperty(category="crane", name="addTurtles", comment="Enable magnet turtles in creative list")
    public static boolean addCraneTurtles = true;
    @ConfigProperty(category="hacks", name="enableExperimentalFeatures", comment="Enable experimental features that may be buggy or broken entirely")
    public static boolean experimentalFeatures = false;
    @ConfigProperty(category="tomfoolery", name="weAreSeriousPeople", comment="Are you serious too?")
    public static boolean soSerious = true;
    @ConfigProperty(category="tomfoolery", name="doItWhileTyping", comment="You know, THAT thing! That you shouldn't do in public!")
    public static boolean fartTypying = false;
    @ConfigProperty(category="debug", name="goldenEyeDebug", comment="Show structures found by golden eye")
    public static boolean eyeDebug = false;
    @ConfigProperty(category="debug", name="gravesDebug", comment="Dump extra amount of data, every time grave is created")
    public static boolean debugGraves = false;
    @ConfigProperty(category="features", name="explosiveEnchantmentId", comment="Id of explosive enchantment")
    public static int explosiveEnchantmentId = 211;
    @ConfigProperty(category="cursor", name="cursorMaxDamage", comment="Amount of damage a cursor can take")
    public static int cursorMaxDamage = 128;
    public static List<String> disableMobNames = Lists.newArrayList();

    static void readConfig(Configuration configFile) {
        ConfigProcessing.processAnnotations((Configuration)configFile, Config.class);
        Property prop = configFile.get("additional", "disableMobNames", new String[0], "List any mob names you want disabled on the server");
        disableMobNames = Arrays.asList(prop.getStringList());
    }

    public static void register() {
        WeightedRandomChestContent drop;
        if (disableMobNames.size() > 0) {
            MinecraftForge.EVENT_BUS.register((Object)new EntityEventHandler());
        }
        List recipeList = CraftingManager.func_77594_a().func_77592_b();
        OpenBlocks.Items.generic = new ItemOBGeneric();
        MetasGeneric.registerItems();
        OpenBlocks.Items.generic.initRecipes();
        OpenBlocks.Items.genericUnstackable = new ItemOBGenericUnstackable();
        MetasGenericUnstackable.registerItems();
        OpenBlocks.Items.genericUnstackable.initRecipes();
        if (itemFilledBucketId > 0) {
            OpenBlocks.Items.filledBucket = new ItemFilledBucket();
            MetasBucket.registerItems();
        }
        if (ConfigProcessing.canRegisterBlock((int)blockLadderId)) {
            OpenBlocks.Blocks.ladder = new BlockLadder();
            recipeList.add(new ShapelessOreRecipe((Block)OpenBlocks.Blocks.ladder, new Object[]{Block.field_72055_aF, Block.field_72005_bk}));
        }
        if (ConfigProcessing.canRegisterBlock((int)blockGuideId)) {
            OpenBlocks.Blocks.guide = new BlockGuide();
            recipeList.add(new ShapedOreRecipe((Block)OpenBlocks.Blocks.guide, new Object[]{"ggg", "gtg", "ggg", Character.valueOf('g'), Block.field_71946_M, Character.valueOf('t'), Block.field_72069_aq}));
        }
        if (ConfigProcessing.canRegisterBlock((int)blockElevatorId)) {
            OpenBlocks.Blocks.elevator = new BlockElevator();
            recipeList.add(new ShapedOreRecipe((Block)OpenBlocks.Blocks.elevator, new Object[]{"www", "wew", "www", Character.valueOf('w'), Block.field_72101_ab, Character.valueOf('e'), Item.field_77730_bn}));
        }
        if (ConfigProcessing.canRegisterBlock((int)blockHealId)) {
            OpenBlocks.Blocks.heal = new BlockHeal();
        }
        if (ConfigProcessing.canRegisterBlock((int)blockTargetId)) {
            OpenBlocks.Blocks.target = new BlockTarget();
            recipeList.add(new ShapedOreRecipe((Block)OpenBlocks.Blocks.target, new Object[]{"www", "www", "s s", Character.valueOf('w'), Block.field_72101_ab, Character.valueOf('s'), "stickWood"}));
        }
        if (ConfigProcessing.canRegisterBlock((int)blockGraveId)) {
            OpenBlocks.Blocks.grave = new BlockGrave();
        }
        if (ConfigProcessing.canRegisterBlock((int)blockFlagId)) {
            OpenBlocks.Blocks.flag = new BlockFlag();
            recipeList.add(new ShapedOreRecipe(new ItemStack((Block)OpenBlocks.Blocks.flag, 3), new Object[]{"scc", "sc ", "s  ", Character.valueOf('c'), Block.field_111031_cC, Character.valueOf('s'), "stickWood"}));
        }
        if (ConfigProcessing.canRegisterBlock((int)blockTankId)) {
            OpenBlocks.Blocks.tank = new BlockTank();
            recipeList.add(new ShapedOreRecipe(new ItemStack((Block)OpenBlocks.Blocks.tank, 2), new Object[]{"ogo", "ggg", "ogo", Character.valueOf('g'), Block.field_72003_bq, Character.valueOf('o'), Block.field_72089_ap}));
        }
        if (ConfigProcessing.canRegisterBlock((int)blockTrophyId)) {
            OpenBlocks.Blocks.trophy = new BlockTrophy();
            MinecraftForge.EVENT_BUS.register((Object)new TrophyHandler());
        }
        if (ConfigProcessing.canRegisterBlock((int)blockBearTrapId)) {
            OpenBlocks.Blocks.bearTrap = new BlockBearTrap();
            recipeList.add(new ShapedOreRecipe((Block)OpenBlocks.Blocks.bearTrap, new Object[]{"fif", "fif", "fif", Character.valueOf('f'), Block.field_72002_bp, Character.valueOf('i'), Item.field_77703_o}));
        }
        if (ConfigProcessing.canRegisterBlock((int)blockSprinklerId)) {
            OpenBlocks.Blocks.sprinkler = new BlockSprinkler();
            recipeList.add(new ShapedOreRecipe((Block)OpenBlocks.Blocks.sprinkler, new Object[]{"ifi", "iri", "ifi", Character.valueOf('i'), Item.field_77703_o, Character.valueOf('r'), Block.field_72035_aQ, Character.valueOf('f'), Block.field_72002_bp}));
        }
        if (ConfigProcessing.canRegisterBlock((int)blockCannonId)) {
            OpenBlocks.Blocks.cannon = new BlockCannon();
            recipeList.add(new ShapedOreRecipe((Block)OpenBlocks.Blocks.cannon, new Object[]{" d ", " f ", "iri", Character.valueOf('d'), Block.field_71958_P, Character.valueOf('f'), Block.field_72002_bp, Character.valueOf('i'), Item.field_77703_o, Character.valueOf('r'), Block.field_94341_cq}));
        }
        if (ConfigProcessing.canRegisterBlock((int)blockVacuumHopperId)) {
            OpenBlocks.Blocks.vacuumHopper = new BlockVacuumHopper();
            recipeList.add(new ShapelessOreRecipe((Block)OpenBlocks.Blocks.vacuumHopper, new Object[]{Block.field_94340_cs, Block.field_72089_ap, Item.field_77730_bn}));
        }
        if (ConfigProcessing.canRegisterBlock((int)blockSpongeId)) {
            OpenBlocks.Blocks.sponge = new BlockSponge();
            recipeList.add(new ShapelessOreRecipe((Block)OpenBlocks.Blocks.sponge, new Object[]{Block.field_72101_ab, Item.field_77761_aM}));
        }
        if (ConfigProcessing.canRegisterBlock((int)blockBigButton)) {
            OpenBlocks.Blocks.bigButton = new BlockBigButton();
            recipeList.add(new ShapedOreRecipe((Block)OpenBlocks.Blocks.bigButton, new Object[]{"bb", "bb", Character.valueOf('b'), Block.field_72034_aR}));
        }
        if (ConfigProcessing.canRegisterBlock((int)blockImaginaryId)) {
            OpenBlocks.Blocks.imaginary = new BlockImaginary();
            ItemStack pencil = ItemImaginary.setupValues(null, new ItemStack((Block)OpenBlocks.Blocks.imaginary, 1, 0));
            recipeList.add(new ShapelessOreRecipe(pencil, new Object[]{Item.field_77705_m, "stickWood", Item.field_77730_bn, Item.field_77761_aM}));
            for (ColorUtils.ColorMeta color : ColorUtils.getAllColors()) {
                ItemStack crayon = ItemImaginary.setupValues(color.rgb, new ItemStack((Block)OpenBlocks.Blocks.imaginary, 1, 1));
                recipeList.add(new ShapelessOreRecipe(crayon, new Object[]{color.oreName, Item.field_77759_aK, Item.field_77730_bn, Item.field_77761_aM}));
            }
            recipeList.add(new CrayonMixingRecipe());
        }
        if (ConfigProcessing.canRegisterBlock((int)blockFanId)) {
            OpenBlocks.Blocks.fan = new BlockFan();
            recipeList.add(new ShapedOreRecipe((Block)OpenBlocks.Blocks.fan, new Object[]{"f", "i", "s", Character.valueOf('f'), Block.field_72002_bp, Character.valueOf('i'), Item.field_77703_o, Character.valueOf('s'), Block.field_72079_ak}));
        }
        if (ConfigProcessing.canRegisterBlock((int)blockXPBottlerId)) {
            OpenBlocks.Blocks.xpBottler = new BlockXPBottler();
            recipeList.add(new ShapedOreRecipe((Block)OpenBlocks.Blocks.xpBottler, new Object[]{"iii", "ibi", "iii", Character.valueOf('i'), Item.field_77703_o, Character.valueOf('b'), Item.field_77729_bt}));
        }
        if (ConfigProcessing.canRegisterBlock((int)blockVillageHighlighterId)) {
            OpenBlocks.Blocks.villageHighlighter = new BlockVillageHighlighter();
            recipeList.add(new ShapedOreRecipe((Block)OpenBlocks.Blocks.villageHighlighter, new Object[]{"www", "wew", "ccc", Character.valueOf('w'), "plankWood", Character.valueOf('e'), Item.field_77817_bH, Character.valueOf('c'), Block.field_71978_w}));
        }
        if (ConfigProcessing.canRegisterBlock((int)blockPathId)) {
            OpenBlocks.Blocks.path = new BlockPath();
            recipeList.add(new ShapelessOreRecipe(new ItemStack((Block)OpenBlocks.Blocks.path, 2), new Object[]{"stone", "cobblestone"}));
        }
        if (ConfigProcessing.canRegisterBlock((int)blockAutoAnvilId)) {
            OpenBlocks.Blocks.autoAnvil = new BlockAutoAnvil();
            recipeList.add(new ShapedOreRecipe((Block)OpenBlocks.Blocks.autoAnvil, new Object[]{"iii", "iai", "rrr", Character.valueOf('i'), Item.field_77703_o, Character.valueOf('a'), Block.field_82510_ck, Character.valueOf('r'), Item.field_77767_aC}));
        }
        if (ConfigProcessing.canRegisterBlock((int)blockAutoEnchantmentTableId)) {
            OpenBlocks.Blocks.autoEnchantmentTable = new BlockAutoEnchantmentTable();
            recipeList.add(new ShapedOreRecipe((Block)OpenBlocks.Blocks.autoEnchantmentTable, new Object[]{"iii", "iei", "rrr", Character.valueOf('i'), Item.field_77703_o, Character.valueOf('e'), Block.field_72096_bE, Character.valueOf('r'), Item.field_77767_aC}));
        }
        if (ConfigProcessing.canRegisterBlock((int)blockXPDrainId)) {
            OpenBlocks.Blocks.xpDrain = new BlockXPDrain();
            recipeList.add(new ShapedOreRecipe((Block)OpenBlocks.Blocks.xpDrain, new Object[]{"iii", "iii", "iii", Character.valueOf('i'), Block.field_72002_bp}));
        }
        if (ConfigProcessing.canRegisterBlock((int)blockBlockBreakerId)) {
            OpenBlocks.Blocks.blockBreaker = new BlockBlockBreaker();
            recipeList.add(new ShapedOreRecipe((Block)OpenBlocks.Blocks.blockBreaker, new Object[]{"icc", "src", "icc", Character.valueOf('i'), Item.field_77703_o, Character.valueOf('c'), Block.field_71978_w, Character.valueOf('r'), Item.field_77767_aC, Character.valueOf('s'), Item.field_77674_B}));
        }
        if (ConfigProcessing.canRegisterBlock((int)blockBlockPlacerId)) {
            OpenBlocks.Blocks.blockPlacer = new BlockBlockPlacer();
            recipeList.add(new ShapedOreRecipe((Block)OpenBlocks.Blocks.blockPlacer, new Object[]{"icc", "src", "icc", Character.valueOf('i'), Item.field_77703_o, Character.valueOf('c'), Block.field_71978_w, Character.valueOf('r'), Item.field_77767_aC, Character.valueOf('s'), Block.field_71963_Z}));
        }
        if (ConfigProcessing.canRegisterBlock((int)blockItemDropperId)) {
            OpenBlocks.Blocks.itemDropper = new BlockItemDropper();
            recipeList.add(new ShapedOreRecipe((Block)OpenBlocks.Blocks.itemDropper, new Object[]{"icc", "src", "icc", Character.valueOf('i'), Item.field_77703_o, Character.valueOf('c'), Block.field_71978_w, Character.valueOf('r'), Item.field_77767_aC, Character.valueOf('s'), Block.field_94340_cs}));
        }
        if (ConfigProcessing.canRegisterBlock((int)blockRopeLadderId)) {
            OpenBlocks.Blocks.ropeLadder = new BlockRopeLadder();
            recipeList.add(new ShapedOreRecipe((Block)OpenBlocks.Blocks.ropeLadder, new Object[]{"sts", "sts", "sts", Character.valueOf('t'), "stickWood", Character.valueOf('s'), Item.field_77683_K}));
        }
        if (ConfigProcessing.canRegisterBlock((int)blockDonationStationId)) {
            OpenBlocks.Blocks.donationStation = new BlockDonationStation();
            drop = new WeightedRandomChestContent(new ItemStack((Block)OpenBlocks.Blocks.donationStation), 1, 1, 2);
            ChestGenHooks.getInfo((String)"dungeonChest").addItem(drop);
            ChestGenHooks.getInfo((String)"mineshaftCorridor").addItem(drop);
            recipeList.add(new ShapedOreRecipe((Block)OpenBlocks.Blocks.donationStation, new Object[]{"ppp", "pcp", "ppp", Character.valueOf('p'), Item.field_77784_aq, Character.valueOf('c'), Block.field_72077_au}));
        }
        if (ConfigProcessing.canRegisterBlock((int)blockPaintMixer)) {
            OpenBlocks.Blocks.paintMixer = new BlockPaintMixer();
            recipeList.add(new ShapedOreRecipe((Block)OpenBlocks.Blocks.paintMixer, new Object[]{"ooo", "i i", "iii", Character.valueOf('o'), Block.field_72089_ap, Character.valueOf('i'), Item.field_77703_o}));
        }
        if (ConfigProcessing.canRegisterBlock((int)blockCanvasId)) {
            OpenBlocks.Blocks.canvas = new BlockCanvas();
            recipeList.add(new ShapedOreRecipe(new ItemStack((Block)OpenBlocks.Blocks.canvas, 9), new Object[]{"ppp", "pfp", "ppp", Character.valueOf('p'), Item.field_77759_aK, Character.valueOf('f'), Block.field_72031_aZ}));
        }
        if (experimentalFeatures && ConfigProcessing.canRegisterBlock((int)blockMachineOreCrusherId)) {
            OpenBlocks.Blocks.machineOreCrusher = new BlockMachineOreCrusher();
        }
        if (ConfigProcessing.canRegisterBlock((int)blockPaintCanId)) {
            OpenBlocks.Blocks.paintCan = new BlockPaintCan();
        }
        if (ConfigProcessing.canRegisterBlock((int)blockCanvasGlassId)) {
            OpenBlocks.Blocks.canvasGlass = new BlockCanvasGlass();
        }
        if (ConfigProcessing.canRegisterBlock((int)blockProjectorId)) {
            OpenBlocks.Blocks.projector = new BlockProjector();
            ItemStack lapis = new ItemStack(Item.field_77756_aW, 1, 4);
            recipeList.add(new ShapedOreRecipe((Block)OpenBlocks.Blocks.projector, new Object[]{"grl", "iri", "srs", Character.valueOf('s'), Block.field_72079_ak, Character.valueOf('r'), Item.field_77767_aC, Character.valueOf('g'), Item.field_77751_aT, Character.valueOf('i'), Item.field_77703_o, Character.valueOf('l'), lapis}));
            recipeList.add(new ShapedOreRecipe((Block)OpenBlocks.Blocks.projector, new Object[]{"lrg", "iri", "srs", Character.valueOf('s'), Block.field_72079_ak, Character.valueOf('r'), Item.field_77767_aC, Character.valueOf('g'), Item.field_77751_aT, Character.valueOf('i'), Item.field_77703_o, Character.valueOf('l'), lapis}));
        }
        if (ConfigProcessing.canRegisterBlock((int)blockDrawingTable)) {
            OpenBlocks.Blocks.drawingTable = new BlockDrawingTable();
            recipeList.add(new ShapedOreRecipe((Block)OpenBlocks.Blocks.drawingTable, new Object[]{"sks", "pcp", "ppp", Character.valueOf('p'), Block.field_71988_x, Character.valueOf('c'), Block.field_72060_ay, Character.valueOf('s'), MetasGeneric.unpreparedStencil.newItemStack(), Character.valueOf('k'), MetasGeneric.sketchingPencil.newItemStack()}));
        }
        if (itemHangGliderId > 0) {
            OpenBlocks.Items.hangGlider = new ItemHangGlider();
            recipeList.add(new ShapedOreRecipe((Item)OpenBlocks.Items.hangGlider, new Object[]{"wsw", Character.valueOf('w'), MetasGeneric.gliderWing.newItemStack(), Character.valueOf('s'), "stickWood"}));
        }
        if (itemLuggageId > 0) {
            OpenBlocks.Items.luggage = new ItemLuggage();
            recipeList.add(new ShapedOreRecipe((Item)OpenBlocks.Items.luggage, new Object[]{"sds", "scs", "sss", Character.valueOf('s'), "stickWood", Character.valueOf('d'), Item.field_77702_n, Character.valueOf('c'), Block.field_72077_au}));
        }
        if (itemSonicGlassesId > 0) {
            OpenBlocks.Items.sonicGlasses = new ItemSonicGlasses();
            recipeList.add(new ShapedOreRecipe((Item)OpenBlocks.Items.sonicGlasses, new Object[]{"ihi", "oso", "   ", Character.valueOf('s'), "stickWood", Character.valueOf('h'), Item.field_77812_ad, Character.valueOf('o'), Block.field_72089_ap, Character.valueOf('i'), Item.field_77703_o}));
        }
        if (OpenBlocks.Blocks.imaginary != null) {
            if (itemGlassesPencil > 0) {
                OpenBlocks.Items.pencilGlasses = new ItemImaginationGlasses(itemGlassesPencil, ItemImaginationGlasses.Type.PENCIL);
                ItemStack block = new ItemStack((Block)OpenBlocks.Blocks.imaginary, 1, 0);
                ItemImaginary.setupValues(null, block);
                recipeList.add(new ShapelessOreRecipe((Item)OpenBlocks.Items.pencilGlasses, new Object[]{block, Item.field_77759_aK}));
            }
            if (itemGlassesCrayon > 0) {
                OpenBlocks.Items.crayonGlasses = new ItemImaginationGlasses.ItemCrayonGlasses(itemGlassesCrayon);
                recipeList.add(new CrayonGlassesRecipe());
            }
            if (itemGlassesTechnicolor > 0) {
                OpenBlocks.Items.technicolorGlasses = new ItemImaginationGlasses(itemGlassesTechnicolor, ItemImaginationGlasses.Type.TECHNICOLOR);
                drop = new WeightedRandomChestContent(new ItemStack((Item)OpenBlocks.Items.technicolorGlasses), 1, 1, 2);
                ChestGenHooks.getInfo((String)"dungeonChest").addItem(drop);
                ChestGenHooks.getInfo((String)"mineshaftCorridor").addItem(drop);
            }
            if (itemGlassesSerious > 0) {
                OpenBlocks.Items.seriousGlasses = new ItemImaginationGlasses(itemGlassesSerious, ItemImaginationGlasses.Type.BASTARD);
            }
        }
        if (itemCraneControl > 0) {
            OpenBlocks.Items.craneControl = new ItemCraneControl();
            recipeList.add(new ShapedOreRecipe((Item)OpenBlocks.Items.craneControl, new Object[]{"ili", "grg", "iri", Character.valueOf('i'), Item.field_77703_o, Character.valueOf('g'), Item.field_77733_bq, Character.valueOf('l'), Item.field_77751_aT, Character.valueOf('r'), Item.field_77767_aC}));
        }
        if (itemCraneId > 0) {
            OpenBlocks.Items.craneBackpack = new ItemCraneBackpack();
            ItemStack line = MetasGeneric.line.newItemStack();
            ItemStack beam = MetasGeneric.beam.newItemStack();
            recipeList.add(new ShapelessOreRecipe((Item)OpenBlocks.Items.craneBackpack, new Object[]{MetasGeneric.craneEngine.newItemStack(), MetasGeneric.craneMagnet.newItemStack(), beam, beam, line, line, line, Item.field_77770_aF}));
        }
        if (itemSlimalyzerId > 0) {
            OpenBlocks.Items.slimalyzer = new ItemSlimalyzer();
            recipeList.add(new ShapedOreRecipe((Item)OpenBlocks.Items.slimalyzer, new Object[]{"igi", "isi", "iri", Character.valueOf('i'), Item.field_77703_o, Character.valueOf('g'), Block.field_72003_bq, Character.valueOf('s'), Item.field_77761_aM, Character.valueOf('r'), Item.field_77767_aC}));
        }
        if (itemSleepingBagId > 0 && EntityPlayerVisitor.IsInBedHookSuccess) {
            OpenBlocks.Items.sleepingBag = new ItemSleepingBag();
            recipeList.add(new ShapedOreRecipe((Item)OpenBlocks.Items.sleepingBag, new Object[]{"cc ", "www", "ccw", Character.valueOf('c'), Block.field_111031_cC, Character.valueOf('w'), Block.field_72101_ab}));
        }
        if (itemPaintBrushId > 0) {
            OpenBlocks.Items.paintBrush = new ItemPaintBrush();
            recipeList.add(new ShapedOreRecipe((Item)OpenBlocks.Items.paintBrush, new Object[]{"w  ", " s ", "  s", Character.valueOf('w'), Block.field_72101_ab, Character.valueOf('s'), "stickWood"}));
        }
        if (itemStencilId > 0) {
            OpenBlocks.Items.stencil = new ItemStencil();
            for (Stencil stencil : Stencil.values()) {
                WeightedRandomChestContent drop2 = new WeightedRandomChestContent(new ItemStack((Item)OpenBlocks.Items.stencil, 1, stencil.ordinal()), 1, 1, 2);
                ChestGenHooks.getInfo((String)"dungeonChest").addItem(drop2);
                ChestGenHooks.getInfo((String)"mineshaftCorridor").addItem(drop2);
            }
        }
        if (itemSqueegeeId > 0) {
            OpenBlocks.Items.squeegee = new ItemSqueegee();
            if (OpenBlocks.Blocks.sponge != null) {
                recipeList.add(new ShapedOreRecipe((Item)OpenBlocks.Items.squeegee, new Object[]{"sss", " w ", " w ", Character.valueOf('s'), OpenBlocks.Blocks.sponge, Character.valueOf('w'), "stickWood"}));
            } else {
                recipeList.add(new ShapedOreRecipe((Item)OpenBlocks.Items.squeegee, new Object[]{"sss", " w ", " w ", Character.valueOf('s'), Item.field_77761_aM, Character.valueOf('w'), "stickWood"}));
            }
        }
        if (itemHeightMap > 0) {
            OpenBlocks.Items.heightMap = new ItemHeightMap();
            if (itemEmptyMap > 0) {
                recipeList.add(new MapCloneRecipe());
            }
        }
        if (itemEmptyMap > 0) {
            OpenBlocks.Items.emptyMap = new ItemEmptyMap();
            recipeList.add(new MapResizeRecipe());
            ItemStack memory = MetasGeneric.mapMemory.newItemStack(2);
            ItemStack cpu = MetasGeneric.mapController.newItemStack(1);
            recipeList.add(new ShapedOreRecipe(OpenBlocks.Items.emptyMap.createMap(0), new Object[]{" m ", "mcm", " m ", Character.valueOf('m'), memory, Character.valueOf('c'), cpu}));
        }
        if (itemCartographerId > 0) {
            OpenBlocks.Items.cartographer = new ItemCartographer();
            recipeList.add(new ShapelessOreRecipe((Item)OpenBlocks.Items.cartographer, new Object[]{MetasGeneric.assistantBase.newItemStack(), Item.field_77748_bA}));
        }
        if (itemGoldenEyeId > 0) {
            OpenBlocks.Items.goldenEye = new ItemGoldenEye();
            recipeList.add(new GoldenEyeRechargeRecipe());
            recipeList.add(new ShapedOreRecipe(new ItemStack((Item)OpenBlocks.Items.goldenEye, 1, 100), new Object[]{"ggg", "geg", "ggg", Character.valueOf('g'), Item.field_77733_bq, Character.valueOf('e'), Item.field_77748_bA}));
        }
        if (itemTastyClay > 0) {
            OpenBlocks.Items.tastyClay = new ItemTastyClay();
            ItemStack cocoa = new ItemStack(Item.field_77756_aW, 1, 3);
            recipeList.add(new ShapelessOreRecipe(new ItemStack((Item)OpenBlocks.Items.tastyClay, 2), new Object[]{Item.field_77757_aI, Item.field_77771_aG, cocoa}));
        }
        if (itemCursorId > 0) {
            OpenBlocks.Items.cursor = new ItemCursor();
            ItemStack whiteWool = ColorUtils.createDyedWool((int)15);
            recipeList.add(new ShapedOreRecipe((Item)OpenBlocks.Items.cursor, new Object[]{"w  ", "www", "www", Character.valueOf('w'), whiteWool}));
        }
        if (explosiveEnchantmentId > 0) {
            MinecraftForge.EVENT_BUS.register((Object)new ExplosiveEnchantmentsHandler());
            OpenBlocks.explosiveEnch = new EnchantmentExplosive(explosiveEnchantmentId);
        }
        String modId = "openblocks";
        ConfigProcessing.registerItems(OpenBlocks.Items.class, (String)"openblocks");
        ConfigProcessing.registerBlocks(OpenBlocks.Blocks.class, (String)"openblocks");
    }
}

