/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.neiaddons.forestry;

import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBeeRoot;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.ITreeRoot;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import forestry.api.lepidopterology.IAlleleButterflySpecies;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.bdew.neiaddons.forestry.AddonForestry;
import net.minecraft.item.ItemStack;

public class GeneticsUtils {
    public static Map<RecipePosition, Integer> beePositionToType = new HashMap<RecipePosition, Integer>();
    public static Map<RecipePosition, Integer> treePositionToType;

    public static ItemStack stackFromSpecies(IAlleleSpecies species, RecipePosition position) {
        ISpeciesRoot root = species.getRoot();
        int type = 0;
        if (root instanceof IBeeRoot) {
            type = beePositionToType.get((Object)position);
        } else if (root instanceof ITreeRoot) {
            type = treePositionToType.get((Object)position);
        }
        return GeneticsUtils.stackFromSpecies(species, type);
    }

    public static ItemStack stackFromSpecies(IAlleleSpecies species, int type) {
        ISpeciesRoot root = species.getRoot();
        IAllele[] template = root.getTemplate(species.getUID());
        if (template == null) {
            AddonForestry.instance.logWarning("Template for %s is null, wtf?", species.getUID());
            return null;
        }
        IIndividual individual = root.templateAsIndividual(template);
        individual.analyze();
        ItemStack stack = root.getMemberStack(individual, type);
        if (stack == null) {
            AddonForestry.instance.logWarning("Got null from getMemberStack, wtf? (%s)", species.getUID());
        }
        return stack;
    }

    @Deprecated
    public static ItemStack stackFromAllele(IAllele allele, EnumBeeType type) {
        assert (allele instanceof IAlleleSpecies);
        return GeneticsUtils.stackFromSpecies((IAlleleSpecies)allele, type.ordinal());
    }

    public static Collection<IAlleleBeeSpecies> getAllBeeSpecies(boolean includeBlacklisted) {
        return GeneticsUtils.getAllTypedSpecies(IAlleleBeeSpecies.class, includeBlacklisted);
    }

    public static Collection<IAlleleButterflySpecies> getAllButterflySpecies(boolean includeBlacklisted) {
        return GeneticsUtils.getAllTypedSpecies(IAlleleButterflySpecies.class, includeBlacklisted);
    }

    public static Collection<IAlleleTreeSpecies> getAllTreeSpecies(boolean includeBlacklisted) {
        return GeneticsUtils.getAllTypedSpecies(IAlleleTreeSpecies.class, includeBlacklisted);
    }

    public static <T> Collection<T> getAllTypedSpecies(Class<? extends T> type, boolean includeBlacklisted) {
        ArrayList list = new ArrayList();
        for (Map.Entry entry : AlleleManager.alleleRegistry.getRegisteredAlleles().entrySet()) {
            if (!type.isInstance(entry.getValue()) || !includeBlacklisted && AlleleManager.alleleRegistry.isBlacklisted(((IAllele)entry.getValue()).getUID())) continue;
            list.add(entry.getValue());
        }
        return list;
    }

    public static Map<ItemStack, Integer> getProduceFromSpecies(IAlleleSpecies species) {
        if (species instanceof IAlleleBeeSpecies) {
            return ((IAlleleBeeSpecies)species).getProducts();
        }
        if (species instanceof IAlleleTreeSpecies) {
            HashMap<ItemStack, Integer> result = new HashMap<ItemStack, Integer>();
            ITreeRoot root = (ITreeRoot)species.getRoot();
            IAllele[] template = root.getTemplate(species.getUID());
            if (template == null) {
                AddonForestry.instance.logWarning("Template for %s is null, wtf?", species.getUID());
                return result;
            }
            ITree tree = (ITree)root.templateAsIndividual(template);
            for (ItemStack stack : tree.getProduceList()) {
                if (stack == null) {
                    AddonForestry.instance.logWarning("%s returned null in produce list", species.toString());
                    continue;
                }
                result.put(stack, 100);
            }
            return result;
        }
        return null;
    }

    public static Map<ItemStack, Integer> getSpecialtyFromSpecies(IAlleleSpecies species) {
        if (species instanceof IAlleleBeeSpecies) {
            return ((IAlleleBeeSpecies)species).getSpecialty();
        }
        if (species instanceof IAlleleTreeSpecies) {
            HashMap<ItemStack, Integer> result = new HashMap<ItemStack, Integer>();
            ITreeRoot root = (ITreeRoot)species.getRoot();
            IAllele[] template = root.getTemplate(species.getUID());
            if (template == null) {
                AddonForestry.instance.logWarning("Template for %s is null, wtf?", species.getUID());
                return result;
            }
            ITree tree = (ITree)root.templateAsIndividual(template);
            for (ItemStack stack : tree.getSpecialtyList()) {
                if (stack == null) {
                    AddonForestry.instance.logWarning("%s returned null in specialty list", species.toString());
                    continue;
                }
                result.put(stack, 100);
            }
            return result;
        }
        return null;
    }

    static {
        beePositionToType.put(RecipePosition.Parent1, EnumBeeType.PRINCESS.ordinal());
        beePositionToType.put(RecipePosition.Parent2, EnumBeeType.DRONE.ordinal());
        beePositionToType.put(RecipePosition.Offspring, EnumBeeType.QUEEN.ordinal());
        beePositionToType.put(RecipePosition.Producer, EnumBeeType.QUEEN.ordinal());
        treePositionToType = new HashMap<RecipePosition, Integer>();
        treePositionToType.put(RecipePosition.Parent1, EnumGermlingType.SAPLING.ordinal());
        treePositionToType.put(RecipePosition.Parent2, EnumGermlingType.POLLEN.ordinal());
        treePositionToType.put(RecipePosition.Offspring, EnumGermlingType.SAPLING.ordinal());
        treePositionToType.put(RecipePosition.Producer, EnumGermlingType.SAPLING.ordinal());
    }

    public static enum RecipePosition {
        Parent1,
        Parent2,
        Offspring,
        Producer;

    }
}

