/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.util.crafting;

import cofh.util.ItemHelper;
import cofh.util.StringHelper;
import cofh.util.inventory.ComparableItemStackSafe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.TEBlocks;
import thermalexpansion.item.TEItems;
import thermalexpansion.util.crafting.FurnaceManager;

public class SmelterManager {
    public static ItemStack blockSand = new ItemStack(Block.field_71939_E);
    public static ItemStack ingotIron = new ItemStack(Item.field_77703_o);
    public static ItemStack ingotGold = new ItemStack(Item.field_77717_p);
    private static Map<List, RecipeSmelter> recipeMap = new HashMap<List, RecipeSmelter>();
    private static Set<ComparableItemStackSafe> validationSet = new HashSet<ComparableItemStackSafe>();
    private static ComparableItemStackSafe query = new ComparableItemStackSafe(new ItemStack(Block.field_71981_t));
    private static ComparableItemStackSafe querySecondary = new ComparableItemStackSafe(new ItemStack(Block.field_71981_t));
    private static boolean allowOverwrite = false;
    private static ArrayList<String> blastList = new ArrayList();

    public static boolean isRecipeReversed(ItemStack primaryInput, ItemStack secondaryInput) {
        if (primaryInput == null || secondaryInput == null) {
            return false;
        }
        RecipeSmelter recipe = recipeMap.get(Arrays.asList(query.set(primaryInput), querySecondary.set(secondaryInput)));
        return recipe != null ? false : recipeMap.get(Arrays.asList(querySecondary, query)) != null;
    }

    public static RecipeSmelter getRecipe(ItemStack primaryInput, ItemStack secondaryInput) {
        if (primaryInput == null || secondaryInput == null) {
            return null;
        }
        RecipeSmelter recipe = recipeMap.get(Arrays.asList(query.set(primaryInput), querySecondary.set(secondaryInput)));
        if (recipe == null) {
            recipe = recipeMap.get(Arrays.asList(querySecondary, query));
        }
        if (recipe == null) {
            return null;
        }
        return recipe;
    }

    public static boolean recipeExists(ItemStack primaryInput, ItemStack secondaryInput) {
        return SmelterManager.getRecipe(primaryInput, secondaryInput) != null;
    }

    public static RecipeSmelter[] getRecipeList() {
        return recipeMap.values().toArray(new RecipeSmelter[0]);
    }

    public static boolean isItemValid(ItemStack input) {
        if (input == null) {
            return false;
        }
        return validationSet.contains(query.set(input));
    }

    public static boolean isStandardOre(String oreName) {
        return ItemHelper.oreNameExists((String)oreName) && FurnaceManager.recipeExists((ItemStack)OreDictionary.getOres((String)oreName).get(0));
    }

    public static void addDefaultRecipes() {
        SmelterManager.addTERecipe(4000, new ItemStack(Block.field_72047_aN), blockSand, new ItemStack(Block.field_94341_cq), TEItems.slagRich, 40);
        SmelterManager.addTERecipe(4000, new ItemStack(Block.field_72012_bb, 4), new ItemStack(Block.field_72013_bc), new ItemStack(Block.field_72033_bA, 2), TEItems.dustSulfur, 25);
    }

    public static void loadRecipes() {
        int i;
        SmelterManager.addDefaultRecipes();
        boolean steelRecipe = ThermalExpansion.config.get("tweak.crafting", "Smelter.Steel.Enable", true);
        ItemStack blockGlass = new ItemStack(TEBlocks.blockGlass, 2, 0);
        SmelterManager.addAlloyRecipe(4000, "dustLead", 1, "dustObsidian", 8, blockGlass);
        SmelterManager.addAlloyRecipe(4000, "ingotLead", 1, "dustObsidian", 8, blockGlass);
        SmelterManager.addDefaultOreDictionaryRecipe("oreIron", "dustIron", ingotIron, TEItems.ingotNickel);
        SmelterManager.addDefaultOreDictionaryRecipe("oreGold", "dustGold", ingotGold, null, 10, 75, 25);
        SmelterManager.addDefaultOreDictionaryRecipe("oreCopper", "dustCopper", TEItems.ingotCopper, ingotGold);
        SmelterManager.addDefaultOreDictionaryRecipe("oreTin", "dustTin", TEItems.ingotTin, ingotIron);
        SmelterManager.addDefaultOreDictionaryRecipe("oreSilver", "dustSilver", TEItems.ingotSilver, TEItems.ingotLead);
        SmelterManager.addDefaultOreDictionaryRecipe("oreLead", "dustLead", TEItems.ingotLead, TEItems.ingotSilver);
        SmelterManager.addDefaultOreDictionaryRecipe("oreNickel", "dustNickel", TEItems.ingotNickel, TEItems.ingotPlatinum, 15, 75, 25);
        SmelterManager.addDefaultOreDictionaryRecipe("orePlatinum", "dustPlatinum", TEItems.ingotPlatinum);
        SmelterManager.addDefaultOreDictionaryRecipe(null, "dustElectrum", TEItems.ingotElectrum);
        SmelterManager.addDefaultOreDictionaryRecipe(null, "dustInvar", TEItems.ingotInvar);
        SmelterManager.addDefaultOreDictionaryRecipe(null, "dustBronze", TEItems.ingotBronze);
        ItemStack stackElectrum = ItemHelper.cloneStack((ItemStack)TEItems.ingotElectrum, (int)2);
        ItemStack stackInvar = ItemHelper.cloneStack((ItemStack)TEItems.ingotInvar, (int)3);
        ItemStack stackBronze = ItemHelper.cloneStack((ItemStack)TEItems.ingotBronze, (int)4);
        SmelterManager.addAlloyRecipe(1600, "dustSilver", 1, "dustGold", 1, stackElectrum);
        SmelterManager.addAlloyRecipe(2400, "ingotSilver", 1, "ingotGold", 1, stackElectrum);
        SmelterManager.addAlloyRecipe(1600, "dustNickel", 1, "dustIron", 2, stackInvar);
        SmelterManager.addAlloyRecipe(2400, "ingotNickel", 1, "ingotIron", 2, stackInvar);
        SmelterManager.addAlloyRecipe(1600, "dustTin", 1, "dustCopper", 3, stackBronze);
        SmelterManager.addAlloyRecipe(2400, "ingotTin", 1, "ingotCopper", 3, stackBronze);
        if (ItemHelper.oreNameExists((String)"ingotSteel") && steelRecipe) {
            SmelterManager.addAlloyRecipe(8000, "dustCoal", 2, "dustSteel", 1, ItemHelper.cloneStack((ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotSteel").get(0)), (int)1));
            SmelterManager.addAlloyRecipe(8000, "dustCoal", 2, "dustIron", 1, ItemHelper.cloneStack((ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotSteel").get(0)), (int)1));
            SmelterManager.addAlloyRecipe(8000, "dustCoal", 2, "ingotIron", 1, ItemHelper.cloneStack((ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotSteel").get(0)), (int)1));
            SmelterManager.addAlloyRecipe(8000, "charcoal", 4, "dustSteel", 1, ItemHelper.cloneStack((ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotSteel").get(0)), (int)1));
            SmelterManager.addAlloyRecipe(8000, "charcoal", 4, "dustIron", 1, ItemHelper.cloneStack((ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotSteel").get(0)), (int)1));
            SmelterManager.addAlloyRecipe(8000, "charcoal", 4, "ingotIron", 1, ItemHelper.cloneStack((ItemStack)((ItemStack)OreDictionary.getOres((String)"ingotSteel").get(0)), (int)1));
        }
        String[] oreNameList = OreDictionary.getOreNames();
        String oreName = "";
        for (i = 0; i < oreNameList.length; ++i) {
            if (oreNameList[i].startsWith("ore")) {
                oreName = oreNameList[i].substring(3, oreNameList[i].length());
                if (!SmelterManager.isStandardOre(oreNameList[i])) continue;
                SmelterManager.addDefaultOreDictionaryRecipe(oreName);
                continue;
            }
            if (!oreNameList[i].startsWith("dust")) continue;
            oreName = oreNameList[i].substring(4, oreNameList[i].length());
            if (!SmelterManager.isStandardOre(oreNameList[i])) continue;
            SmelterManager.addDefaultOreDictionaryRecipe(oreName);
        }
        for (i = 0; i < blastList.size(); ++i) {
            SmelterManager.addBlastOreRecipe(blastList.get(i));
        }
    }

    public static boolean addTERecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance) {
        if (primaryInput == null || secondaryInput == null || energy <= 0) {
            return false;
        }
        RecipeSmelter recipe = new RecipeSmelter(primaryInput, secondaryInput, primaryOutput, secondaryOutput, secondaryChance, energy);
        recipeMap.put(Arrays.asList(new ComparableItemStackSafe(primaryInput), new ComparableItemStackSafe(secondaryInput)), recipe);
        validationSet.add(new ComparableItemStackSafe(primaryInput));
        validationSet.add(new ComparableItemStackSafe(secondaryInput));
        return true;
    }

    public static boolean addRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance, boolean overwrite) {
        if (primaryInput == null || secondaryInput == null || energy <= 0 || !(allowOverwrite & overwrite) && SmelterManager.recipeExists(primaryInput, secondaryInput)) {
            return false;
        }
        RecipeSmelter recipe = new RecipeSmelter(primaryInput, secondaryInput, primaryOutput, secondaryOutput, secondaryChance, energy);
        recipeMap.put(Arrays.asList(new ComparableItemStackSafe(primaryInput), new ComparableItemStackSafe(secondaryInput)), recipe);
        validationSet.add(new ComparableItemStackSafe(primaryInput));
        validationSet.add(new ComparableItemStackSafe(secondaryInput));
        return true;
    }

    public static void addDefaultOreDictionaryRecipe(String oreName, String dustName, ItemStack ingot, ItemStack ingotRelated, int richSlagChance, int slagOreChance, int slagDustChance) {
        if (ingot == null) {
            return;
        }
        ItemStack ingot2 = ItemHelper.cloneStack((ItemStack)ingot, (int)2);
        if (oreName != null) {
            SmelterManager.addOreToIngotRecipe(oreName, ingot2, ItemHelper.cloneStack((ItemStack)ingot, (int)3), ItemHelper.cloneStack((ItemStack)ingotRelated, (int)1), richSlagChance, slagOreChance);
        }
        if (dustName != null) {
            SmelterManager.addDustToIngotRecipe(dustName, ingot2, slagDustChance);
        }
    }

    public static void addDefaultOreDictionaryRecipe(String oreType) {
        SmelterManager.addDefaultOreDictionaryRecipe(oreType, "");
    }

    public static void addDefaultOreDictionaryRecipe(String oreType, String relatedType) {
        String oreName = "ore" + StringHelper.titleCase((String)oreType);
        String dustName = "dust" + StringHelper.titleCase((String)oreType);
        String ingotName = "ingot" + StringHelper.titleCase((String)oreType);
        ArrayList registeredOre = OreDictionary.getOres((String)oreName);
        ArrayList registeredDust = OreDictionary.getOres((String)dustName);
        ArrayList registeredIngot = OreDictionary.getOres((String)ingotName);
        ArrayList registeredRelated = new ArrayList();
        if (relatedType != "") {
            String relatedName = "ingot" + StringHelper.titleCase((String)relatedType);
            registeredRelated = OreDictionary.getOres((String)relatedName);
        }
        if (registeredIngot.isEmpty()) {
            return;
        }
        if (registeredOre.isEmpty()) {
            oreName = null;
        }
        if (registeredDust.isEmpty()) {
            dustName = null;
        }
        if (!registeredRelated.isEmpty() && registeredRelated.get(0) != null) {
            SmelterManager.addDefaultOreDictionaryRecipe(oreName, dustName, (ItemStack)registeredIngot.get(0), (ItemStack)registeredRelated.get(0), 5, 75, 25);
        } else {
            SmelterManager.addDefaultOreDictionaryRecipe(oreName, dustName, (ItemStack)registeredIngot.get(0), null, 5, 75, 25);
        }
    }

    public static void addDefaultOreDictionaryRecipe(String oreName, String dustName, ItemStack ingot) {
        SmelterManager.addDefaultOreDictionaryRecipe(oreName, dustName, ingot, null, 5, 75, 25);
    }

    public static void addDefaultOreDictionaryRecipe(String oreName, String dustName, ItemStack ingot, ItemStack ingotRelated) {
        SmelterManager.addDefaultOreDictionaryRecipe(oreName, dustName, ingot, ingotRelated, 5, 75, 25);
    }

    public static void addOreToIngotRecipe(String oreName, ItemStack ingot2, ItemStack ingot3, ItemStack ingotSecondary, int richSlagChance, int slagOreChance) {
        ArrayList registeredOres = OreDictionary.getOres((String)oreName);
        if (registeredOres.size() > 0) {
            ItemStack ore = (ItemStack)registeredOres.get(0);
            SmelterManager.addRecipe(3200, ore, blockSand, ingot2, TEItems.slagRich, richSlagChance);
            SmelterManager.addRecipe(4000, ore, TEItems.slagRich, ingot3, TEItems.slag, slagOreChance);
            SmelterManager.addRecipe(4000, ore, TEItems.dustPyrotheum, ingot2, TEItems.slagRich, Math.min(60, richSlagChance * 3));
            if (ingotSecondary != null) {
                SmelterManager.addRecipe(4000, ore, TEItems.crystalCinnabar, ingot3, ingotSecondary, 100);
            } else {
                SmelterManager.addRecipe(4000, ore, TEItems.crystalCinnabar, ingot3, TEItems.slagRich, 75);
            }
        }
    }

    public static void addDustToIngotRecipe(String dustName, ItemStack ingot2, int slagDustChance) {
        ArrayList registeredOres = OreDictionary.getOres((String)dustName);
        if (registeredOres.size() > 0) {
            SmelterManager.addRecipe(800, ItemHelper.cloneStack((ItemStack)((ItemStack)registeredOres.get(0)), (int)2), blockSand, ingot2, TEItems.slag, slagDustChance);
        }
    }

    public static void addAlloyRecipe(int energy, String primaryOreName, int primaryAmount, String secondaryOreName, int secondaryAmount, ItemStack primaryOutput) {
        ArrayList primaryOreList = OreDictionary.getOres((String)primaryOreName);
        ArrayList secondaryOreList = OreDictionary.getOres((String)secondaryOreName);
        if (primaryOreList.size() > 0 && secondaryOreList.size() > 0) {
            SmelterManager.addAlloyRecipe(energy, ItemHelper.cloneStack((ItemStack)((ItemStack)primaryOreList.get(0)), (int)primaryAmount), ItemHelper.cloneStack((ItemStack)((ItemStack)secondaryOreList.get(0)), (int)secondaryAmount), primaryOutput);
        }
    }

    public static void addAlloyRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput) {
        SmelterManager.addTERecipe(energy, primaryInput, secondaryInput, primaryOutput, null, 0);
    }

    public static void addBlastOreRecipe(String oreType) {
        String oreName = "ore" + StringHelper.titleCase((String)oreType);
        String dustName = "dust" + StringHelper.titleCase((String)oreType);
        String ingotName = "ingot" + StringHelper.titleCase((String)oreType);
        ArrayList registeredOre = OreDictionary.getOres((String)oreName);
        ArrayList registeredDust = OreDictionary.getOres((String)dustName);
        ArrayList registeredIngot = OreDictionary.getOres((String)ingotName);
        if (registeredIngot.isEmpty()) {
            return;
        }
        if (!registeredOre.isEmpty()) {
            SmelterManager.addRecipe(12000, ItemHelper.cloneStack((ItemStack)((ItemStack)registeredOre.get(0)), (int)1), TEItems.dustPyrotheum, ItemHelper.cloneStack((ItemStack)((ItemStack)registeredIngot.get(0)), (int)2));
        }
        if (!registeredDust.isEmpty()) {
            SmelterManager.addRecipe(8000, ItemHelper.cloneStack((ItemStack)((ItemStack)registeredDust.get(0)), (int)2), TEItems.dustPyrotheum, ItemHelper.cloneStack((ItemStack)((ItemStack)registeredIngot.get(0)), (int)2));
        }
    }

    public static void addBlastOreName(String oreName) {
        blastList.add(StringHelper.camelCase((String)oreName));
    }

    public static boolean addRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput) {
        return SmelterManager.addRecipe(energy, primaryInput, secondaryInput, primaryOutput, false);
    }

    public static boolean addRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput, boolean overwrite) {
        return SmelterManager.addRecipe(energy, primaryInput, secondaryInput, primaryOutput, null, 0, overwrite);
    }

    public static boolean addRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput, ItemStack secondaryOutput) {
        return SmelterManager.addRecipe(energy, primaryInput, secondaryInput, primaryOutput, secondaryOutput, false);
    }

    public static boolean addRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput, ItemStack secondaryOutput, boolean overwrite) {
        return SmelterManager.addRecipe(energy, primaryInput, secondaryInput, primaryOutput, secondaryOutput, 100, overwrite);
    }

    public static boolean addRecipe(int energy, ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance) {
        return SmelterManager.addRecipe(energy, primaryInput, secondaryInput, primaryOutput, secondaryOutput, secondaryChance, false);
    }

    static {
        allowOverwrite = ThermalExpansion.config.get("tweak.crafting", "Smelter.AllowRecipeOverwrite", false);
        blastList.add("enderium");
        blastList.add("aluminum");
        blastList.add("ardite");
        blastList.add("cobalt");
    }

    public static class RecipeSmelter {
        final ItemStack primaryInput;
        final ItemStack secondaryInput;
        final ItemStack primaryOutput;
        final ItemStack secondaryOutput;
        final int secondaryChance;
        final int energy;

        RecipeSmelter(ItemStack primaryInput, ItemStack secondaryInput, ItemStack primaryOutput, ItemStack secondaryOutput, int secondaryChance, int energy) {
            this.primaryInput = primaryInput;
            this.secondaryInput = secondaryInput;
            this.primaryOutput = primaryOutput;
            this.secondaryOutput = secondaryOutput;
            this.secondaryChance = secondaryChance;
            this.energy = energy;
        }

        public ItemStack getPrimaryInput() {
            return this.primaryInput.func_77946_l();
        }

        public ItemStack getSecondaryInput() {
            return this.secondaryInput.func_77946_l();
        }

        public ItemStack getPrimaryOutput() {
            return this.primaryOutput.func_77946_l();
        }

        public ItemStack getSecondaryOutput() {
            if (this.secondaryOutput == null) {
                return null;
            }
            return this.secondaryOutput.func_77946_l();
        }

        public int getSecondaryOutputChance() {
            return this.secondaryChance;
        }

        public int getEnergy() {
            return this.energy;
        }
    }
}

