/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.plugins.nei.handlers;

import codechicken.core.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import java.awt.Point;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import thermalexpansion.gui.client.machine.GuiCrucible;
import thermalexpansion.plugins.nei.handlers.RecipeHandlerBase;
import thermalexpansion.util.crafting.CrucibleManager;

public class RecipeHandlerCrucible
extends RecipeHandlerBase {
    public static RecipeHandlerCrucible instance = new RecipeHandlerCrucible();

    public RecipeHandlerCrucible() {
        this.maxEnergy = 400000;
    }

    @Override
    public void initialize() {
        this.trCoords = new int[]{98, 23, 24, 18};
        this.recipeName = "crucible";
        this.containerClass = GuiCrucible.class;
    }

    @Override
    public void drawBackgroundExtras(int recipe) {
        GuiDraw.drawTexturedModalRect((int)50, (int)17, (int)176, (int)96, (int)18, (int)18);
        GuiDraw.drawTexturedModalRect((int)51, (int)36, (int)224, (int)32, (int)16, (int)16);
        this.drawProgressBar(51, 36, 240, 32, 16, 16, 100, 7);
        this.drawFluid(recipe, true);
        GuiDraw.drawTexturedModalRect((int)98, (int)24, (int)176, (int)48, (int)24, (int)16);
        this.drawFluidRect(98, 24, ((RecipeHandlerBase.NEIRecipeBase)((Object)this.arecipes.get((int)recipe))).fluid, (int)((float)(this.cycleticks % 20) / 20.0f * 24.0f), 16);
        this.drawProgressBar(98, 24, 200, 48, 24, 16, 20, 0);
    }

    public void drawExtras(int recipe) {
        this.drawEnergy(recipe);
        int energy = ((RecipeHandlerBase.NEIRecipeBase)((Object)this.arecipes.get((int)recipe))).energy;
        if (energy < 1000) {
            GuiDraw.drawString((String)(energy + "RF"), (int)56, (int)54, (int)0x939393, (boolean)false);
        } else if (energy < 10000) {
            GuiDraw.drawString((String)(energy + "RF"), (int)50, (int)54, (int)0x939393, (boolean)false);
        } else if (energy < 100000) {
            GuiDraw.drawString((String)(energy + "RF"), (int)44, (int)54, (int)0x939393, (boolean)false);
        } else {
            GuiDraw.drawString((String)(energy + "RF"), (int)38, (int)54, (int)0x939393, (boolean)false);
        }
        int fluid = ((RecipeHandlerBase.NEIRecipeBase)((Object)this.arecipes.get((int)recipe))).fluid.amount;
        if (fluid < 100) {
            GuiDraw.drawString((String)(fluid + "mB"), (int)120, (int)54, (int)0x939393, (boolean)false);
        } else if (fluid < 1000) {
            GuiDraw.drawString((String)(fluid + "mB"), (int)114, (int)54, (int)0x939393, (boolean)false);
        } else if (fluid < 10000) {
            GuiDraw.drawString((String)(fluid + "mB"), (int)108, (int)54, (int)0x939393, (boolean)false);
        }
    }

    public List<String> handleTooltip(GuiRecipe gui, List<String> currenttip, int recipe) {
        int minX1 = 153;
        int maxX1 = 169;
        int minY1 = 19;
        int maxY1 = 79;
        int yOffset = 65;
        Point mousepos = GuiDraw.getMousePosition();
        if (mousepos.x >= minX1 + gui.field_74198_m && mousepos.x < maxX1 + gui.field_74198_m && mousepos.y >= minY1 + gui.field_74197_n && mousepos.y < maxY1 + gui.field_74197_n && this.arecipe[0] == recipe) {
            currenttip.add(((RecipeHandlerBase.NEIRecipeBase)((Object)this.arecipes.get((int)recipe))).fluid.getFluid().getLocalizedName());
        } else if (mousepos.x >= minX1 + gui.field_74198_m && mousepos.x < maxX1 + gui.field_74198_m && mousepos.y >= minY1 + gui.field_74197_n + yOffset && mousepos.y < maxY1 + gui.field_74197_n + yOffset && this.arecipe[1] == recipe) {
            currenttip.add(((RecipeHandlerBase.NEIRecipeBase)((Object)this.arecipes.get((int)recipe))).fluid.getFluid().getLocalizedName());
        }
        return super.handleTooltip(gui, currenttip, recipe);
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getOverlayIdentifier())) {
            CrucibleManager.RecipeCrucible[] recipes;
            for (CrucibleManager.RecipeCrucible recipe : recipes = CrucibleManager.getRecipeList()) {
                this.arecipes.add(new NEIRecipeCrucible(recipe));
            }
        } else if (outputId.equals("liquid") && results.length == 1 && results[0] instanceof FluidStack) {
            CrucibleManager.RecipeCrucible[] recipes;
            for (CrucibleManager.RecipeCrucible recipe : recipes = CrucibleManager.getRecipeList()) {
                if (!recipe.getOutput().isFluidEqual((FluidStack)results[0])) continue;
                this.arecipes.add(new NEIRecipeCrucible(recipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        CrucibleManager.RecipeCrucible[] recipes;
        for (CrucibleManager.RecipeCrucible recipe : recipes = CrucibleManager.getRecipeList()) {
            if (!recipe.getOutput().isFluidEqual(result)) continue;
            this.arecipes.add(new NEIRecipeCrucible(recipe));
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("fuel") && ((Object)((Object)this)).getClass() == RecipeHandlerCrucible.class) {
            this.loadCraftingRecipes(this.getOverlayIdentifier(), new Object[0]);
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        CrucibleManager.RecipeCrucible[] recipes;
        for (CrucibleManager.RecipeCrucible recipe : recipes = CrucibleManager.getRecipeList()) {
            if (!NEIServerUtils.areStacksSameType((ItemStack)recipe.getInput(), (ItemStack)ingredient)) continue;
            this.arecipes.add(new NEIRecipeCrucible(recipe));
        }
    }

    class NEIRecipeCrucible
    extends RecipeHandlerBase.NEIRecipeBase {
        public NEIRecipeCrucible(CrucibleManager.RecipeCrucible recipe) {
            this.input = new PositionedStack((Object)recipe.getInput(), 51, 18);
            this.fluid = recipe.getOutput();
            this.energy = recipe.getEnergy();
            this.setOres();
        }
    }
}

