/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.part.conduit.fluid;

import cofh.util.FluidHelper;
import cofh.util.TimeTracker;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import thermalexpansion.part.conduit.ConduitBase;
import thermalexpansion.part.conduit.Grid;
import thermalexpansion.part.conduit.GridTickHandler;
import thermalexpansion.part.conduit.fluid.ConduitFluid;
import thermalexpansion.part.conduit.fluid.FluidTankGrid;

public class GridFluid
extends Grid {
    public FluidTankGrid myTank = new FluidTankGrid(1000, this);
    public int toDistribute = 0;
    public World worldObj;
    TimeTracker myTracker = new TimeTracker();
    boolean recentRenderUpdate = false;
    int renderFluidLevel = 0;
    FluidStack myRenderFluid;

    public GridFluid(ConduitFluid myNode) {
        this.worldObj = myNode.world();
        this.myTank = new FluidTankGrid(1000, this);
        this.addConduit(myNode);
        GridTickHandler.tickingGridsToAdd.add(this);
    }

    @Override
    public void nodeAdded(ConduitBase theCond) {
        ConduitFluid theCondF = (ConduitFluid)theCond;
        if (theCondF.fluidForGrid != null) {
            if (this.myTank.getFluid() == null) {
                this.myTank.setFluid(theCondF.fluidForGrid);
            } else {
                this.myTank.fill(theCondF.fluidForGrid, true);
            }
            theCondF.fluidForGrid = null;
        }
    }

    @Override
    public void rebalanceGrid() {
        this.myTank.setCapacity(this.nodeSet.size() * this.myTank.fluidPerConduit);
    }

    @Override
    public void destroyNode(ConduitBase theNode) {
        if (this.hasValidFluid()) {
            ((ConduitFluid)theNode).fluidForGrid = this.getNodeShare((ConduitFluid)theNode);
        }
        super.destroyNode(theNode);
    }

    @Override
    public void doGridUpdate() {
        if (this.worldObj.func_82737_E() % 4L == 0L) {
            this.updateAllRenders();
        }
        if (this.myTank.getFluid() != null && this.nodeSet.size() > 0) {
            if (this.worldObj.func_82737_E() % 4L == 0L) {
                this.updateAllRenders();
            }
            if (this.myTank.getFluid() != null && this.nodeSet.size() > 0) {
                this.toDistribute = Math.min(this.myTank.getFluidAmount() / this.nodeSet.size(), this.getFluidThroughput());
                if (this.toDistribute <= 0) {
                    this.toDistribute = Math.min(this.myTank.getFluidAmount() % this.nodeSet.size(), this.getFluidThroughput());
                }
            }
        }
        super.doGridUpdate();
    }

    @Override
    public void mergeGrid(Grid theGrid) {
        super.mergeGrid(theGrid);
        this.myTank.fill(((GridFluid)theGrid).getFluid(), true);
    }

    @Override
    public boolean canGridMerge(Grid theNewGrid) {
        return FluidHelper.isFluidEqualOrNull((FluidStack)((GridFluid)theNewGrid).getFluid(), (FluidStack)this.getFluid());
    }

    public int getFluidThroughput() {
        if (this.myTank.getFluid() == null) {
            return 100;
        }
        int capacity = this.myTank.getCapacity();
        if (this.myTank.getFluid().amount >= capacity * 3 / 4) {
            return this.myTank.fluidThroughput;
        }
        if (this.myTank.getFluid().amount <= capacity / 4) {
            return this.myTank.fluidThroughput >> 1;
        }
        return (this.myTank.fluidThroughput >> 1) + (this.myTank.fluidThroughput >> 1) * (this.myTank.getFluid().amount - (capacity >> 2)) / (capacity >> 1);
    }

    public void fluidChanged() {
        this.rebalanceGrid();
    }

    public FluidStack getNodeShare(ConduitFluid theCond) {
        FluidStack toReturn = this.myTank.getFluid().copy();
        toReturn.amount = this.getNodeAmount(theCond);
        return toReturn;
    }

    public int getNodeAmount(ConduitFluid theCond) {
        return this.nodeSet.size() == 1 ? this.myTank.getFluidAmount() : (this.isFirstConduit(theCond) ? this.myTank.getFluidAmount() / this.nodeSet.size() + this.myTank.getFluidAmount() % this.nodeSet.size() : this.myTank.getFluidAmount() / this.nodeSet.size());
    }

    public FluidStack getFluid() {
        return this.myTank.getFluid();
    }

    public boolean hasValidFluid() {
        return this.myTank.getFluid() != null;
    }

    public void updateAllRenders() {
        int fl = this.renderFluidLevel;
        if (this.updateRender() && fl != this.renderFluidLevel) {
            if (this.myTank.getFluid() != null) {
                this.myRenderFluid = this.myTank.getFluid().copy();
                this.myRenderFluid.amount = this.renderFluidLevel;
            } else {
                this.myRenderFluid = null;
            }
            for (ConduitBase curTile : this.nodeSet) {
                ((ConduitFluid)curTile).updateFluid();
            }
            for (ConduitBase curTile : this.conduitSet) {
                ((ConduitFluid)curTile).updateFluid();
            }
        }
    }

    public boolean updateRender() {
        if (this.recentRenderUpdate && this.myTracker.hasDelayPassed(this.worldObj, 96)) {
            this.recentRenderUpdate = false;
        }
        if (this.myTank.getFluid() != null && this.myTank.getCapacity() > 0) {
            double fullPercent = 10000 * this.myTank.getFluid().amount / this.myTank.getCapacity();
            if (fullPercent >= 0.0) {
                int n = this.renderFluidLevel == 2 ? 500 : 700;
                if (fullPercent <= (double)n) {
                    this.renderFluidLevel = 1;
                    return true;
                }
            }
            if (fullPercent >= 500.0) {
                int n = this.renderFluidLevel == 3 ? 2000 : 2500;
                if (fullPercent <= (double)n) {
                    this.renderFluidLevel = 2;
                    return true;
                }
            }
            if (fullPercent >= 2000.0) {
                int n = this.renderFluidLevel == 4 ? 4000 : 4500;
                if (fullPercent <= (double)n) {
                    this.renderFluidLevel = 3;
                    return true;
                }
            }
            if (fullPercent >= 4000.0) {
                int n = this.renderFluidLevel == 5 ? 6000 : 6500;
                if (fullPercent <= (double)n) {
                    this.renderFluidLevel = 4;
                    return true;
                }
            }
            if (fullPercent >= 6000.0) {
                int n = this.renderFluidLevel == 6 ? 8000 : 8500;
                if (fullPercent <= (double)n) {
                    this.renderFluidLevel = 5;
                    return true;
                }
            }
            this.renderFluidLevel = 6;
            return true;
        }
        if (this.renderFluidLevel != 0 && !this.recentRenderUpdate) {
            this.renderFluidLevel = 0;
            this.recentRenderUpdate = true;
            this.myTracker.markTime(this.worldObj);
            return true;
        }
        return false;
    }

    public FluidStack getRenderFluid() {
        return this.myRenderFluid;
    }

    public static final class FluidRenderType {
        public static final byte EMPTY = 0;
        public static final byte LOW = 1;
        public static final byte LOW_MED = 2;
        public static final byte MEDIUM = 3;
        public static final byte MED_HIGH = 4;
        public static final byte HIGH = 5;
        public static final byte FULL = 6;
    }
}

