/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.fluid;

import cofh.util.ServerHelper;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thermalexpansion.fluid.BlockFluidTEBase;
import thermalexpansion.fluid.TEFluids;

public class BlockFluidGlowstone
extends BlockFluidTEBase {
    public static boolean enableSourceCondense = true;
    public static boolean enableSourceFloat = true;
    public static int maxGlowstoneHeight = 120;

    public BlockFluidGlowstone(int id) {
        super(id, TEFluids.fluidGlowstone, TEFluids.materialFluidGlowstone, "glowstone");
        this.setDensity(-250);
        this.setQuantaPerBlock(6);
        this.setTickRate(20);
        this.func_71848_c(1.0f);
        this.func_71868_h(0);
        this.setParticleColor(1.0f, 0.9f, 0.05f);
    }

    public void func_71869_a(World world, int x, int y, int z, Entity entity) {
        if (!TEFluids.effectGlowstone) {
            return;
        }
        if (entity instanceof EntityLivingBase && entity.field_70181_x < -0.2) {
            entity.field_70181_x *= 0.5;
            entity.field_70143_R = entity.field_70143_R > 20.0f ? 20.0f : (float)((double)entity.field_70143_R * 0.95);
        }
        if (ServerHelper.isClientWorld((World)world)) {
            return;
        }
        if (world.func_82737_E() % 8L == 0L && entity instanceof EntityLivingBase && !((EntityLivingBase)entity).func_70662_br()) {
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76424_c.field_76415_H, 120, 0));
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76430_j.field_76415_H, 120, 0));
        }
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        return TEFluids.fluidGlowstone.getLuminosity();
    }

    public void func_71847_b(World world, int x, int y, int z, Random rand) {
        if (world.func_72805_g(x, y, z) == 0) {
            if (rand.nextInt(3) == 0) {
                if (this.shouldSourceBlockCondense(world, x, y, z)) {
                    world.func_94575_c(x, y, z, Block.field_72014_bd.field_71990_ca);
                    return;
                }
                if (this.shouldSourceBlockFloat(world, x, y, z)) {
                    world.func_72832_d(x, y + this.densityDir, z, this.field_71990_ca, 0, 3);
                    world.func_94571_i(x, y, z);
                    return;
                }
            }
        } else if (y + this.densityDir > maxGlowstoneHeight) {
            int quantaRemaining = this.quantaPerBlock - world.func_72805_g(x, y, z);
            int expQuanta = -101;
            int y2 = y - this.densityDir;
            if (world.func_72798_a(x, y2, z) == this.field_71990_ca || world.func_72798_a(x - 1, y2, z) == this.field_71990_ca || world.func_72798_a(x + 1, y2, z) == this.field_71990_ca || world.func_72798_a(x, y2, z - 1) == this.field_71990_ca || world.func_72798_a(x, y2, z + 1) == this.field_71990_ca) {
                expQuanta = this.quantaPerBlock - 1;
            } else {
                int maxQuanta = -100;
                maxQuanta = this.getLargerQuanta((IBlockAccess)world, x - 1, y, z, maxQuanta);
                maxQuanta = this.getLargerQuanta((IBlockAccess)world, x + 1, y, z, maxQuanta);
                maxQuanta = this.getLargerQuanta((IBlockAccess)world, x, y, z - 1, maxQuanta);
                maxQuanta = this.getLargerQuanta((IBlockAccess)world, x, y, z + 1, maxQuanta);
                expQuanta = maxQuanta - 1;
            }
            if (expQuanta != quantaRemaining) {
                quantaRemaining = expQuanta;
                if (expQuanta <= 0) {
                    world.func_94571_i(x, y, z);
                } else {
                    world.func_72921_c(x, y, z, this.quantaPerBlock - expQuanta, 3);
                    world.func_72836_a(x, y, z, this.field_71990_ca, this.tickRate);
                    world.func_72898_h(x, y, z, this.field_71990_ca);
                }
            }
            return;
        }
        super.func_71847_b(world, x, y, z, rand);
    }

    protected boolean shouldSourceBlockCondense(World world, int x, int y, int z) {
        return enableSourceCondense && (y + this.densityDir > maxGlowstoneHeight || y + this.densityDir > world.func_72800_K() || (float)(y + this.densityDir) > (float)maxGlowstoneHeight * 0.8f && !this.canDisplace((IBlockAccess)world, x, y + this.densityDir, z));
    }

    protected boolean shouldSourceBlockFloat(World world, int x, int y, int z) {
        return enableSourceFloat && world.func_72798_a(x, y + this.densityDir, z) == this.field_71990_ca && world.func_72805_g(x, y + this.densityDir, z) != 0;
    }
}

