/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.machine;

import cofh.api.tileentity.ISidedBlockTexture;
import cofh.render.IconRegistry;
import cofh.util.FluidHelper;
import cofh.util.ItemHelper;
import cofh.util.StringHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.oredict.ShapedOreRecipe;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.BlockTEBase;
import thermalexpansion.block.energycell.BlockEnergyCell;
import thermalexpansion.block.machine.TileAssembler;
import thermalexpansion.block.machine.TileCharger;
import thermalexpansion.block.machine.TileCrucible;
import thermalexpansion.block.machine.TileFurnace;
import thermalexpansion.block.machine.TileIceGen;
import thermalexpansion.block.machine.TilePulverizer;
import thermalexpansion.block.machine.TileRockGen;
import thermalexpansion.block.machine.TileSawmill;
import thermalexpansion.block.machine.TileSmelter;
import thermalexpansion.block.machine.TileTransposer;
import thermalexpansion.block.machine.TileWaterGen;
import thermalexpansion.item.TEItems;

public class BlockMachine
extends BlockTEBase {
    public static final String[] NAMES = new String[]{"furnace", "pulverizer", "sawmill", "smelter", "crucible", "transposer", "iceGen", "rockGen", "waterGen", "assembler", "charger"};
    public static boolean[] enable = new boolean[Types.values().length];
    public static ItemStack furnace;
    public static ItemStack pulverizer;
    public static ItemStack sawmill;
    public static ItemStack smelter;
    public static ItemStack crucible;
    public static ItemStack transposer;
    public static ItemStack iceGen;
    public static ItemStack rockGen;
    public static ItemStack waterGen;
    public static ItemStack assembler;
    public static ItemStack charger;
    public static ItemStack machineFrame;

    public BlockMachine(int id) {
        super(id, Material.field_76243_f);
        this.func_71848_c(15.0f);
        this.func_71894_b(25.0f);
        this.func_71864_b("thermalexpansion.machine");
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (metadata >= Types.values().length) {
            return null;
        }
        switch (Types.values()[metadata]) {
            case FURNACE: {
                return new TileFurnace();
            }
            case PULVERIZER: {
                return new TilePulverizer();
            }
            case SAWMILL: {
                return new TileSawmill();
            }
            case SMELTER: {
                return new TileSmelter();
            }
            case CRUCIBLE: {
                return new TileCrucible();
            }
            case TRANSPOSER: {
                return new TileTransposer();
            }
            case ICE_GEN: {
                return new TileIceGen();
            }
            case ROCK_GEN: {
                return new TileRockGen();
            }
            case WATER_GEN: {
                return new TileWaterGen();
            }
            case ASSEMBLER: {
                return new TileAssembler();
            }
            case CHARGER: {
                return new TileCharger();
            }
        }
        return null;
    }

    public void func_71879_a(int itemId, CreativeTabs tab, List list) {
        for (int i = 0; i < Types.values().length; ++i) {
            if (!enable[i]) continue;
            list.add(new ItemStack(itemId, 1, i));
        }
    }

    @Override
    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int hitSide, float hitX, float hitY, float hitZ) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if ((tile instanceof TileRockGen || tile instanceof TileIceGen) && FluidHelper.fillHandlerWithContainer((World)world, (IFluidHandler)((IFluidHandler)tile), (EntityPlayer)player)) {
            return true;
        }
        return super.func_71903_a(world, x, y, z, player, hitSide, hitX, hitY, hitZ);
    }

    public boolean isBlockNormalCube(World world, int x, int y, int z) {
        return false;
    }

    public boolean isBlockSolidOnSide(World world, int x, int y, int z, ForgeDirection side) {
        return true;
    }

    public Icon func_71895_b(IBlockAccess world, int x, int y, int z, int side) {
        ISidedBlockTexture tile = (ISidedBlockTexture)world.func_72796_p(x, y, z);
        return tile == null ? null : tile.getBlockTexture(side, renderPass);
    }

    @Override
    public Icon func_71858_a(int side, int metadata) {
        if (side == 0) {
            return IconRegistry.getIcon((String)"MachineBottom");
        }
        if (side == 1) {
            return IconRegistry.getIcon((String)"MachineTop");
        }
        return side != 3 ? IconRegistry.getIcon((String)"MachineSide") : IconRegistry.getIcon((String)("MachineFace_" + metadata));
    }

    public boolean canRenderInPass(int pass) {
        renderPass = pass;
        return pass < 2;
    }

    public int func_71856_s_() {
        return 1;
    }

    public boolean func_71926_d() {
        return true;
    }

    public boolean func_71886_c() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister ir) {
        IconRegistry.addIcon((String)"MachineBottom", (String)"thermalexpansion:machine/Machine_Bottom", (IconRegister)ir);
        IconRegistry.addIcon((String)"MachineTop", (String)"thermalexpansion:machine/Machine_Top", (IconRegister)ir);
        IconRegistry.addIcon((String)"MachineSide", (String)"thermalexpansion:machine/Machine_Side", (IconRegister)ir);
        for (int i = 0; i < Types.values().length; ++i) {
            IconRegistry.addIcon((String)("MachineFace_" + i), (String)("thermalexpansion:machine/Machine_Face_" + StringHelper.titleCase((String)NAMES[i])), (IconRegister)ir);
            IconRegistry.addIcon((String)("MachineActive_" + i), (String)("thermalexpansion:machine/Machine_Active_" + StringHelper.titleCase((String)NAMES[i])), (IconRegister)ir);
        }
        IconRegistry.addIcon((String)"Config_0", (String)"thermalexpansion:config/Config_None", (IconRegister)ir);
        IconRegistry.addIcon((String)"Config_1", (String)"thermalexpansion:config/Config_Blue", (IconRegister)ir);
        IconRegistry.addIcon((String)"Config_2", (String)"thermalexpansion:config/Config_Red", (IconRegister)ir);
        IconRegistry.addIcon((String)"Config_3", (String)"thermalexpansion:config/Config_Yellow", (IconRegister)ir);
        IconRegistry.addIcon((String)"Config_4", (String)"thermalexpansion:config/Config_Orange", (IconRegister)ir);
        IconRegistry.addIcon((String)"Config_5", (String)"thermalexpansion:config/Config_Green", (IconRegister)ir);
        IconRegistry.addIcon((String)"Config_6", (String)"thermalexpansion:config/Config_Purple", (IconRegister)ir);
        IconRegistry.addIcon((String)"Config_CB_0", (String)"thermalexpansion:config/Config_None", (IconRegister)ir);
        IconRegistry.addIcon((String)"Config_CB_1", (String)"thermalexpansion:config/Config_Blue_CB", (IconRegister)ir);
        IconRegistry.addIcon((String)"Config_CB_2", (String)"thermalexpansion:config/Config_Red_CB", (IconRegister)ir);
        IconRegistry.addIcon((String)"Config_CB_3", (String)"thermalexpansion:config/Config_Yellow_CB", (IconRegister)ir);
        IconRegistry.addIcon((String)"Config_CB_4", (String)"thermalexpansion:config/Config_Orange_CB", (IconRegister)ir);
        IconRegistry.addIcon((String)"Config_CB_5", (String)"thermalexpansion:config/Config_Green_CB", (IconRegister)ir);
        IconRegistry.addIcon((String)"Config_CB_6", (String)"thermalexpansion:config/Config_Purple_CB", (IconRegister)ir);
    }

    public boolean initialize() {
        machineFrame = TEItems.itemComponent.addItem(0, "machineFrame");
        TileFurnace.initialize();
        TilePulverizer.initialize();
        TileSawmill.initialize();
        TileSmelter.initialize();
        TileCrucible.initialize();
        TileTransposer.initialize();
        TileIceGen.initialize();
        TileRockGen.initialize();
        TileWaterGen.initialize();
        TileAssembler.initialize();
        TileCharger.initialize();
        furnace = new ItemStack((Block)this, 1, Types.FURNACE.ordinal());
        pulverizer = new ItemStack((Block)this, 1, Types.PULVERIZER.ordinal());
        sawmill = new ItemStack((Block)this, 1, Types.SAWMILL.ordinal());
        smelter = new ItemStack((Block)this, 1, Types.SMELTER.ordinal());
        crucible = new ItemStack((Block)this, 1, Types.CRUCIBLE.ordinal());
        transposer = new ItemStack((Block)this, 1, Types.TRANSPOSER.ordinal());
        iceGen = new ItemStack((Block)this, 1, Types.ICE_GEN.ordinal());
        rockGen = new ItemStack((Block)this, 1, Types.ROCK_GEN.ordinal());
        waterGen = new ItemStack((Block)this, 1, Types.WATER_GEN.ordinal());
        assembler = new ItemStack((Block)this, 1, Types.ASSEMBLER.ordinal());
        charger = new ItemStack((Block)this, 1, Types.CHARGER.ordinal());
        GameRegistry.registerCustomItemStack((String)"furnace", (ItemStack)furnace);
        GameRegistry.registerCustomItemStack((String)"pulverizer", (ItemStack)pulverizer);
        GameRegistry.registerCustomItemStack((String)"sawmill", (ItemStack)sawmill);
        GameRegistry.registerCustomItemStack((String)"smelter", (ItemStack)smelter);
        GameRegistry.registerCustomItemStack((String)"crucible", (ItemStack)crucible);
        GameRegistry.registerCustomItemStack((String)"transposer", (ItemStack)transposer);
        GameRegistry.registerCustomItemStack((String)"iceGen", (ItemStack)iceGen);
        GameRegistry.registerCustomItemStack((String)"rockGen", (ItemStack)rockGen);
        GameRegistry.registerCustomItemStack((String)"waterGen", (ItemStack)waterGen);
        GameRegistry.registerCustomItemStack((String)"assembler", (ItemStack)assembler);
        GameRegistry.registerCustomItemStack((String)"charger", (ItemStack)charger);
        return true;
    }

    public boolean postInit() {
        String category = "tweak.recipe";
        boolean machineFrameRequireSteel = ThermalExpansion.config.get(category, "MachineFrame.RequireSteel", false);
        boolean machineFrameAllowSteel = ThermalExpansion.config.get(category, "MachineFrame.AllowSteel", true);
        boolean machinesUseGears = ThermalExpansion.config.get(category, "UseGears", false);
        boolean[] expensiveRecipe = new boolean[Types.values().length];
        expensiveRecipe[Types.PULVERIZER.ordinal()] = ThermalExpansion.config.get(category, "Pulverizer.AddDiamonds", false);
        expensiveRecipe[Types.SMELTER.ordinal()] = ThermalExpansion.config.get(category, "Smelter.AddDiamonds", false);
        String copperPart = "ingotCopper";
        String tinPart = "ingotTin";
        if (machinesUseGears) {
            copperPart = "gearCopper";
            tinPart = "gearTin";
        }
        if (ItemHelper.oreNameExists((String)"ingotSteel")) {
            if (machineFrameRequireSteel) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(machineFrame, new Object[]{"IGI", "GXG", "IGI", Character.valueOf('I'), "ingotSteel", Character.valueOf('G'), "glass", Character.valueOf('X'), "ingotGold"}));
            } else if (machineFrameAllowSteel) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(machineFrame, new Object[]{"IGI", "GXG", "IGI", Character.valueOf('I'), "ingotSteel", Character.valueOf('G'), "glass", Character.valueOf('X'), "ingotGold"}));
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(machineFrame, new Object[]{"IGI", "GXG", "IGI", Character.valueOf('I'), "ingotIron", Character.valueOf('G'), "glass", Character.valueOf('X'), "ingotGold"}));
            } else {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(machineFrame, new Object[]{"IGI", "GXG", "IGI", Character.valueOf('I'), "ingotIron", Character.valueOf('G'), "glass", Character.valueOf('X'), "ingotGold"}));
            }
        } else {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(machineFrame, new Object[]{"IGI", "GXG", "IGI", Character.valueOf('I'), "ingotIron", Character.valueOf('G'), "glass", Character.valueOf('X'), "ingotGold"}));
        }
        if (enable[Types.FURNACE.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(furnace, new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), machineFrame, Character.valueOf('I'), copperPart, Character.valueOf('P'), TEItems.powerCoilGold, Character.valueOf('X'), Item.field_77767_aC, Character.valueOf('Y'), Block.field_72081_al}));
        }
        if (enable[Types.PULVERIZER.ordinal()]) {
            if (expensiveRecipe[Types.PULVERIZER.ordinal()]) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(pulverizer, new Object[]{"DXD", "YCY", "IPI", Character.valueOf('C'), machineFrame, Character.valueOf('I'), copperPart, Character.valueOf('P'), TEItems.powerCoilGold, Character.valueOf('X'), Block.field_71963_Z, Character.valueOf('Y'), Item.field_77804_ap, Character.valueOf('D'), Item.field_77702_n}));
            } else {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(pulverizer, new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), machineFrame, Character.valueOf('I'), copperPart, Character.valueOf('P'), TEItems.powerCoilGold, Character.valueOf('X'), Block.field_71963_Z, Character.valueOf('Y'), Item.field_77804_ap}));
            }
        }
        if (enable[Types.SAWMILL.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(sawmill, new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), machineFrame, Character.valueOf('I'), copperPart, Character.valueOf('P'), TEItems.powerCoilGold, Character.valueOf('X'), Item.field_77708_h, Character.valueOf('Y'), "plankWood"}));
        }
        if (enable[Types.SMELTER.ordinal()]) {
            if (expensiveRecipe[Types.SMELTER.ordinal()]) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(smelter, new Object[]{"DXD", "YCY", "IPI", Character.valueOf('C'), machineFrame, Character.valueOf('I'), copperPart, Character.valueOf('P'), TEItems.powerCoilGold, Character.valueOf('X'), Item.field_77788_aw, Character.valueOf('Y'), "ingotInvar", Character.valueOf('D'), Item.field_77702_n}));
            } else {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(smelter, new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), machineFrame, Character.valueOf('I'), copperPart, Character.valueOf('P'), TEItems.powerCoilGold, Character.valueOf('X'), Item.field_77788_aw, Character.valueOf('Y'), "ingotInvar"}));
            }
        }
        if (enable[Types.CRUCIBLE.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(crucible, new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), machineFrame, Character.valueOf('I'), copperPart, Character.valueOf('P'), TEItems.powerCoilGold, Character.valueOf('X'), BlockEnergyCell.cellBasicFrame, Character.valueOf('Y'), Block.field_72033_bA}));
        }
        if (enable[Types.TRANSPOSER.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(transposer, new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), machineFrame, Character.valueOf('I'), copperPart, Character.valueOf('P'), TEItems.powerCoilGold, Character.valueOf('X'), Item.field_77788_aw, Character.valueOf('Y'), "glass"}));
        }
        if (enable[Types.ICE_GEN.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(iceGen, new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), machineFrame, Character.valueOf('I'), copperPart, Character.valueOf('P'), TEItems.powerCoilGold, Character.valueOf('X'), Block.field_71963_Z, Character.valueOf('Y'), Block.field_72039_aU}));
        }
        if (enable[Types.ROCK_GEN.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(rockGen, new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), machineFrame, Character.valueOf('I'), tinPart, Character.valueOf('P'), TEItems.pneumaticServo, Character.valueOf('X'), Block.field_71963_Z, Character.valueOf('Y'), "glass"}));
        }
        if (enable[Types.WATER_GEN.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(waterGen, new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), machineFrame, Character.valueOf('I'), tinPart, Character.valueOf('P'), TEItems.pneumaticServo, Character.valueOf('X'), Item.field_77788_aw, Character.valueOf('Y'), "glass"}));
        }
        if (enable[Types.ASSEMBLER.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(assembler, new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), machineFrame, Character.valueOf('I'), copperPart, Character.valueOf('P'), TEItems.powerCoilGold, Character.valueOf('X'), Block.field_72077_au, Character.valueOf('Y'), "gearTin"}));
        }
        if (enable[Types.CHARGER.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(charger, new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), machineFrame, Character.valueOf('I'), copperPart, Character.valueOf('P'), TEItems.powerCoilGold, Character.valueOf('X'), BlockEnergyCell.cellBasicFrame, Character.valueOf('Y'), TEItems.powerCoilSilver}));
        }
        return true;
    }

    static {
        String category = "block.feature";
        BlockMachine.enable[Types.FURNACE.ordinal()] = ThermalExpansion.config.get(category, "Machine.Furnace", true);
        BlockMachine.enable[Types.PULVERIZER.ordinal()] = ThermalExpansion.config.get(category, "Machine.Pulverizer", true);
        BlockMachine.enable[Types.SAWMILL.ordinal()] = ThermalExpansion.config.get(category, "Machine.Sawmill", true);
        BlockMachine.enable[Types.SMELTER.ordinal()] = ThermalExpansion.config.get(category, "Machine.Smelter", true);
        BlockMachine.enable[Types.CRUCIBLE.ordinal()] = ThermalExpansion.config.get(category, "Machine.Crucible", true);
        BlockMachine.enable[Types.TRANSPOSER.ordinal()] = ThermalExpansion.config.get(category, "Machine.Transposer", true);
        BlockMachine.enable[Types.ICE_GEN.ordinal()] = ThermalExpansion.config.get(category, "Machine.IceGen", true);
        BlockMachine.enable[Types.ROCK_GEN.ordinal()] = ThermalExpansion.config.get(category, "Machine.RockGen", true);
        BlockMachine.enable[Types.WATER_GEN.ordinal()] = ThermalExpansion.config.get(category, "Machine.WaterGen", true);
        BlockMachine.enable[Types.ASSEMBLER.ordinal()] = ThermalExpansion.config.get(category, "Machine.AutoCrafter", true);
        BlockMachine.enable[Types.CHARGER.ordinal()] = ThermalExpansion.config.get(category, "Machine.Charger", true);
    }

    public static enum Types {
        FURNACE,
        PULVERIZER,
        SAWMILL,
        SMELTER,
        CRUCIBLE,
        TRANSPOSER,
        ICE_GEN,
        ROCK_GEN,
        WATER_GEN,
        ASSEMBLER,
        CHARGER;

    }
}

