/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.dynamo;

import cofh.network.Payload;
import cofh.util.ItemHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.NetHandler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.dynamo.BlockDynamo;
import thermalexpansion.block.dynamo.TileDynamoBase;
import thermalexpansion.core.TEProps;
import thermalexpansion.fluid.TEFluids;

public class TileDynamoSteam
extends TileDynamoBase
implements IFluidHandler {
    static final int STEAM_MIN = 2000;
    static int coalRF = 32000;
    static int charcoalRF = 24000;
    static int woodRF = 4500;
    static int blockCoalRF = coalRF * 9;
    static int otherRF = woodRF / 3;
    static ItemStack coal = new ItemStack(Item.field_77705_m, 1, 0);
    static ItemStack charcoal = new ItemStack(Item.field_77705_m, 1, 1);
    static ItemStack blockCoal = new ItemStack(Block.field_111034_cE);
    FluidTank steamTank = new FluidTank(4000);
    FluidTank waterTank = new FluidTank(4000);
    int currentFuelRF = TileDynamoSteam.getItemEnergyValue(coal);
    int steamAmount = 40;
    FluidStack steam = new FluidStack(FluidRegistry.getFluid((String)"steam"), this.steamAmount);

    public static void initialize() {
        TileDynamoSteam.guiIds[BlockDynamo.Types.STEAM.ordinal()] = ThermalExpansion.proxy.registerGui("DynamoSteam", "dynamo", true);
        GameRegistry.registerTileEntity(TileDynamoSteam.class, (String)"cofh.thermalexpansion.DynamoSteam");
    }

    public TileDynamoSteam() {
        this.inventory = new ItemStack[1];
        this.steamAmount = this.config.maxPower / 2;
        this.steam = new FluidStack(FluidRegistry.getFluid((String)"steam"), this.steamAmount);
    }

    public int getType() {
        return BlockDynamo.Types.STEAM.ordinal();
    }

    public static int getItemEnergyValue(ItemStack fuel) {
        if (fuel == null) {
            return 0;
        }
        if (fuel.func_77969_a(coal)) {
            return coalRF;
        }
        if (fuel.func_77969_a(charcoal)) {
            return charcoalRF;
        }
        if (fuel.func_77969_a(blockCoal)) {
            return blockCoalRF;
        }
        int itemId = fuel.func_77973_b().field_77779_bT;
        if (fuel.func_77973_b() instanceof ItemBlock && Block.field_71973_m[itemId].field_72018_cp == Material.field_76245_d) {
            return woodRF;
        }
        if (itemId == Item.field_77669_D.field_77779_bT || itemId == Block.field_71987_y.field_71990_ca) {
            return otherRF;
        }
        return GameRegistry.getFuelValue((ItemStack)fuel) * 10 * 3 / 2;
    }

    public FluidTank getTank(int tankIndex) {
        if (tankIndex == 0) {
            return this.steamTank;
        }
        return this.waterTank;
    }

    @Override
    protected boolean canGenerate() {
        if (this.steamTank.getFluidAmount() > 2000) {
            return true;
        }
        if (this.waterTank.getFluidAmount() < this.config.maxPower) {
            return false;
        }
        if (this.fuelRF > 0) {
            return true;
        }
        return TileDynamoSteam.getItemEnergyValue(this.inventory[0]) > 0;
    }

    @Override
    public void generate() {
        int energy;
        if (this.steamTank.getFluidAmount() >= 2000 + this.steamAmount) {
            energy = this.calcEnergy();
            this.energyStorage.modifyEnergyStored(energy);
            this.steamTank.drain(energy >> 1, true);
        } else {
            if (this.fuelRF <= 0 && this.inventory[0] != null) {
                energy = TileDynamoSteam.getItemEnergyValue(this.inventory[0]);
                this.fuelRF += energy;
                this.currentFuelRF = energy;
                this.inventory[0] = ItemHelper.consumeItem((ItemStack)this.inventory[0]);
            }
            if (this.steamTank.getFluidAmount() > 2000) {
                energy = Math.min(this.steamTank.getFluidAmount() - 2000 << 1, this.calcEnergy());
                this.energyStorage.modifyEnergyStored(energy);
                this.steamTank.drain(energy >> 1, true);
            }
        }
        if (this.fuelRF > 0) {
            int filled = this.steamTank.fill(this.steam, true);
            this.fuelRF -= filled << 1;
            if (this.timeCheck()) {
                this.waterTank.drain(filled, true);
            }
        }
    }

    @Override
    public Icon getActiveIcon() {
        return TEFluids.fluidSteam.getIcon();
    }

    @Override
    public void attenuate() {
        this.energyStorage.modifyEnergyStored(-this.config.minPower);
        if (this.timeCheck()) {
            this.fuelRF -= 10;
            if (this.fuelRF < 0) {
                this.fuelRF = 0;
            }
            this.steamTank.drain(this.config.minPower, true);
        }
    }

    @Override
    public Payload getGuiPayload() {
        Payload payload = Payload.getInfoPayload((TileEntity)this);
        payload.addByte(TEProps.PacketID.GUI.ordinal());
        payload.addFluidStack(this.steamTank.getFluid());
        payload.addFluidStack(this.waterTank.getFluid());
        payload.addInt(this.energyStorage.getEnergyStored());
        payload.addInt(this.fuelRF);
        payload.addInt(this.currentFuelRF);
        return payload;
    }

    @Override
    public void handleTileInfoPacket(Payload payload, NetHandler handler) {
        switch (TEProps.PacketID.values()[payload.getByte()]) {
            case GUI: {
                this.steamTank.setFluid(payload.getFluidStack());
                this.waterTank.setFluid(payload.getFluidStack());
                this.energyStorage.setEnergyStored(payload.getInt());
                this.fuelRF = payload.getInt();
                this.currentFuelRF = payload.getInt();
                return;
            }
        }
    }

    public int getScaledDuration(int scale) {
        if (this.currentFuelRF <= 0) {
            this.currentFuelRF = coalRF;
        }
        return this.fuelRF * scale / this.currentFuelRF;
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.currentFuelRF = nbt.func_74762_e("FuelMax");
        this.steamTank.readFromNBT(nbt.func_74775_l("SteamTank"));
        this.waterTank.readFromNBT(nbt.func_74775_l("WaterTank"));
        if (this.currentFuelRF <= 0) {
            this.currentFuelRF = coalRF;
        }
        this.steam = new FluidStack(FluidRegistry.getFluid((String)"steam"), this.steamAmount);
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74768_a("FuelMax", this.currentFuelRF);
        nbt.func_74782_a("SteamTank", (NBTBase)this.steamTank.writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("WaterTank", (NBTBase)this.waterTank.writeToNBT(new NBTTagCompound()));
    }

    @Override
    public int[] func_94128_d(int side) {
        return side != this.facing ? SLOTS : TEProps.EMPTY_INVENTORY;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (from != ForgeDirection.UNKNOWN && from.ordinal() == this.facing) {
            return 0;
        }
        if (resource == null) {
            return 0;
        }
        if (resource.getFluid() == this.steam.getFluid()) {
            return this.steamTank.fill(resource, doFill);
        }
        if (resource.getFluid() == FluidRegistry.WATER) {
            return this.waterTank.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || from != ForgeDirection.UNKNOWN && from.ordinal() == this.facing) {
            return null;
        }
        if (resource.getFluid() == this.steam.getFluid()) {
            return this.steamTank.drain(resource.amount, doDrain);
        }
        if (resource.getFluid() == FluidRegistry.WATER) {
            return this.waterTank.drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (from != ForgeDirection.UNKNOWN && from.ordinal() == this.facing) {
            return null;
        }
        return this.waterTank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return from.ordinal() != this.facing;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return from.ordinal() != this.facing;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.steamTank.getInfo(), this.waterTank.getInfo()};
    }

    @Override
    public int getEnergyPerTick() {
        return this.steamTank.getFluidAmount() > 2000 ? Math.min(this.steamTank.getFluidAmount() - 2000 << 1, this.calcEnergy()) : 0;
    }

    static {
        String category = "fuels.steam";
        coalRF = TEFluids.configFuels.get(category, "coal", coalRF);
        charcoalRF = TEFluids.configFuels.get(category, "charcoal", charcoalRF);
        woodRF = TEFluids.configFuels.get(category, "wood", woodRF);
        blockCoalRF = coalRF * 10;
        otherRF = woodRF / 3;
    }
}

