/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.dynamo;

import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import thermalexpansion.block.dynamo.TileDynamoBase;

public class TileDynamoKinetic
extends TileDynamoBase
implements IPowerReceptor {
    protected PowerHandler powerHandler = new PowerHandler(this, PowerHandler.Type.STORAGE);

    public static void initialize() {
    }

    public TileDynamoKinetic() {
        this.powerHandler.configure(2.0f, 16.0f, 2000.0f, 1000.0f);
    }

    public int getType() {
        return 0;
    }

    @Override
    protected boolean canGenerate() {
        return this.fuelRF > 0 ? true : this.powerHandler.getEnergyStored() >= 1.0f;
    }

    @Override
    protected void generate() {
        if (this.fuelRF <= 0) {
            this.fuelRF = (int)((float)this.fuelRF + 10.0f * this.powerHandler.useEnergy(1.0f, 1000.0f, true));
        }
        int energy = this.calcEnergy();
        this.energyStorage.modifyEnergyStored(energy);
        this.fuelRF -= energy;
    }

    @Override
    public Icon getActiveIcon() {
        return FluidRegistry.LAVA.getIcon();
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.powerHandler.readFromNBT(nbt);
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        this.powerHandler.writeToNBT(nbt);
    }

    @Override
    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection side) {
        return this.powerHandler.getPowerReceiver();
    }

    @Override
    public void doWork(PowerHandler workProvider) {
    }

    @Override
    public World getWorld() {
        return this.field_70331_k;
    }
}

