/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block;

import buildcraft.api.tools.IToolWrench;
import cofh.api.block.IDismantleable;
import cofh.block.BlockCoFHBase;
import cofh.render.IconRegistry;
import cofh.util.ItemHelper;
import cofh.util.ServerHelper;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.TileInventory;
import thermalexpansion.block.TileTEBase;
import thermalexpansion.util.Utils;

public abstract class BlockTEBase
extends BlockCoFHBase
implements IDismantleable {
    public BlockTEBase(int id, Material material) {
        super(id, material);
        this.func_71884_a(field_71976_h);
        this.func_71849_a(ThermalExpansion.tabBlocks);
    }

    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int hitSide, float hitX, float hitY, float hitZ) {
        Item equipped;
        Item item = equipped = player.func_71045_bC() != null ? player.func_71045_bC().func_77973_b() : null;
        if (Utils.isHoldingMultimeter(player, x, y, z)) {
            return false;
        }
        if (player.func_70093_af()) {
            if (Utils.isHoldingUsableWrench(player, x, y, z)) {
                if (ServerHelper.isServerWorld((World)world) && this.canDismantle(player, world, x, y, z)) {
                    this.dismantleBlock(player, world, x, y, z, false);
                }
                ((IToolWrench)equipped).wrenchUsed(player, x, y, z);
                return true;
            }
            return false;
        }
        TileTEBase tile = (TileTEBase)world.func_72796_p(x, y, z);
        if (tile == null) {
            return false;
        }
        if (Utils.isHoldingUsableWrench(player, x, y, z)) {
            if (ServerHelper.isServerWorld((World)world)) {
                tile.onWrench(player, hitSide);
            }
            ((IToolWrench)equipped).wrenchUsed(player, x, y, z);
            return true;
        }
        return tile.openGui(player);
    }

    public void func_71860_a(World world, int x, int y, int z, EntityLivingBase living, ItemStack stack) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileInventory) {
            ((TileInventory)tile).setInvName(ItemHelper.getNameFromItemStack((ItemStack)stack));
        }
        super.func_71860_a(world, x, y, z, living, stack);
    }

    public Icon func_71858_a(int side, int metadata) {
        return IconRegistry.getIcon((String)"GlassHardened");
    }

    public NBTTagCompound getItemStackTag(World world, int x, int y, int z) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileInventory && !((TileInventory)tile).invName.isEmpty()) {
            return ItemHelper.setItemStackTagName(null, (String)((TileInventory)tile).invName);
        }
        return null;
    }

    public ItemStack dismantleBlock(EntityPlayer player, NBTTagCompound nbt, World world, int x, int y, int z, boolean returnBlock, boolean simulate) {
        int bMeta = world.func_72805_g(x, y, z);
        ItemStack dropBlock = new ItemStack(this.field_71990_ca, 1, bMeta);
        if (!simulate) {
            TileEntity tile = world.func_72796_p(x, y, z);
            if (tile instanceof TileTEBase) {
                ((TileTEBase)tile).blockDismantled();
            }
            if (nbt != null) {
                dropBlock.func_77982_d(nbt);
            }
            world.func_94571_i(x, y, z);
            if (dropBlock != null && !returnBlock) {
                float f = 0.3f;
                double x2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double y2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double z2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                EntityItem item = new EntityItem(world, (double)x + x2, (double)y + y2, (double)z + z2, dropBlock);
                item.field_70293_c = 10;
                world.func_72838_d((Entity)item);
                if (player != null) {
                    Utils.dismantleLog(player.field_71092_bJ, this.field_71990_ca, bMeta, x, y, z);
                }
            }
        }
        return dropBlock;
    }
}

