/*
 * Decompiled with CFR 0.152.
 */
package appeng.proxy.helpers;

import appeng.api.IItemComparison;
import appeng.api.integration.IBeeComparison;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.genetics.IIndividual;

public class ForestryGeneticsComparison
implements IItemComparison,
IBeeComparison {
    IIndividual idiv;
    String Species;

    @Override
    public IIndividual getIndividual() {
        return this.idiv;
    }

    public ForestryGeneticsComparison(IIndividual _idiv) {
        this.idiv = _idiv;
        this.Species = _idiv.getGenome().getActiveAllele(EnumTreeChromosome.SPECIES.ordinal()).getUID();
    }

    @Override
    public boolean sameAsPrecise(IItemComparison comp) {
        if (comp instanceof ForestryGeneticsComparison) {
            IIndividual op = ((ForestryGeneticsComparison)comp).idiv;
            if (this.idiv.isAnalyzed() == op.isAnalyzed()) {
                return this.idiv.isGeneticEqual(op);
            }
        }
        return false;
    }

    @Override
    public boolean sameAsFuzzy(IItemComparison comp) {
        if (comp instanceof ForestryGeneticsComparison) {
            return this.Species.equals(((ForestryGeneticsComparison)comp).Species);
        }
        return false;
    }
}

