/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.tile;

import appeng.api.IAEItemStack;
import appeng.api.IExternalStorageHandler;
import appeng.api.IItemList;
import appeng.api.WorldCoord;
import appeng.api.config.FuzzyMode;
import appeng.api.config.IConfigEnum;
import appeng.api.config.ItemFlow;
import appeng.api.config.ListMode;
import appeng.api.events.GridStorageUpdateEvent;
import appeng.api.events.GridTileConnectivityEvent;
import appeng.api.me.tiles.ICellContainer;
import appeng.api.me.tiles.IColoredMETile;
import appeng.api.me.tiles.IConfigureableTile;
import appeng.api.me.tiles.IDirectionalMETile;
import appeng.api.me.tiles.IGridMachine;
import appeng.api.me.tiles.IPriorityTile;
import appeng.api.me.tiles.ITileIOCable;
import appeng.api.me.tiles.ITilePushable;
import appeng.api.me.util.IConfigManager;
import appeng.api.me.util.IGridInterface;
import appeng.api.me.util.IMEInventory;
import appeng.api.me.util.IMEInventoryHandler;
import appeng.common.AppEng;
import appeng.common.AppEngConfiguration;
import appeng.common.AppEngInternalInventory;
import appeng.common.AppEngTextureRegistry;
import appeng.common.base.AppEngTile;
import appeng.common.network.IAppEngNetworkTile;
import appeng.gui.AppEngGuiHandler;
import appeng.interfaces.IConfigEnabledTile;
import appeng.interfaces.INetworkNotifiable;
import appeng.interfaces.ISharedTagCompoundCache;
import appeng.interfaces.InvOperation;
import appeng.me.MEICachedInventoryWrapper;
import appeng.me.MEIInventoryWrapper;
import appeng.me.MEInventoryHandler;
import appeng.me.MEInventoryHandlerWrapper;
import appeng.me.MEInventoryNetwork;
import appeng.me.METhrottle;
import appeng.me.basetiles.TileCableBase;
import appeng.me.tile.IInternalInventory;
import appeng.me.tile.TileController;
import appeng.me.tile.TileInterfaceBase;
import appeng.render.AppEngBlockRenderer;
import appeng.util.AEItemStack;
import appeng.util.ConfigManager;
import appeng.util.InventoryAdaptor;
import appeng.util.ItemList;
import appeng.util.Platform;
import appeng.util.inv.WrapperMCISidedInventory;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class TileStorageBus
extends TileCableBase
implements IPipeConnection,
IConfigEnabledTile,
IConfigureableTile,
INetworkNotifiable,
ISharedTagCompoundCache,
ICellContainer,
ITilePushable,
ITileIOCable,
IAppEngNetworkTile,
IGridMachine,
IDirectionalMETile,
IColoredMETile,
IPriorityTile {
    public static HashMap<Class, Boolean> blackListed = new HashMap();
    CacheIAEItemStack[] itemStackCache = new CacheIAEItemStack[0];
    Class oldTarget;
    public boolean updating = false;
    ForgeDirection orientation;
    int priority = 1;
    ItemFlow IOMode;
    FuzzyMode FuzzyMode;
    ListMode lMode;
    METhrottle throttle;
    ItemList oldList;
    public ITileIOCable.Version ver;
    ConfigManager config = new ConfigManager(this);
    int color = -1;
    public AppEngInternalInventory storeable;

    IMEInventoryHandler cacheView(IMEInventoryHandler in) {
        return new AvailableItemsBuffer(in, this);
    }

    @Override
    public ITileIOCable.Version getVersion() {
        return this.ver;
    }

    @Override
    public boolean isColored(ForgeDirection dir) {
        return this.color >= 0;
    }

    @Override
    public void openGui(EntityPlayer p) {
        Platform.openGui(p, AppEngGuiHandler.GUI_STORAGE_BUS, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public AxisAlignedBB extendBusCollision(AxisAlignedBB b) {
        return this.IOBusCollision(0.1f, this.orientation, b);
    }

    @Override
    public void actionHandler(EntityPlayerMP pmp, int action, DataInputStream stream) {
        try {
            if (action == 1) {
                this.setPriority(stream.readInt());
                this.markForUpdate();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    @Override
    public void updateTileEntity() {
        IGridInterface gi;
        if (this.throttle.process() && (gi = this.getGrid()) != null) {
            IMEInventoryHandler inv = this.getInv();
            ItemList newList = null;
            this.updating = true;
            if (inv != null && this.IOMode != ItemFlow.WRITE) {
                IMEInventoryHandler t = inv;
                if (inv instanceof MEInventoryHandlerWrapper) {
                    t = ((MEInventoryHandlerWrapper)inv).getTarget();
                }
                if (t instanceof MEInventoryNetwork) {
                    IMEInventoryHandler h = gi.getCellArray();
                    if (h instanceof MEInventoryNetwork) {
                        MEInventoryNetwork myNet = (MEInventoryNetwork)h;
                        if (myNet.checkRecurrsion(myNet)) {
                            newList = (ItemList)inv.getAvailableItems(new ItemList());
                            myNet.endRecurssion(myNet);
                        } else {
                            newList = new ItemList();
                        }
                    } else {
                        newList = new ItemList();
                    }
                } else {
                    newList = (ItemList)inv.getAvailableItems(new ItemList());
                }
            }
            this.updating = false;
            if (this.oldList == null) {
                this.oldList = new ItemList();
            }
            if (newList == null) {
                newList = new ItemList();
            }
            for (IAEItemStack is : this.oldList) {
                is.setStackSize(-is.getStackSize());
            }
            for (IAEItemStack is : newList) {
                this.oldList.add(is);
            }
            TileController tc = (TileController)gi.getController();
            for (IAEItemStack is : this.oldList) {
                if (is.getStackSize() > 0L) {
                    this.throttle.hasAccomplishedWork();
                    tc.notifyAddItems(is);
                    continue;
                }
                if (is.getStackSize() >= 0L) continue;
                this.throttle.hasAccomplishedWork();
                is.setStackSize(-is.getStackSize());
                tc.notifyExtractItems(is);
            }
            this.oldList = newList;
        }
    }

    @Override
    public void InvChanged(IInternalInventory inv, int slot, InvOperation Operation) {
        super.InvChanged(inv, slot, Operation);
        if (inv == this.storeable) {
            MinecraftForge.EVENT_BUS.post((Event)new GridStorageUpdateEvent(this.field_70331_k, this.getLocation(), this.getGrid()));
        }
    }

    public TileStorageBus() {
        this.orientation = ForgeDirection.UP;
        this.IOMode = ItemFlow.READ_WRITE;
        this.config.RegisterSetting(this.IOMode);
        this.FuzzyMode = appeng.api.config.FuzzyMode.Percent_99;
        this.config.RegisterSetting(this.FuzzyMode);
        this.lMode = ListMode.WHITELIST;
        this.config.RegisterSetting(this.lMode);
        this.ver = ITileIOCable.Version.Precision;
        this.storeable = new AppEngInternalInventory(this, 54);
        this.orientation = ForgeDirection.NORTH;
        this.throttle = new METhrottle(10, AppEngConfiguration.storageBusMinTickRate, AppEngConfiguration.storageBusMinTickRate + 60);
    }

    @Override
    public void setGrid(IGridInterface gi) {
        super.setGrid(gi);
    }

    @Override
    public int getLightValue() {
        return 0;
    }

    @Override
    public int getLightOpacity() {
        return 1;
    }

    @Override
    public void setOrientationBySide(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        super.setOrientationBySide(player, side, hitX, hitY, hitZ);
        this.orientation = ForgeDirection.getOrientation((int)side);
        if (player.func_70093_af()) {
            this.orientation = this.orientation.getOpposite();
        }
        WorldCoord pos = new WorldCoord(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        pos.add(this.orientation, -1);
        TileEntity te = this.field_70331_k.func_72796_p(pos.x, pos.y, pos.z);
        if (te instanceof IColoredMETile && ((IColoredMETile)te).isColored(ForgeDirection.UNKNOWN)) {
            this.color = ((IColoredMETile)te).getColor();
        }
        if (this.isLoaded) {
            MinecraftForge.EVENT_BUS.post((Event)new GridTileConnectivityEvent(this, this.field_70331_k, this.getLocation()));
            MinecraftForge.EVENT_BUS.post((Event)new GridStorageUpdateEvent(this.field_70331_k, this.getLocation(), this.getGrid()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderTipPart(Block block, RenderBlocks renderer, float offset, float Thickness, int x, int y, int z) {
        AppEngBlockRenderer.instance.setOverrideBlockTexture(block, this.ver == ITileIOCable.Version.Fuzzy ? AppEngTextureRegistry.Blocks.BlockFuzzyInterface.get() : AppEngTextureRegistry.Blocks.BlockInterface.get());
        float offX = (float)this.orientation.offsetX / 2.0f;
        float offY = (float)this.orientation.offsetY / 2.0f;
        float offZ = (float)this.orientation.offsetZ / 2.0f;
        float centerX = 0.5f;
        float centerY = 0.5f;
        float centerZ = 0.5f;
        float thickX = (double)Math.abs(this.orientation.offsetX) > 0.1 ? 0.076f : Thickness;
        float thickY = (double)Math.abs(this.orientation.offsetY) > 0.1 ? 0.076f : Thickness;
        float thickZ = (double)Math.abs(this.orientation.offsetZ) > 0.1 ? 0.076f : Thickness;
        renderer.func_83020_a((double)(centerX + offX - thickX), (double)((centerY += (float)this.orientation.offsetY * -offset) + offY - thickY), (double)((centerZ += (float)this.orientation.offsetZ * -offset) + offZ - thickZ), (double)((centerX += (float)this.orientation.offsetX * -offset) + offX + thickX), (double)(centerY + offY + thickY), (double)(centerZ + offZ + thickZ));
        renderer.func_78570_q(block, x, y, z);
        AppEngBlockRenderer.instance.setOverrideBlockTexture(block, null);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        renderer.field_78661_f = true;
        Icon cableColor = this.color == -1 ? AppEngTextureRegistry.Blocks.MECableClear.get() : AppEngTextureRegistry.Blocks.MECableColors[this.color].get();
        this.renderCableAt(0.11, world, x, y, z, block, modelId, renderer, cableColor, true, 0.0);
        this.renderCableAt(0.18, world, x, y, z, block, modelId, renderer, AppEngTextureRegistry.Blocks.MECable.get(), false, 0.06);
        this.renderTipPart(block, renderer, 0.076f, 0.4375f, x, y, z);
        this.renderTipPart(block, renderer, 0.152f, 0.45f, x, y, z);
        this.renderTipPart(block, renderer, 0.22799999f, 0.3f, x, y, z);
        this.renderTipPart(block, renderer, 0.304f, 0.15f, x, y, z);
        renderer.field_78661_f = false;
        super.renderWorldBlock(world, x, y, z, block, modelId, renderer);
        return true;
    }

    @Override
    public NBTTagCompound getSettings(AppEngTile.ConfigMode mode) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("priority", this.priority);
        this.config.writeToNBT(tag);
        NBTTagCompound it = new NBTTagCompound();
        if (this.storeable != null) {
            this.storeable.writeToNBT(it);
        }
        tag.func_74766_a("it", it);
        return tag;
    }

    @Override
    public void restoreSettings(NBTTagCompound tag, AppEngTile.ConfigMode mode) {
        try {
            this.storeable.readFromNBT(tag.func_74775_l("it"));
            this.priority = tag.func_74762_e("priority");
            this.config.readFromNBT(tag);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound par1nbtTagCompound) {
        super.func_70307_a(par1nbtTagCompound);
        this.color = par1nbtTagCompound.func_74771_c("co");
        this.orientation = ForgeDirection.getOrientation((int)par1nbtTagCompound.func_74771_c("ori"));
        this.storeable.readFromNBT(par1nbtTagCompound.func_74775_l("it"));
        this.priority = par1nbtTagCompound.func_74762_e("priority");
        this.IOMode = this.config.loadSetting(this.IOMode, par1nbtTagCompound, "IOMode");
        this.FuzzyMode = this.config.loadSetting(this.FuzzyMode, par1nbtTagCompound, "FuzzyMode");
        this.lMode = this.config.loadSetting(this.lMode, par1nbtTagCompound, "lMode");
        try {
            this.ver = ITileIOCable.Version.valueOf(par1nbtTagCompound.func_74779_i("ver"));
        }
        catch (IllegalArgumentException err) {
            this.ver = ITileIOCable.Version.Precision;
        }
        MinecraftForge.EVENT_BUS.post((Event)new GridStorageUpdateEvent(this.field_70331_k, this.getLocation(), this.getGrid()));
    }

    @Override
    public void func_70310_b(NBTTagCompound par1nbtTagCompound) {
        super.func_70310_b(par1nbtTagCompound);
        par1nbtTagCompound.func_74774_a("co", (byte)this.color);
        par1nbtTagCompound.func_74774_a("ori", (byte)this.orientation.ordinal());
        par1nbtTagCompound.func_74768_a("priority", this.priority);
        par1nbtTagCompound.func_74778_a("ver", this.ver.toString());
        par1nbtTagCompound.func_74778_a("lMode", this.lMode.toString());
        par1nbtTagCompound.func_74778_a("IOMode", this.IOMode.toString());
        par1nbtTagCompound.func_74778_a("FuzzyMode", this.FuzzyMode.toString());
        NBTTagCompound it = new NBTTagCompound();
        if (this.storeable != null) {
            this.storeable.writeToNBT(it);
        }
        par1nbtTagCompound.func_74766_a("it", it);
    }

    @Override
    public Icon getBlockTextureFromSide(ForgeDirection side) {
        return AppEngTextureRegistry.Blocks.MECable.get();
    }

    @Override
    public boolean isBlockNormalCube() {
        return false;
    }

    @Override
    public void setColor(int offset) {
        this.color = offset;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public boolean handleTilePacket(DataInputStream stream) throws IOException {
        ForgeDirection oldOrientation = this.orientation;
        int oldColor = this.color;
        boolean updated = super.handleTilePacket(stream);
        this.priority = stream.readInt();
        this.orientation = ForgeDirection.getOrientation((int)stream.readByte());
        this.color = stream.readByte();
        this.ver = ITileIOCable.Version.values()[stream.readByte()];
        return oldColor != this.color || oldOrientation != this.orientation || updated;
    }

    @Override
    public void configureTilePacket(DataOutputStream data) {
        try {
            super.configureTilePacket(data);
            data.writeInt(this.priority);
            data.writeByte((byte)this.orientation.ordinal());
            data.writeByte((byte)this.color);
            data.writeByte((byte)this.ver.ordinal());
        }
        catch (IOException e) {
            return;
        }
    }

    @Override
    public void onNeighborBlockChange() {
        super.onNeighborBlockChange();
        if (this.getGrid() != null) {
            MinecraftForge.EVENT_BUS.post((Event)new GridStorageUpdateEvent(this.field_70331_k, this.getLocation(), this.getGrid()));
        }
    }

    @Override
    public void cycleOrientation() {
        this.orientation = Platform.cycleOrientations(this.orientation, false);
        MinecraftForge.EVENT_BUS.post((Event)new GridTileConnectivityEvent(this, this.getWorld(), this.getLocation()));
    }

    @Override
    public float getHoleThickness(ForgeDirection direction) {
        if (this.orientation == direction) {
            return 0.0625f;
        }
        return super.getHoleThickness(direction);
    }

    @Override
    public boolean canConnect(ForgeDirection dir) {
        return dir.ordinal() != this.orientation.ordinal();
    }

    @Override
    public float getPowerDrainPerTick() {
        return 1.0f;
    }

    @Override
    public IInventory getConfiguration() {
        return this.storeable;
    }

    @Override
    public boolean canPushItem(ItemStack out) {
        if (out == null) {
            return false;
        }
        WorldCoord wc = new WorldCoord(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        wc.add(this.orientation, 1);
        InventoryAdaptor ia = InventoryAdaptor.getAdaptor(this.field_70331_k.func_72796_p(wc.x, wc.y, wc.z), this.orientation.getOpposite());
        if (ia != null) {
            return ia.simulateAdd(out) == null;
        }
        return false;
    }

    @Override
    public ItemStack pushItem(ItemStack out) {
        if (out == null) {
            return null;
        }
        WorldCoord wc = new WorldCoord(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        wc.add(this.orientation, 1);
        InventoryAdaptor ia = InventoryAdaptor.getAdaptor(this.field_70331_k.func_72796_p(wc.x, wc.y, wc.z), this.orientation.getOpposite());
        if (ia != null) {
            ItemStack returnValue = out.func_77946_l();
            IGridInterface gi = this.getGrid();
            int allowItems = gi.usePowerForAddition(out.field_77994_a, 1);
            if (allowItems < out.field_77994_a) {
                out.field_77994_a = allowItems;
                returnValue.field_77994_a -= allowItems;
            } else {
                returnValue.field_77994_a = 0;
            }
            if (out.field_77994_a > 0) {
                out = ia.addItems(out);
            }
            if (out != null) {
                returnValue.field_77994_a += out.field_77994_a;
            }
            if (returnValue.field_77994_a == 0) {
                return null;
            }
            return returnValue;
        }
        return out;
    }

    public TileEntity getTarget() {
        WorldCoord wc = this.getLocation();
        wc = wc.add(this.orientation, 1);
        return this.field_70331_k.func_72796_p(wc.x, wc.y, wc.z);
    }

    private IMEInventoryHandler getInv() {
        TileEntity te = this.getTarget();
        if (te != null) {
            if (te instanceof TileInterfaceBase && ((TileInterfaceBase)te).getGrid() == this.getGrid()) {
                return null;
            }
            IMEInventory list = null;
            IExternalStorageHandler handler = AppEng.getApiInstance().getExternalStorageRegistry().getHandler(te, this.orientation.getOpposite());
            if (handler != null) {
                list = handler.getInventory(te, this.orientation.getOpposite());
            }
            if (list == null) {
                if (te instanceof TileInterfaceBase) {
                    return null;
                }
                if (blackListed.containsKey(te.getClass())) {
                    if (te instanceof ISidedInventory) {
                        list = new MEIInventoryWrapper(new WrapperMCISidedInventory((ISidedInventory)te, this.orientation.getOpposite()), InventoryAdaptor.getAdaptor(te, this.orientation.getOpposite()));
                    } else if (te instanceof IInventory) {
                        list = new MEIInventoryWrapper((IInventory)te, InventoryAdaptor.getAdaptor(te, this.orientation.getOpposite()));
                    }
                } else if (te instanceof TileEntityChest) {
                    list = new MEICachedInventoryWrapper(this, Platform.GetChestInv(te), null);
                } else if (te instanceof ISidedInventory) {
                    list = new MEICachedInventoryWrapper(this, new WrapperMCISidedInventory((ISidedInventory)te, this.orientation.getOpposite()), InventoryAdaptor.getAdaptor(te, this.orientation.getOpposite()));
                } else if (te instanceof IInventory) {
                    list = new MEICachedInventoryWrapper(this, (IInventory)te, InventoryAdaptor.getAdaptor(te, this.orientation.getOpposite()));
                }
            }
            if (list != null) {
                if (this.oldTarget != list.getClass()) {
                    this.oldTarget = list.getClass();
                    MinecraftForge.EVENT_BUS.post((Event)new GridStorageUpdateEvent(this.field_70331_k, this.getLocation(), this.getGrid()));
                }
                if (list instanceof IMEInventoryHandler) {
                    MEInventoryHandlerWrapper wrapper = new MEInventoryHandlerWrapper((IMEInventoryHandler)list);
                    wrapper.setUpdateTarget(te);
                    wrapper.setFlow(this.IOMode);
                    if (wrapper.getGrid() == this.getGrid()) {
                        return null;
                    }
                    return this.cacheView(wrapper);
                }
                MEInventoryHandler wrapper = new MEInventoryHandler(list);
                wrapper.setUpdateTarget(te);
                wrapper.setFlow(this.IOMode);
                return this.cacheView(wrapper);
            }
        }
        return null;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int p) {
        this.priority = p;
        if (this.getGrid() != null) {
            MinecraftForge.EVENT_BUS.post((Event)new GridStorageUpdateEvent(this.field_70331_k, this.getLocation(), this.getGrid()));
        }
    }

    public IMEInventoryHandler getReadWriteCell() {
        return this.getInv();
    }

    @Override
    public List<IMEInventoryHandler> getCellArray() {
        ArrayList<IMEInventoryHandler> o = new ArrayList<IMEInventoryHandler>();
        IMEInventoryHandler list = this.getInv();
        if (list != null) {
            ItemList pl = (ItemList)this.storeable.getIMEI().getAvailableItems(new ItemList());
            if (pl.size() > 0) {
                list.setPreformattedItems(pl, this.FuzzyMode, this.lMode);
            } else {
                list.setPreformattedItems(null, this.FuzzyMode, this.lMode);
            }
            list.setFuzzyPreformatted(this.ver == ITileIOCable.Version.Fuzzy);
            o.add(list);
            return o;
        }
        return o;
    }

    @Override
    public String getName() {
        if (this.ver == ITileIOCable.Version.Fuzzy) {
            return "AppEng.Blocks.StorageBusFuzzy.name";
        }
        return "AppEng.Blocks.StorageBus.name";
    }

    @Override
    public void notifyExtractItems(IAEItemStack removed) {
        if (this.oldList != null) {
            IAEItemStack i = removed.copy();
            i.setStackSize(-i.getStackSize());
            this.oldList.add(i);
        }
    }

    @Override
    public void notifyAddItems(IAEItemStack added) {
        if (this.oldList != null) {
            this.oldList.add(added);
        }
    }

    @Override
    public void checkCacheSetup(int size) {
        if (this.itemStackCache.length != size) {
            this.itemStackCache = new CacheIAEItemStack[size];
        }
    }

    @Override
    public IAEItemStack getItem(int x, ItemStack is) {
        IAEItemStack aeis = null;
        if (is != null) {
            boolean update = false;
            CacheIAEItemStack cached = this.itemStackCache[x];
            if (cached == null || cached.src == null) {
                update = true;
                aeis = AEItemStack.create(is);
            } else if (cached.src == is) {
                if (cached.stack.getItemDamage() != Item.field_77731_bo.getDamage(is)) {
                    update = true;
                    aeis = AEItemStack.create(is);
                } else {
                    aeis = cached.stack;
                    aeis.setStackSize(is.field_77994_a);
                }
            } else if (cached.src.func_77969_a(is) && cached.src.func_77978_p() == is.func_77978_p()) {
                aeis = cached.stack;
                aeis.setStackSize(is.field_77994_a);
            } else {
                update = true;
                aeis = AEItemStack.create(is);
            }
            if (update) {
                this.itemStackCache[x] = new CacheIAEItemStack();
                this.itemStackCache[x].src = is;
                this.itemStackCache[x].stack = aeis;
            }
        } else {
            this.itemStackCache[x] = null;
        }
        return aeis;
    }

    @Override
    public List<String> getConfigurations() {
        return this.config.getConfigurations();
    }

    @Override
    public String nextConfiguration(String name) {
        return this.config.nextConfiguration(name);
    }

    @Override
    public String prevConfiguration(String name) {
        return this.config.prevConfiguration(name);
    }

    @Override
    public String setConfiguration(String name, String value) {
        return this.config.setConfiguration(name, value);
    }

    @Override
    public String getConfiguration(String name) {
        return this.config.getConfiguration(name);
    }

    @Override
    public List<String> getConfiguationOptions(String name) {
        return this.config.getConfiguationOptions(name);
    }

    @Override
    public void updateSetting(IConfigEnum newValue) {
        if (newValue instanceof ItemFlow) {
            this.IOMode = (ItemFlow)newValue;
        }
        if (newValue instanceof ListMode) {
            this.lMode = (ListMode)newValue;
        }
        if (newValue instanceof FuzzyMode) {
            this.FuzzyMode = (FuzzyMode)newValue;
            if (this.getGrid() != null) {
                MinecraftForge.EVENT_BUS.post((Event)new GridStorageUpdateEvent(this.field_70331_k, this.getLocation(), this.getGrid()));
            }
        }
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.config;
    }

    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType type, ForgeDirection with) {
        if (type == IPipeTile.PipeType.ITEM) {
            return this.orientation == with ? IPipeConnection.ConnectOverride.CONNECT : IPipeConnection.ConnectOverride.DISCONNECT;
        }
        return IPipeConnection.ConnectOverride.DISCONNECT;
    }

    @Override
    public boolean isBusy() {
        return false;
    }

    public ForgeDirection getPrimaryOrientation() {
        return this.orientation;
    }

    public int getSpin() {
        return 0;
    }

    public void setPrimaryOrientation(ForgeDirection s) {
        this.orientation = s;
        MinecraftForge.EVENT_BUS.post((Event)new GridTileConnectivityEvent(this, this.getWorld(), this.getLocation()));
    }

    public void setSpin(int spin) {
    }

    class AvailableItemsBuffer
    extends MEInventoryHandlerWrapper {
        TileStorageBus bus;

        public AvailableItemsBuffer(IMEInventoryHandler h, TileStorageBus _bus) {
            super(h);
            this.bus = _bus;
        }

        @Override
        public IItemList getAvailableItems() {
            if (this.bus.updating) {
                return super.getAvailableItems();
            }
            ItemList tmp = new ItemList();
            if (this.bus.oldList != null) {
                for (IAEItemStack aeis : this.bus.oldList) {
                    tmp.add(aeis);
                }
            }
            return tmp;
        }

        @Override
        public IItemList getAvailableItems(IItemList out) {
            if (this.bus.updating) {
                return super.getAvailableItems(out);
            }
            if (this.bus.oldList != null) {
                for (IAEItemStack aeis : this.bus.oldList) {
                    out.add(aeis.copy());
                }
            }
            return out;
        }
    }

    class CacheIAEItemStack {
        ItemStack src;
        IAEItemStack stack;

        CacheIAEItemStack() {
        }
    }
}

