/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.tile;

import appeng.api.config.ItemFlow;
import appeng.api.me.tiles.IGridMachine;
import appeng.api.me.tiles.IMEPowerStorage;
import appeng.api.networkevents.MENetworkPowerStorage;
import appeng.common.AppEngTextureRegistry;
import appeng.common.base.AppEngTile;
import appeng.common.network.IAppEngNetworkTile;
import appeng.me.basetiles.TileME;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;

public class TileEnergyCell
extends TileME
implements IMEPowerStorage,
IAppEngNetworkTile,
IGridMachine {
    private double cpower;
    private byte oldPowerReading;

    public TileEnergyCell() {
        this.updatesOnPower = false;
        this.updatesOnGrid = false;
    }

    @Override
    public int getLightValue() {
        return (int)((double)this.oldPowerReading * 0.8);
    }

    @Override
    public void restoreSettings(NBTTagCompound tag, AppEngTile.ConfigMode mode) {
        this.cpower = tag.func_74762_e("storedEnergy");
        this.onUpdatePower();
    }

    @Override
    public Icon getBlockTextureFromSide(ForgeDirection dir) {
        return AppEngTextureRegistry.Blocks.MEEnergyCell[this.oldPowerReading].get();
    }

    @Override
    public void func_70310_b(NBTTagCompound par1nbtTagCompound) {
        super.func_70310_b(par1nbtTagCompound);
        par1nbtTagCompound.func_74780_a("ec", this.cpower);
    }

    @Override
    public void func_70307_a(NBTTagCompound par1nbtTagCompound) {
        super.func_70307_a(par1nbtTagCompound);
        this.cpower = par1nbtTagCompound.func_74769_h("ec");
        this.onUpdatePower();
    }

    void onUpdatePower() {
        byte OlderPowerReading = this.oldPowerReading;
        this.oldPowerReading = (byte)(8.0 * (this.getMECurrentPower() / this.getMEMaxPower()));
        if (this.oldPowerReading > 7) {
            this.oldPowerReading = (byte)7;
        }
        if (this.oldPowerReading < 0) {
            this.oldPowerReading = 0;
        }
        if (OlderPowerReading != this.oldPowerReading) {
            this.markForUpdate();
            if (this.field_70331_k != null) {
                this.field_70331_k.func_72969_x(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            }
        }
    }

    @Override
    public boolean useMEEnergy(float use, String for_what) {
        if (this.cpower > (double)use) {
            this.cpower -= (double)use;
            this.onUpdatePower();
            return true;
        }
        this.cpower = 0.0;
        this.onUpdatePower();
        return false;
    }

    @Override
    public double drainMEPower(double amt) {
        if (this.getGrid() == null) {
            return 0.0;
        }
        boolean wasFull = this.cpower > 199999.0;
        this.cpower -= amt;
        if (this.cpower < 0.0) {
            amt += this.cpower;
            this.cpower = 0.0;
        }
        if (this.cpower < 200000.0 && wasFull) {
            this.getGrid().postEvent(new MENetworkPowerStorage(this, MENetworkPowerStorage.PowerEventType.REQUEST_POWER));
        }
        this.onUpdatePower();
        return amt;
    }

    @Override
    public boolean requiresTickingUpdates() {
        return false;
    }

    @Override
    public double addMEPower(double amt) {
        if (this.getGrid() == null) {
            return amt;
        }
        boolean wasEmpty = this.cpower < 0.001;
        this.cpower += amt;
        if (this.cpower > this.getMEMaxPower()) {
            double oer = this.cpower - this.getMEMaxPower();
            this.cpower = this.getMEMaxPower();
            this.onUpdatePower();
            return oer;
        }
        if (wasEmpty && this.cpower > 0.001) {
            this.getGrid().postEvent(new MENetworkPowerStorage(this, MENetworkPowerStorage.PowerEventType.PROVIDE_POWER));
        }
        this.onUpdatePower();
        return 0.0;
    }

    @Override
    public double getMEMaxPower() {
        return 200000.0;
    }

    @Override
    public double getMECurrentPower() {
        return this.cpower;
    }

    @Override
    public boolean isPublicPowerStorage() {
        return true;
    }

    @Override
    public ItemFlow getPowerFlow() {
        return ItemFlow.READ_WRITE;
    }

    @Override
    public void configureTilePacket(DataOutputStream data) throws IOException {
        data.writeByte(this.oldPowerReading);
    }

    @Override
    public boolean handleTilePacket(DataInputStream stream) throws IOException {
        byte d = this.oldPowerReading;
        this.oldPowerReading = stream.readByte();
        return this.oldPowerReading != d;
    }

    @Override
    public boolean syncStyle(IAppEngNetworkTile.SyncTime st) {
        return st == IAppEngNetworkTile.SyncTime.WORLD;
    }

    @Override
    public float getPowerDrainPerTick() {
        return 0.0f;
    }
}

