/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.gadgets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.IAlleleFruit;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.arboriculture.gadgets.BlockTreeContainer;
import forestry.arboriculture.gadgets.TileSapling;
import forestry.core.proxy.Proxies;
import forestry.core.render.TextureManager;
import forestry.core.utils.StackUtils;
import forestry.plugins.PluginArboriculture;
import java.util.ArrayList;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockSapling
extends BlockTreeContainer {
    @SideOnly(value=Side.CLIENT)
    private static Icon defaultIcon;

    public static TileSapling getSaplingTile(IBlockAccess world, int x, int y, int z) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (!(tile instanceof TileSapling)) {
            return null;
        }
        return (TileSapling)tile;
    }

    public BlockSapling(int id) {
        super(id, Material.field_76254_j);
        float factor = 0.4f;
        this.func_71905_a(0.5f - factor, 0.0f, 0.5f - factor, 0.5f + factor, factor * 2.0f, 0.5f + factor);
        this.func_71884_a(field_71965_g);
    }

    public TileEntity func_72274_a(World var1) {
        return new TileSapling();
    }

    public AxisAlignedBB func_71872_e(World world, int x, int y, int z) {
        return null;
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean func_71886_c() {
        return false;
    }

    public int func_71857_b() {
        return PluginArboriculture.modelIdSaplings;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister register) {
        defaultIcon = TextureManager.getInstance().registerTex(register, "germlings/sapling.treeBalsa");
        for (IAllele allele : AlleleManager.alleleRegistry.getRegisteredAlleles().values()) {
            if (allele instanceof IAlleleTreeSpecies) {
                ((IAlleleTreeSpecies)allele).getIconProvider().registerIcons(register);
            }
            if (!(allele instanceof IAlleleFruit)) continue;
            ((IAlleleFruit)allele).getProvider().registerIcons(register);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int side, int metadata) {
        return defaultIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71895_b(IBlockAccess world, int x, int y, int z, int side) {
        TileSapling sapling = BlockSapling.getSaplingTile(world, x, y, z);
        if (sapling == null) {
            return defaultIcon;
        }
        if (sapling.getTree() == null) {
            return defaultIcon;
        }
        return sapling.getTree().getGenome().getPrimary().getGermlingIcon(EnumGermlingType.SAPLING, 0);
    }

    public boolean func_71854_d(World world, int x, int y, int z) {
        TileSapling tile = BlockSapling.getSaplingTile((IBlockAccess)world, x, y, z);
        if (tile == null) {
            return false;
        }
        if (tile.getTree() == null) {
            return false;
        }
        return tile.getTree().canStay(world, x, y, z);
    }

    public void func_71863_a(World world, int x, int y, int z, int neighbourId) {
        if (Proxies.common.isSimulating(world) && !this.func_71854_d(world, x, y, z)) {
            this.dropAsSapling(world, x, y, z);
            world.func_72832_d(x, y, z, 0, 0, 2);
        }
    }

    public ArrayList getBlockDropped(World world, int x, int y, int z, int metadata, int fortune) {
        return new ArrayList();
    }

    public boolean removeBlockByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        if (Proxies.common.isSimulating(world) && this.canHarvestBlock(player, world.func_72805_g(x, y, z)) && !player.field_71075_bZ.field_75098_d) {
            this.dropAsSapling(world, x, y, z);
        }
        return world.func_72832_d(x, y, z, 0, 0, 2);
    }

    private void dropAsSapling(World world, int x, int y, int z) {
        if (!Proxies.common.isSimulating(world)) {
            return;
        }
        TileSapling sapling = BlockSapling.getSaplingTile((IBlockAccess)world, x, y, z);
        if (sapling != null && sapling.getTree() != null) {
            ItemStack saplingStack = PluginArboriculture.treeInterface.getMemberStack(sapling.getTree(), EnumGermlingType.SAPLING.ordinal());
            StackUtils.dropItemStackAsEntity(saplingStack, world, x, y, z);
        }
    }
}

