/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.worldgen;

import forestry.apiculture.worldgen.WorldGenHive;
import forestry.apiculture.worldgen.WorldGenHiveEnd;
import forestry.apiculture.worldgen.WorldGenHiveForest;
import forestry.apiculture.worldgen.WorldGenHiveJungle;
import forestry.apiculture.worldgen.WorldGenHiveMeadows;
import forestry.apiculture.worldgen.WorldGenHiveParched;
import forestry.apiculture.worldgen.WorldGenHiveSnow;
import forestry.apiculture.worldgen.WorldGenHiveSwamp;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.EnumHelper;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class HiveDecorator {
    public static final PopulateChunkEvent.Populate.EventType EVENT_TYPE = (PopulateChunkEvent.Populate.EventType)EnumHelper.addEnum(PopulateChunkEvent.Populate.EventType.class, (String)"FORESTRY_HIVES", (Class[])new Class[0], (Object[])new Object[0]);
    private static HiveDecorator instance;
    private final WorldGenHiveForest forest = new WorldGenHiveForest();
    private final WorldGenHiveJungle jungle = new WorldGenHiveJungle();
    private final WorldGenHiveMeadows meadows = new WorldGenHiveMeadows();
    private final WorldGenHiveParched parched = new WorldGenHiveParched();
    private final WorldGenHiveEnd end = new WorldGenHiveEnd();
    private final WorldGenHiveSnow snow = new WorldGenHiveSnow();
    private final WorldGenHiveSwamp swamp = new WorldGenHiveSwamp();

    public static HiveDecorator instance() {
        if (instance == null) {
            instance = new HiveDecorator();
        }
        return instance;
    }

    private HiveDecorator() {
    }

    @ForgeSubscribe
    public void generate(PopulateChunkEvent.Post event) {
        if (!TerrainGen.populate((IChunkProvider)event.chunkProvider, (World)event.world, (Random)event.rand, (int)event.chunkX, (int)event.chunkZ, (boolean)event.hasVillageGenerated, (PopulateChunkEvent.Populate.EventType)EVENT_TYPE)) {
            return;
        }
        this.decorateHives(event.world, event.rand, event.chunkX * 16, event.chunkZ * 16);
    }

    private void decorateHives(World world, Random rand, int worldX, int worldZ) {
        this.genHive(world, rand, worldX, worldZ, 42, 3, this.forest);
        this.genHive(world, rand, worldX, worldZ, 62, 4, this.jungle);
        this.genHive(world, rand, worldX, worldZ, 42, 1, this.meadows);
        this.genHive(world, rand, worldX, worldZ, 42, 1, this.parched);
        this.genHive(world, rand, worldX, worldZ, 42, 4, this.end);
        this.genHive(world, rand, worldX, worldZ, 42, 2, this.snow);
        this.genHive(world, rand, worldX, worldZ, 42, 2, this.swamp);
    }

    private void genHive(World world, Random rand, int worldX, int worldZ, int height, int attempts, WorldGenHive gen) {
        for (int i = 0; i < attempts; ++i) {
            int randPosZ;
            int randPosY;
            int randPosX = worldX + rand.nextInt(16);
            if (!gen.func_76484_a(world, rand, randPosX, randPosY = height + rand.nextInt(50), randPosZ = worldZ + rand.nextInt(16))) continue;
            return;
        }
    }
}

