/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader;

import codechicken.chunkloader.TileChunkLoader;
import codechicken.chunkloader.TileChunkLoaderBase;
import codechicken.chunkloader.TileSpotLoader;
import codechicken.core.ClientUtils;
import codechicken.lib.render.CCModelLibrary;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.Collection;
import org.lwjgl.opengl.GL11;

public class TileChunkLoaderRenderer
extends bje {
    public void a(asp tile, double d, double d1, double d2, float f) {
        double size;
        double height;
        CCRenderState.reset();
        CCRenderState.setBrightness((acf)tile.k, (int)tile.l, (int)tile.m, (int)tile.n);
        double rot = ClientUtils.getRenderTime() * 2.0;
        double updown = ClientUtils.getRenderTime() % 50.0 / 25.0;
        updown = (float)Math.sin(updown * 3.141593);
        updown *= 0.2;
        TileChunkLoaderBase chunkLoader = (TileChunkLoaderBase)tile;
        if (chunkLoader instanceof TileChunkLoader) {
            TileChunkLoader ctile = (TileChunkLoader)chunkLoader;
            rot /= Math.pow(ctile.radius, 0.2);
            height = 0.9;
            size = 0.08;
        } else if (chunkLoader instanceof TileSpotLoader) {
            height = 0.5;
            size = 0.05;
        } else {
            return;
        }
        RenderInfo renderInfo = chunkLoader.renderInfo;
        double active = (double)renderInfo.activationCounter / 20.0;
        if (chunkLoader.active && renderInfo.activationCounter < 20) {
            active += (double)f / 20.0;
        } else if (!chunkLoader.active && renderInfo.activationCounter > 0) {
            active -= (double)f / 20.0;
        }
        if (renderInfo.showLasers) {
            GL11.glDisable((int)3553);
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2912);
            this.drawRays(d, d1, d2, rot, updown, tile.l, tile.m, tile.n, chunkLoader.getChunks());
            GL11.glEnable((int)3553);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2912);
        }
        rot = ClientUtils.getRenderTime() * active / 3.0;
        Matrix4 pearlMat = CCModelLibrary.getRenderMatrix((Vector3)new Vector3(d + 0.5, d1 + height + (updown + 0.3) * active, d2 + 0.5), (Rotation)new Rotation(rot, new Vector3(0.0, 1.0, 0.0)), (double)size);
        GL11.glDisable((int)2896);
        CCRenderState.changeTexture((String)"chickenchunks:textures/hedronmap.png");
        CCRenderState.startDrawing((int)4);
        CCModelLibrary.icosahedron4.render((Transformation)pearlMat, null);
        CCRenderState.draw();
        GL11.glEnable((int)2896);
    }

    public Point2D.Double findIntersection(Line2D line1, Line2D line2) {
        double xD1 = line1.getX2() - line1.getX1();
        double yD1 = line1.getY2() - line1.getY1();
        double xD2 = line2.getX2() - line2.getX1();
        double yD2 = line2.getY2() - line2.getY1();
        double xD3 = line1.getX1() - line2.getX1();
        double yD3 = line1.getY1() - line2.getY1();
        Point2D.Double pt = new Point2D.Double(0.0, 0.0);
        double div = yD2 * xD1 - xD2 * yD1;
        if (div == 0.0) {
            return null;
        }
        double ua = (xD2 * yD3 - yD2 * xD3) / div;
        pt.x = line1.getX1() + ua * xD1;
        pt.y = line1.getY1() + ua * yD1;
        if (this.ptOnLineInSegment(pt, line1) && this.ptOnLineInSegment(pt, line2)) {
            return pt;
        }
        return null;
    }

    public boolean ptOnLineInSegment(Point2D point, Line2D line) {
        return point.getX() >= Math.min(line.getX1(), line.getX2()) && point.getX() <= Math.max(line.getX1(), line.getX2()) && point.getY() >= Math.min(line.getY1(), line.getY2()) && point.getY() <= Math.max(line.getY1(), line.getY2());
    }

    public void drawRays(double d, double d1, double d2, double rotationAngle, double updown, int x, int y, int z, Collection<abp> chunkSet) {
        int cx = x >> 4 << 4;
        int cz = z >> 4 << 4;
        GL11.glPushMatrix();
        GL11.glTranslated((double)(d + (double)cx - (double)x + 8.0), (double)(d1 + updown + 2.0), (double)(d2 + (double)cz - (double)z + 8.0));
        GL11.glRotatef((float)((float)rotationAngle), (float)0.0f, (float)1.0f, (float)0.0f);
        double[] distances = new double[4];
        Point2D.Double center = new Point2D.Double(cx + 8, cz + 8);
        int[][] nArrayArray = new int[4][];
        nArrayArray[0] = new int[2];
        int[] nArray = new int[2];
        nArray[0] = 16;
        nArrayArray[1] = nArray;
        nArrayArray[2] = new int[]{16, 16};
        int[] nArray2 = new int[2];
        nArray2[1] = 16;
        nArrayArray[3] = nArray2;
        int[][] coords = nArrayArray;
        Point2D.Double[] absRays = new Point2D.Double[4];
        int ray = 0;
        while (ray < 4) {
            double rayAngle = Math.toRadians(rotationAngle + (double)(90 * ray));
            absRays[ray] = new Point2D.Double(Math.sin(rayAngle), Math.cos(rayAngle));
            ++ray;
        }
        Line2D.Double[] rays = new Line2D.Double[]{new Line2D.Double(center.x, center.y, center.x + 1600.0 * absRays[0].x, center.y + 1600.0 * absRays[0].y), new Line2D.Double(center.x, center.y, center.x + 1600.0 * absRays[1].x, center.y + 1600.0 * absRays[1].y), new Line2D.Double(center.x, center.y, center.x + 1600.0 * absRays[2].x, center.y + 1600.0 * absRays[2].y), new Line2D.Double(center.x, center.y, center.x + 1600.0 * absRays[3].x, center.y + 1600.0 * absRays[3].y)};
        for (abp pair : chunkSet) {
            int chunkBlockX = pair.a << 4;
            int chunkBlockZ = pair.b << 4;
            int side = 0;
            while (side < 4) {
                int[] offset1 = coords[side];
                int[] offset2 = coords[(side + 1) % 4];
                Line2D.Double line1 = new Line2D.Double(chunkBlockX + offset1[0], chunkBlockZ + offset1[1], chunkBlockX + offset2[0], chunkBlockZ + offset2[1]);
                int ray2 = 0;
                while (ray2 < 4) {
                    Point2D.Double isct = this.findIntersection(line1, rays[ray2]);
                    if (isct != null) {
                        isct.setLocation(isct.x - center.x, isct.y - center.y);
                        double lenPow2 = isct.x * isct.x + isct.y * isct.y;
                        if (lenPow2 > distances[ray2]) {
                            distances[ray2] = lenPow2;
                        }
                    }
                    ++ray2;
                }
                ++side;
            }
        }
        GL11.glColor4d((double)0.9, (double)0.0, (double)0.0, (double)1.0);
        int ray3 = 0;
        while (ray3 < 4) {
            distances[ray3] = Math.sqrt(distances[ray3]);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            bgm.a((asx)asx.a((double)0.0, (double)-0.05, (double)-0.05, (double)distances[ray3], (double)0.05, (double)0.05));
            ++ray3;
        }
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)(d + (double)cx - (double)x + 8.0), (double)(d1 - (double)y), (double)(d2 + (double)cz - (double)z + 8.0));
        ray3 = 0;
        while (ray3 < 4) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)(absRays[ray3].x * distances[ray3]), (double)0.0, (double)(absRays[ray3].y * distances[ray3]));
            bgm.a((asx)asx.a((double)-0.05, (double)0.0, (double)-0.05, (double)0.05, (double)256.0, (double)0.05));
            GL11.glPopMatrix();
            ++ray3;
        }
        GL11.glPopMatrix();
        double toCenter = Math.sqrt(((double)cx + 7.5 - (double)x) * ((double)cx + 7.5 - (double)x) + 0.6400000000000001 + ((double)cz + 7.5 - (double)z) * ((double)cz + 7.5 - (double)z));
        GL11.glPushMatrix();
        GL11.glColor4d((double)0.0, (double)0.9, (double)0.0, (double)1.0);
        GL11.glTranslated((double)(d + 0.5), (double)(d1 + 1.2 + updown), (double)(d2 + 0.5));
        GL11.glRotatef((float)((float)(Math.atan2((double)cx + 7.5 - (double)x, (double)cz + 7.5 - (double)z) * 180.0 / 3.1415) + 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)((float)(-Math.asin(0.8 / toCenter) * 180.0 / 3.1415)), (float)0.0f, (float)0.0f, (float)1.0f);
        bgm.a((asx)asx.a((double)(-toCenter), (double)-0.03, (double)-0.03, (double)0.0, (double)0.03, (double)0.03));
        GL11.glPopMatrix();
    }

    public static class RenderInfo {
        int activationCounter;
        boolean showLasers;

        public void update(TileChunkLoaderBase chunkLoader) {
            if (this.activationCounter < 20 && chunkLoader.active) {
                ++this.activationCounter;
            } else if (this.activationCounter > 0 && !chunkLoader.active) {
                --this.activationCounter;
            }
        }
    }
}

