/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader;

import codechicken.chunkloader.ChunkLoaderCPH;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.vec.Vector3;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import net.minecraftforge.common.ForgeChunkManager;

public class PlayerChunkViewer
extends JFrame {
    private HashMap<String, PlayerInfo> players = new HashMap();
    private HashMap<Integer, DimensionChunkInfo> dimensionChunks = new HashMap();
    private int dimension = 0;
    private int xCenter = 0;
    private int zCenter = 0;
    private DisplayArea displayArea;
    private JComboBox<Integer> dimComboBox;
    private JLabel dimLabel;
    private JTextField xArea;
    private JLabel xLabel;
    private JTextField zArea;
    private JLabel zLabel;
    public TicketInfoDialog dialog;
    private static PlayerChunkViewer instance;

    public static void openViewer(int x, int z, int dim) {
        instance = new PlayerChunkViewer(x, z, dim);
    }

    private PlayerChunkViewer(int x, int z, int dim) {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (atv.w().q() != null) {
                    ChunkLoaderCPH.sendGuiClosing();
                }
            }
        });
        this.setLayout(new LayoutManager(){

            @Override
            public void removeLayoutComponent(Component paramComponent) {
            }

            @Override
            public Dimension preferredLayoutSize(Container paramContainer) {
                return new Dimension(500, 500);
            }

            @Override
            public Dimension minimumLayoutSize(Container paramContainer) {
                return null;
            }

            @Override
            public void layoutContainer(Container paramContainer) {
                int width = PlayerChunkViewer.this.getRootPane().getWidth();
                int height = PlayerChunkViewer.this.getRootPane().getHeight();
                PlayerChunkViewer.this.xLabel.setBounds(20, 10, 50, 20);
                PlayerChunkViewer.this.xArea.setBounds(70, 10, 60, 20);
                PlayerChunkViewer.this.zLabel.setBounds(140, 10, 50, 20);
                PlayerChunkViewer.this.zArea.setBounds(190, 10, 60, 20);
                PlayerChunkViewer.this.dimLabel.setBounds(260, 10, 60, 20);
                PlayerChunkViewer.this.dimComboBox.setBounds(330, 10, 70, 20);
                PlayerChunkViewer.this.displayArea.setBounds(0, 40, width, height - 40);
            }

            @Override
            public void addLayoutComponent(String paramString, Component paramComponent) {
            }
        });
        ToolTipManager.sharedInstance().setEnabled(true);
        ToolTipManager.sharedInstance().setInitialDelay(0);
        ToolTipManager.sharedInstance().setReshowDelay(100);
        this.addComponents();
        this.pack();
        this.setTitle("Chunk Viewer");
        Point p = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
        int width = 500;
        int height = 500;
        this.setCenter(x, z);
        this.dimension = dim;
        this.setBounds(p.x - width / 2, p.y - height / 2, width, height);
        this.setBackground(new Color(1.0f, 1.0f, 1.0f));
        this.setVisible(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PlayerChunkViewer.this.startUpdateThread();
            }
        });
    }

    protected void startUpdateThread() {
        new Thread("Info Frame Update Thread"){

            @Override
            public void run() {
                while (true) {
                    if (atv.w().n instanceof blt) {
                        PlayerChunkViewer.this.dispose();
                    }
                    if (instance == null || !PlayerChunkViewer.this.isVisible()) {
                        return;
                    }
                    PlayerChunkViewer.this.update();
                    if (PlayerChunkViewer.this.dialog != null) {
                        PlayerChunkViewer.this.dialog.update();
                    }
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        }.start();
    }

    protected void update() {
        int selectedDim = this.dimension;
        boolean needsReset = false;
        LinkedList<Integer> dims = new LinkedList<Integer>(this.dimensionChunks.keySet());
        Collections.sort(dims);
        if (dims.size() != this.dimComboBox.getItemCount()) {
            needsReset = true;
        } else {
            int index = 0;
            while (index < this.dimComboBox.getItemCount()) {
                if (dims.get(index) != this.dimComboBox.getItemAt(index)) {
                    needsReset = true;
                    break;
                }
                ++index;
            }
        }
        if (needsReset) {
            this.dimComboBox.removeAllItems();
            dims = new LinkedList<Integer>(this.dimensionChunks.keySet());
            Collections.sort(dims);
            Iterator iterator = dims.iterator();
            while (iterator.hasNext()) {
                int dim = (Integer)iterator.next();
                this.dimComboBox.addItem(dim);
            }
            if (dims.contains(selectedDim)) {
                this.dimComboBox.setSelectedItem(selectedDim);
            }
        }
        this.repaint();
    }

    private void addComponents() {
        this.add(this.getDisplayArea());
        this.add(this.getXLabel());
        this.add(this.getXArea());
        this.add(this.getZLabel());
        this.add(this.getZArea());
        this.add(this.getDimLabel());
        this.add(this.getDimComboBox());
    }

    public DisplayArea getDisplayArea() {
        if (this.displayArea == null) {
            this.displayArea = new DisplayArea();
            this.displayArea.addMouseListener(this.displayArea);
            this.displayArea.addMouseMotionListener(this.displayArea);
        }
        return this.displayArea;
    }

    public JLabel getXLabel() {
        if (this.xLabel == null) {
            this.xLabel = new JLabel("xCenter");
        }
        return this.xLabel;
    }

    public JTextField getXArea() {
        if (this.xArea == null) {
            this.xArea = new JTextField();
            this.xArea.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        Integer i = Integer.parseInt(PlayerChunkViewer.this.xArea.getText());
                        if (i != null) {
                            PlayerChunkViewer.this.setCenter(i, PlayerChunkViewer.this.zCenter);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            });
        }
        return this.xArea;
    }

    public JLabel getZLabel() {
        if (this.zLabel == null) {
            this.zLabel = new JLabel("zCenter");
        }
        return this.zLabel;
    }

    public JTextField getZArea() {
        if (this.zArea == null) {
            this.zArea = new JTextField();
            this.zArea.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        Integer i = Integer.parseInt(PlayerChunkViewer.this.zArea.getText());
                        if (i != null) {
                            PlayerChunkViewer.this.setCenter(PlayerChunkViewer.this.xCenter, i);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            });
        }
        return this.zArea;
    }

    public JLabel getDimLabel() {
        if (this.dimLabel == null) {
            this.dimLabel = new JLabel("Dimension");
        }
        return this.dimLabel;
    }

    public JComboBox<Integer> getDimComboBox() {
        if (this.dimComboBox == null) {
            this.dimComboBox = new JComboBox();
            this.dimComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getActionCommand().equals("comboBoxChanged") && PlayerChunkViewer.this.dimComboBox.getSelectedItem() != null) {
                        PlayerChunkViewer.this.dimension = (Integer)PlayerChunkViewer.this.dimComboBox.getSelectedItem();
                    }
                }
            });
        }
        return this.dimComboBox;
    }

    public static PlayerChunkViewer instance() {
        return instance;
    }

    public void setCenter(int blockX, int blockZ) {
        this.xArea.setText(Integer.toString(blockX));
        this.xCenter = blockX;
        this.zArea.setText(Integer.toString(blockZ));
        this.zCenter = blockZ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadDimension(PacketCustom packet, bdd world) {
        HashMap<Integer, DimensionChunkInfo> hashMap = this.dimensionChunks;
        synchronized (hashMap) {
            DimensionChunkInfo dimInfo = new DimensionChunkInfo(packet.readInt());
            int numChunks = packet.readInt();
            int i = 0;
            while (i < numChunks) {
                dimInfo.allchunks.add(new abp(packet.readInt(), packet.readInt()));
                ++i;
            }
            int numTickets = packet.readInt();
            int i2 = 0;
            while (i2 < numTickets) {
                TicketInfo ticket = new TicketInfo(packet, world);
                dimInfo.tickets.put(ticket.ID, ticket);
                ++i2;
            }
            this.dimensionChunks.put(dimInfo.dimension, dimInfo);
        }
    }

    public void unloadDimension(int dim) {
        this.dimensionChunks.remove(dim);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleChunkChange(int dimension, abp coord, boolean add) {
        HashMap<Integer, DimensionChunkInfo> hashMap = this.dimensionChunks;
        synchronized (hashMap) {
            if (add) {
                this.dimensionChunks.get((Object)Integer.valueOf((int)dimension)).allchunks.add(coord);
            } else {
                this.dimensionChunks.get((Object)Integer.valueOf((int)dimension)).allchunks.remove(coord);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleTicketChange(int dimension, int ticketID, abp coord, boolean force) {
        HashMap<Integer, DimensionChunkInfo> hashMap = this.dimensionChunks;
        synchronized (hashMap) {
            DimensionChunkInfo dimInfo = this.dimensionChunks.get(dimension);
            TicketInfo ticket = dimInfo.tickets.get(ticketID);
            if (force) {
                ticket.chunkSet.add(coord);
            } else {
                ticket.chunkSet.remove(coord);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNewTicket(PacketCustom packet, bdd world) {
        HashMap<Integer, DimensionChunkInfo> hashMap = this.dimensionChunks;
        synchronized (hashMap) {
            int dim = packet.readInt();
            TicketInfo ticket = new TicketInfo(packet, world);
            this.dimensionChunks.get((Object)Integer.valueOf((int)dim)).tickets.put(ticket.ID, ticket);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handlePlayerUpdate(String username, int dimension, Vector3 position) {
        HashMap<Integer, DimensionChunkInfo> hashMap = this.dimensionChunks;
        synchronized (hashMap) {
            PlayerInfo info = this.players.get(username);
            if (info == null) {
                info = new PlayerInfo(username);
                this.players.put(username, info);
            }
            info.dimension = dimension;
            info.position = position;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePlayer(String username) {
        HashMap<Integer, DimensionChunkInfo> hashMap = this.dimensionChunks;
        synchronized (hashMap) {
            this.players.remove(username);
        }
    }

    public static class DimensionChunkInfo {
        public final int dimension;
        public HashSet<abp> allchunks = new HashSet();
        public HashMap<Integer, TicketInfo> tickets = new HashMap();

        public DimensionChunkInfo(int dim) {
            this.dimension = dim;
        }
    }

    public class DisplayArea
    extends JPanel
    implements MouseListener,
    MouseMotionListener {
        int mouseClickedX;
        int centerClickedX;
        int mouseClickedY;
        int centerClickedZ;
        Point center;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint(Graphics g1) {
            HashMap hashMap = PlayerChunkViewer.this.dimensionChunks;
            synchronized (hashMap) {
                Object pos;
                Graphics2D g = (Graphics2D)g1;
                Dimension dim = this.getSize();
                g.clearRect(0, 0, dim.width, dim.height);
                this.center = new Point(dim.width / 2, dim.height / 2);
                DimensionChunkInfo dimInfo = (DimensionChunkInfo)PlayerChunkViewer.this.dimensionChunks.get(PlayerChunkViewer.this.dimension);
                if (dimInfo == null) {
                    PlayerChunkViewer.this.dimension = 0;
                    return;
                }
                g.setColor(new Color(1.0f, 0.0f, 0.0f));
                for (abp coord : dimInfo.allchunks) {
                    Point pos2 = this.getChunkRenderPosition(coord.a, coord.b);
                    g.fillRect(pos2.x, pos2.y, 4, 4);
                }
                HashSet<abp> forcedChunks = new HashSet<abp>();
                int numTickets = 0;
                for (TicketInfo ticket : dimInfo.tickets.values()) {
                    if (!ticket.chunkSet.isEmpty()) {
                        ++numTickets;
                    }
                    for (abp coord : ticket.chunkSet) {
                        forcedChunks.add(coord);
                    }
                }
                g.setColor(new Color(0.0f, 1.0f, 0.0f));
                for (abp coord : forcedChunks) {
                    pos = this.getChunkRenderPosition(coord.a, coord.b);
                    g.fillRect(((Point)pos).x + 1, ((Point)pos).y + 1, 2, 2);
                }
                int numPlayers = 0;
                g.setColor(new Color(0.0f, 0.0f, 1.0f));
                for (PlayerInfo info : PlayerChunkViewer.this.players.values()) {
                    if (info.dimension != PlayerChunkViewer.this.dimension) continue;
                    Point pos3 = this.getChunkRenderPosition((int)info.position.x, 0, (int)info.position.z);
                    g.fillRect(pos3.x + 1, pos3.y + 1, 2, 2);
                    ++numPlayers;
                }
                g.setColor(new Color(0, 0, 0));
                int x = (PlayerChunkViewer.this.xCenter >> 4) - (this.center.x >> 2) - 2;
                while (x < (PlayerChunkViewer.this.xCenter >> 4) + (this.center.x >> 2) + 2) {
                    if (x % 16 == 0) {
                        pos = this.getChunkRenderPosition(x, PlayerChunkViewer.this.zCenter + 128 >> 8 << 4);
                        g.drawLine(((Point)pos).x, 0, ((Point)pos).x, dim.height);
                        g.drawString(Integer.toString(x << 4), ((Point)pos).x + 2, ((Point)pos).y + 12);
                    }
                    ++x;
                }
                int z = (PlayerChunkViewer.this.zCenter >> 4) - (this.center.y >> 2) - 2;
                while (z < (PlayerChunkViewer.this.zCenter >> 4) + (this.center.y >> 2) + 2) {
                    if (z % 16 == 0) {
                        pos = this.getChunkRenderPosition(PlayerChunkViewer.this.xCenter + 128 >> 8 << 4, z);
                        g.drawLine(0, ((Point)pos).y, dim.width, ((Point)pos).y);
                        g.drawString(Integer.toString(z << 4), ((Point)pos).x + 2, ((Point)pos).y - 2);
                    }
                    ++z;
                }
                g.setColor(new Color(1.0f, 1.0f, 1.0f));
                g.fillRect(0, 0, 100, 60);
                g.setColor(new Color(0, 0, 0));
                g.drawString("Tickets: " + numTickets, 10, 20);
                g.drawString("Forced Chunks: " + forcedChunks.size(), 10, 30);
                g.drawString("Chunks: " + dimInfo.allchunks.size(), 10, 40);
                g.drawString("Players: " + numPlayers, 10, 50);
            }
        }

        public Point getChunkRenderPosition(int chunkX, int chunkZ) {
            int relBlockX = (chunkX << 4) + 8 - PlayerChunkViewer.this.xCenter;
            int relBlockZ = (chunkZ << 4) + 8 - PlayerChunkViewer.this.zCenter;
            return new Point(this.center.x + (relBlockX >> 2), this.center.y + (relBlockZ >> 2));
        }

        public Point getChunkRenderPosition(int blockX, int blockY, int blockZ) {
            return this.getChunkRenderPosition(blockX >> 4, blockZ >> 4);
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            if (event.getButton() != 1 || event.getClickCount() < 2) {
                return;
            }
            Point mouse = event.getPoint();
            DimensionChunkInfo dimInfo = (DimensionChunkInfo)PlayerChunkViewer.this.dimensionChunks.get(PlayerChunkViewer.this.dimension);
            if (dimInfo == null) {
                PlayerChunkViewer.this.dimension = 0;
                return;
            }
            LinkedList<TicketInfo> mouseOverTickets = this.getTicketsUnderMouse(dimInfo, mouse);
            if (!mouseOverTickets.isEmpty()) {
                new TicketInfoDialog(mouseOverTickets);
            }
        }

        @Override
        public void mousePressed(MouseEvent event) {
            this.mouseClickedX = event.getX();
            this.centerClickedX = PlayerChunkViewer.this.xCenter;
            this.mouseClickedY = event.getY();
            this.centerClickedZ = PlayerChunkViewer.this.zCenter;
        }

        @Override
        public void mouseReleased(MouseEvent event) {
        }

        @Override
        public void mouseEntered(MouseEvent event) {
        }

        @Override
        public void mouseExited(MouseEvent event) {
        }

        @Override
        public void mouseDragged(MouseEvent event) {
            PlayerChunkViewer.this.setCenter((this.mouseClickedX - event.getX()) * 4 + this.centerClickedX, (this.mouseClickedY - event.getY()) * 4 + this.centerClickedZ);
        }

        public LinkedList<TicketInfo> getTicketsUnderMouse(DimensionChunkInfo dimInfo, Point mouse) {
            LinkedList<TicketInfo> mouseOverTickets = new LinkedList<TicketInfo>();
            for (TicketInfo ticket : dimInfo.tickets.values()) {
                for (abp coord : ticket.chunkSet) {
                    Point pos = this.getChunkRenderPosition(coord.a, coord.b);
                    if (!new Rectangle(pos.x, pos.y, 4, 4).contains(mouse)) continue;
                    mouseOverTickets.add(ticket);
                }
            }
            return mouseOverTickets;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseMoved(MouseEvent event) {
            HashMap hashMap = PlayerChunkViewer.this.dimensionChunks;
            synchronized (hashMap) {
                Point mouse = event.getPoint();
                DimensionChunkInfo dimInfo = (DimensionChunkInfo)PlayerChunkViewer.this.dimensionChunks.get(PlayerChunkViewer.this.dimension);
                if (dimInfo == null) {
                    PlayerChunkViewer.this.dimension = 0;
                    return;
                }
                String tip = "";
                LinkedList<TicketInfo> mouseOverTickets = this.getTicketsUnderMouse(dimInfo, mouse);
                if (!mouseOverTickets.isEmpty()) {
                    tip = String.valueOf(tip) + mouseOverTickets.size() + (mouseOverTickets.size() == 1 ? " ticket" : " tickets");
                    for (TicketInfo ticketInfo : mouseOverTickets) {
                        tip = String.valueOf(tip) + "\n" + ticketInfo.modId;
                        if (ticketInfo.player == null) continue;
                        tip = String.valueOf(tip) + ", " + ticketInfo.player;
                    }
                }
                for (PlayerInfo playerInfo : PlayerChunkViewer.this.players.values()) {
                    if (playerInfo.dimension != PlayerChunkViewer.this.dimension) continue;
                    Point pos = this.getChunkRenderPosition((int)playerInfo.position.x, 0, (int)playerInfo.position.z);
                    if (!new Rectangle(pos.x, pos.y, 4, 4).contains(mouse)) continue;
                    tip = String.valueOf(tip) + "\n\n" + playerInfo.username + "\n(" + String.format("%.2f", playerInfo.position.x) + ", " + String.format("%.2f", playerInfo.position.y) + ", " + String.format("%.2f", playerInfo.position.z) + ")";
                }
                this.setToolTipText(tip.length() > 0 ? tip : null);
            }
        }

        @Override
        public void setToolTipText(String paramString) {
            if (paramString == null) {
                super.setToolTipText(paramString);
            } else {
                super.setToolTipText("<html>" + paramString.replace("\n", "<br>") + "</html>");
            }
        }
    }

    public static class PlayerInfo {
        final String username;
        Vector3 position;
        int dimension;

        public PlayerInfo(String username2) {
            this.username = username2;
        }
    }

    public static class TicketInfo {
        int ID;
        String modId;
        String player;
        ForgeChunkManager.Type type;
        nn entity;
        Set<abp> chunkSet;

        public TicketInfo(PacketCustom packet, bdd world) {
            this.ID = packet.readInt();
            this.modId = packet.readString();
            if (packet.readBoolean()) {
                this.player = packet.readString();
            }
            this.type = ForgeChunkManager.Type.values()[packet.readUByte()];
            if (this.type == ForgeChunkManager.Type.ENTITY) {
                this.entity = world.a(packet.readInt());
            }
            int chunks = packet.readUShort();
            this.chunkSet = new HashSet<abp>(chunks);
            int i = 0;
            while (i < chunks) {
                this.chunkSet.add(new abp(packet.readInt(), packet.readInt()));
                ++i;
            }
        }
    }

    public class TicketInfoDialog
    extends JDialog
    implements LayoutManager {
        private LinkedList<TicketInfo> tickets;
        private JTextPane infoPane;
        private JScrollPane infoScrollPane;
        private JTextPane chunkPane;
        private JScrollPane chunkScrollPane;
        private JComboBox<String> ticketComboBox;

        public TicketInfoDialog(LinkedList<TicketInfo> tickets) {
            super(PlayerChunkViewer.this);
            this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
            this.tickets = tickets;
            this.infoPane = new JTextPane();
            this.infoPane.setEditable(false);
            this.infoPane.setOpaque(false);
            this.infoPane.setContentType("text/html");
            this.infoScrollPane = new JScrollPane(this.infoPane);
            this.infoScrollPane.setOpaque(false);
            this.add(this.infoScrollPane);
            this.chunkPane = new JTextPane();
            this.chunkPane.setEditable(false);
            this.chunkPane.setOpaque(false);
            this.chunkPane.setContentType("text/html");
            this.chunkScrollPane = new JScrollPane(this.chunkPane, 20, 31);
            this.add(this.chunkScrollPane);
            this.ticketComboBox = new JComboBox();
            for (TicketInfo ticket : tickets) {
                String ident = ticket.modId;
                if (ticket.player != null) {
                    ident = String.valueOf(ident) + ", " + ticket.player;
                }
                ident = String.valueOf(ident) + " #" + ticket.ID;
                this.ticketComboBox.addItem(ident);
            }
            this.add(this.ticketComboBox);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    ((TicketInfoDialog)TicketInfoDialog.this).PlayerChunkViewer.this.dialog = null;
                }
            });
            this.setLayout(this);
            this.setSize(this.getPreferredSize());
            this.setLocationRelativeTo(null);
            this.pack();
            PlayerChunkViewer.this.dialog = this;
            this.setVisible(true);
        }

        public void update() {
            TicketInfo ticket = this.tickets.get(this.ticketComboBox.getSelectedIndex());
            String info = "<span style=\"font-family:Tahoma; font-size:10px\">";
            info = String.valueOf(info) + "Mod: " + ticket.modId;
            if (ticket.player != null) {
                info = String.valueOf(info) + "<br>Player: " + ticket.player;
            }
            info = String.valueOf(info) + "<br>Type: " + ticket.type.name();
            if (ticket.entity != null) {
                info = String.valueOf(info) + "<br>Entity: " + nt.c.get(ticket.entity) + "#" + ticket.entity.k + " (" + String.format("%.2f", ticket.entity.u) + ", " + String.format("%.2f", ticket.entity.v) + ", " + String.format("%.2f", ticket.entity.w) + ")";
            }
            info = String.valueOf(info) + "</span><p style=\"text-align:center; font-family:Tahoma; font-size:10px\">ForcedChunks</p>";
            String chunks = "<span style=\"font-family:Tahoma; font-size:10px\">";
            for (abp coord : ticket.chunkSet) {
                chunks = String.valueOf(chunks) + coord.a + ", " + coord.b + "<br>";
            }
            chunks = String.valueOf(chunks) + "</span>";
            this.infoPane.setText(info);
            this.chunkPane.setText(chunks);
            this.repaint();
        }

        @Override
        public void layoutContainer(Container parent) {
            Dimension size = parent.getSize();
            this.ticketComboBox.setBounds(40, 20, size.width - 80, 20);
            int w = size.width - 40;
            int y = 60;
            this.infoPane.setBounds(5, 5, w - 10, 5);
            this.chunkPane.setBounds(5, 5, w - 10, 5);
            this.infoScrollPane.setBounds(20, y, w, Math.min(size.height - 80, this.infoPane.getPreferredSize().height + 10));
            this.chunkScrollPane.setBounds(20, y += 10 + this.infoScrollPane.getHeight(), w, Math.max(0, size.height - 40 - y));
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return new Dimension(250, 300);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(250, 300);
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }
    }
}

