/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader;

import codechicken.lib.lang.LangUtil;
import java.util.HashSet;

public enum ChunkLoaderShape {
    Square("square"),
    Circle("circle"),
    LineX("linex"),
    LineZ("linez");

    String name;

    private ChunkLoaderShape(String s) {
        this.name = s;
    }

    public HashSet<abp> getChunks(int radius, abp center) {
        HashSet<abp> chunkset = new HashSet<abp>();
        --radius;
        switch (this) {
            case Square: {
                int x = center.a - radius;
                while (x <= center.a + radius) {
                    int z = center.b - radius;
                    while (z <= center.b + radius) {
                        chunkset.add(new abp(x, z));
                        ++z;
                    }
                    ++x;
                }
                break;
            }
            case LineX: {
                int x = center.a - radius;
                while (x <= center.a + radius) {
                    chunkset.add(new abp(x, center.b));
                    ++x;
                }
                break;
            }
            case LineZ: {
                int z = center.b - radius;
                while (z <= center.b + radius) {
                    chunkset.add(new abp(center.a, z));
                    ++z;
                }
                break;
            }
            case Circle: {
                int x = center.a - radius;
                while (x <= center.a + radius) {
                    int z = center.b - radius;
                    while (z <= center.b + radius) {
                        int relx = x - center.a;
                        int relz = z - center.b;
                        double dist = Math.sqrt(relx * relx + relz * relz);
                        if (dist <= (double)radius) {
                            chunkset.add(new abp(x, z));
                        }
                        ++z;
                    }
                    ++x;
                }
                break;
            }
        }
        return chunkset;
    }

    public ChunkLoaderShape next() {
        int index = this.ordinal();
        if (++index == ChunkLoaderShape.values().length) {
            index = 0;
        }
        return ChunkLoaderShape.values()[index];
    }

    public ChunkLoaderShape prev() {
        int index = this.ordinal();
        if (--index == -1) {
            index = ChunkLoaderShape.values().length - 1;
        }
        return ChunkLoaderShape.values()[index];
    }

    public HashSet<abp> getLoadedChunks(int chunkx, int chunkz, int radius) {
        HashSet<abp> chunkSet = new HashSet<abp>();
        switch (this) {
            case Square: {
                int cx = chunkx - radius;
                while (cx <= chunkx + radius) {
                    int cz = chunkz - radius;
                    while (cz <= chunkz + radius) {
                        chunkSet.add(new abp(cx, cz));
                        ++cz;
                    }
                    ++cx;
                }
                break;
            }
            case LineX: {
                int cx = chunkx - radius;
                while (cx <= chunkx + radius) {
                    chunkSet.add(new abp(cx, chunkz));
                    ++cx;
                }
                break;
            }
            case LineZ: {
                int cz = chunkz - radius;
                while (cz <= chunkz + radius) {
                    chunkSet.add(new abp(chunkx, cz));
                    ++cz;
                }
                break;
            }
            case Circle: {
                int cx = chunkx - radius;
                while (cx <= chunkx + radius) {
                    int cz = chunkz - radius;
                    while (cz <= chunkz + radius) {
                        double distSquared = (cx - chunkx) * (cx - chunkx) + (cz - chunkz) * (cz - chunkz);
                        if (distSquared <= (double)(radius * radius)) {
                            chunkSet.add(new abp(cx, cz));
                        }
                        ++cz;
                    }
                    ++cx;
                }
                break;
            }
        }
        return chunkSet;
    }

    public String getName() {
        return LangUtil.translateG((String)("chickenchunks.shape." + this.name), (Object[])new Object[0]);
    }
}

