/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.client.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.Icon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import tconstruct.blocks.component.SmelteryComponent;
import tconstruct.blocks.logic.AdaptiveSmelteryLogic;
import tconstruct.client.gui.NewContainerGui;
import tconstruct.inventory.ActiveContainer;
import tconstruct.inventory.AdaptiveSmelteryContainer;
import tconstruct.library.component.MultiFluidTank;

public class AdaptiveSmelteryGui
extends NewContainerGui {
    public AdaptiveSmelteryLogic logic;
    String username;
    boolean isScrolling = false;
    boolean wasClicking;
    float currentScroll = 0.0f;
    int slotPos = 0;
    int prevSlotPos = 0;
    private final SmelteryComponent scomp;
    private final MultiFluidTank multitank;
    private static final ResourceLocation background = new ResourceLocation("tinker", "textures/gui/smeltery.png");
    private static final ResourceLocation backgroundSide = new ResourceLocation("tinker", "textures/gui/smelteryside.png");
    private static final ResourceLocation terrain = new ResourceLocation("terrain.png");

    public AdaptiveSmelteryGui(InventoryPlayer inventoryplayer, AdaptiveSmelteryLogic smeltery, World world, int x, int y, int z) {
        super((ActiveContainer)smeltery.getGuiContainer(inventoryplayer, world, x, y, z));
        this.logic = smeltery;
        this.username = inventoryplayer.field_70458_d.field_71092_bJ;
        this.xSize = 248;
        this.scomp = this.logic.getSmeltery();
        this.multitank = this.logic.getMultiTank();
        this.scomp.update();
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float par3) {
        super.func_73863_a(mouseX, mouseY, par3);
        this.updateScrollbar(mouseX, mouseY, par3);
    }

    protected void updateScrollbar(int mouseX, int mouseY, float par3) {
        if (this.logic.func_70302_i_() > 24) {
            boolean mouseDown = Mouse.isButtonDown((int)0);
            int lefto = this.guiLeft;
            int topo = this.guiTop;
            int xScroll = lefto + 67;
            int yScroll = topo + 8;
            int scrollWidth = xScroll + 14;
            int scrollHeight = yScroll + 144;
            if (!this.wasClicking && mouseDown && mouseX >= xScroll && mouseY >= yScroll && mouseX < scrollWidth && mouseY < scrollHeight) {
                this.isScrolling = true;
            }
            if (!mouseDown) {
                this.isScrolling = false;
            }
            if (this.wasClicking && !this.isScrolling && this.slotPos != this.prevSlotPos) {
                this.prevSlotPos = this.slotPos;
            }
            this.wasClicking = mouseDown;
            if (this.isScrolling) {
                int s;
                this.currentScroll = ((float)(mouseY - yScroll) - 7.5f) / ((float)(scrollHeight - yScroll) - 15.0f);
                if (this.currentScroll < 0.0f) {
                    this.currentScroll = 0.0f;
                }
                if (this.currentScroll > 1.0f) {
                    this.currentScroll = 1.0f;
                }
                if ((s = ((AdaptiveSmelteryContainer)this.container).scrollTo(this.currentScroll)) != -1) {
                    this.slotPos = s;
                }
            }
        }
    }

    @Override
    protected void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        FluidStack liquid;
        int i;
        this.field_73886_k.func_78276_b(StatCollector.func_74838_a((String)"crafters.Smeltery"), 86, 5, 0x404040);
        this.field_73886_k.func_78276_b(StatCollector.func_74838_a((String)"container.inventory"), 90, this.ySize - 96 + 2, 0x404040);
        int base = 0;
        int cornerX = (this.field_73880_f - this.xSize) / 2 + 36;
        int cornerY = (this.field_73881_g - this.ySize) / 2;
        FluidTankInfo[] info = this.logic.getTankInfo(ForgeDirection.UNKNOWN);
        int capacity = 0;
        for (i = 0; i < info.length - 1; ++i) {
            liquid = info[i].fluid;
            if (liquid == null) continue;
            capacity += info[i].capacity;
        }
        for (i = 0; i < info.length - 1; ++i) {
            liquid = info[i].fluid;
            int basePos = 54;
            boolean initialLiquidSize = false;
            int liquidSize = 0;
            if (capacity > 0) {
                liquidSize = liquid.amount * 52 / capacity;
                if (liquidSize == 0) {
                    liquidSize = 1;
                }
                base += liquidSize;
            }
            int leftX = cornerX + basePos;
            int topY = cornerY + 68 - base;
            int sizeX = 52;
            int sizeY = liquidSize;
            if (mouseX < leftX || mouseX > leftX + sizeX || mouseY < topY || mouseY >= topY + sizeY) continue;
            this.drawFluidStackTooltip(liquid, mouseX - cornerX + 36, mouseY - cornerY);
        }
        if (this.scomp.fuelGague > 0) {
            int leftX = cornerX + 117;
            int topY = cornerY + 68 - this.scomp.getScaledFuelGague(52);
            int sizeX = 12;
            int sizeY = this.scomp.getScaledFuelGague(52);
            if (mouseX >= leftX && mouseX <= leftX + sizeX && mouseY >= topY && mouseY < topY + sizeY) {
                this.drawFluidStackTooltip(new FluidStack(-37, this.scomp.fuelAmount), mouseX - cornerX + 36, mouseY - cornerY);
            }
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float f, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73882_e.func_110434_K().func_110577_a(background);
        int cornerX = (this.field_73880_f - this.xSize) / 2 + 36;
        int cornerY = (this.field_73881_g - this.ySize) / 2;
        this.func_73729_b(cornerX + 46, cornerY, 0, 0, 176, this.ySize);
        this.field_73882_e.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        if (this.scomp.fuelGague > 0) {
            Icon lavaIcon = Block.field_71938_D.func_71858_a(0, 0);
            int fuel = this.scomp.getScaledFuelGague(52);
            int count = 0;
            while (fuel > 0) {
                int size = fuel >= 16 ? 16 : fuel;
                fuel -= size;
                this.drawLiquidRect(cornerX + 117, cornerY + 68 - size - 16 * count, lavaIcon, 12, size);
                ++count;
            }
        }
        FluidTankInfo[] info = this.logic.getTankInfo(ForgeDirection.UNKNOWN);
        int capacity = 0;
        for (int i = 0; i < info.length - 1; ++i) {
            FluidStack liquid = info[i].fluid;
            if (liquid == null) continue;
            capacity += info[i].capacity;
        }
        int base = 0;
        for (int i = 0; i < info.length - 1; ++i) {
            FluidStack liquid = info[i].fluid;
            Icon renderIndex = liquid.getFluid().getStillIcon();
            int basePos = 54;
            if (capacity <= 0) continue;
            int liquidSize = liquid.amount * 52 / capacity;
            if (liquidSize == 0) {
                liquidSize = 1;
            }
            while (liquidSize > 0) {
                int size = liquidSize >= 16 ? 16 : liquidSize;
                this.drawLiquidRect(cornerX + basePos, cornerY + 68 - size - base, renderIndex, 16, size);
                this.drawLiquidRect(cornerX + basePos + 16, cornerY + 68 - size - base, renderIndex, 16, size);
                this.drawLiquidRect(cornerX + basePos + 32, cornerY + 68 - size - base, renderIndex, 16, size);
                this.drawLiquidRect(cornerX + basePos + 48, cornerY + 68 - size - base, renderIndex, 4, size);
                liquidSize -= size;
                base += size;
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73882_e.func_110434_K().func_110577_a(background);
        this.func_73729_b(cornerX + 54, cornerY + 16, 176, 76, 52, 52);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73882_e.func_110434_K().func_110577_a(backgroundSide);
        this.func_73729_b(cornerX - 46, cornerY, 0, 0, 98, this.ySize - 8);
        this.func_73729_b(cornerX + 32, (int)((float)(cornerY + 8) + 127.0f * this.currentScroll), 98, 0, 12, 15);
        int slotSize = this.logic.func_70302_i_();
        if (slotSize > 24) {
            slotSize = 24;
        }
        for (int iter = 0; iter < slotSize; ++iter) {
            int slotTemp = this.logic.getTempForSlot(iter + this.slotPos * 3) - 20;
            int maxTemp = this.logic.getMeltingPointForSlot(iter + this.slotPos * 3) - 20;
            if (slotTemp <= 0 || maxTemp <= 0) continue;
            int size = 16 * slotTemp / maxTemp + 1;
            this.func_73729_b(cornerX - 38 + iter % 3 * 22, cornerY + 8 + iter / 3 * 18 + 16 - size, 98, 31 - size, 5, size);
        }
    }

    protected void drawFluidStackTooltip(FluidStack par1ItemStack, int par2, int par3) {
        this.field_73735_i = 100.0f;
        List list = this.getLiquidTooltip(par1ItemStack, this.field_73882_e.field_71474_y.field_82882_x);
        for (int k = 0; k < list.size(); ++k) {
            list.set(k, EnumChatFormatting.GRAY + (String)list.get(k));
        }
        this.drawToolTip(list, par2, par3);
        this.field_73735_i = 0.0f;
    }

    public List getLiquidTooltip(FluidStack liquid, boolean par2) {
        ArrayList<String> list = new ArrayList<String>();
        if (liquid.fluidID == -37) {
            list.add("\u00a7fFuel");
            list.add("mB: " + liquid.amount);
        } else {
            String name = StatCollector.func_74838_a((String)FluidRegistry.getFluidName((FluidStack)liquid));
            list.add("\u00a7f" + name);
            if (name.equals("liquified emerald")) {
                list.add("Emeralds: " + (float)liquid.amount / 320.0f);
            } else if (name.contains("Molten")) {
                int mB;
                int ingots = liquid.amount / 144;
                if (ingots > 0) {
                    list.add("Ingots: " + ingots);
                }
                if ((mB = liquid.amount % 144) > 0) {
                    int nuggets = mB / 16;
                    int junk = mB % 16;
                    if (nuggets > 0) {
                        list.add("Nuggets: " + nuggets);
                    }
                    if (junk > 0) {
                        list.add("mB: " + junk);
                    }
                }
            } else if (name.equals("Seared Stone")) {
                int mB;
                int ingots = liquid.amount / 144;
                if (ingots > 0) {
                    list.add("Blocks: " + ingots);
                }
                if ((mB = liquid.amount % 144) > 0) {
                    list.add("mB: " + mB);
                }
            } else if (name.equals("Molten Glass")) {
                int mB;
                int panels;
                int blocks = liquid.amount / 1000;
                if (blocks > 0) {
                    list.add("Blocks: " + blocks);
                }
                if ((panels = liquid.amount % 1000 / 250) > 0) {
                    list.add("Panels: " + panels);
                }
                if ((mB = liquid.amount % 1000 % 250) > 0) {
                    list.add("mB: " + mB);
                }
            } else {
                list.add("mB: " + liquid.amount);
            }
        }
        return list;
    }

    protected void drawToolTip(List par1List, int par2, int par3) {
        if (!par1List.isEmpty()) {
            GL11.glDisable((int)32826);
            RenderHelper.func_74518_a();
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            int k = 0;
            for (String s : par1List) {
                int l = this.field_73886_k.func_78256_a(s);
                if (l <= k) continue;
                k = l;
            }
            int i1 = par2 + 12;
            int j1 = par3 - 12;
            int k1 = 8;
            if (par1List.size() > 1) {
                k1 += 2 + (par1List.size() - 1) * 10;
            }
            if (i1 + k > this.field_73880_f) {
                i1 -= 28 + k;
            }
            if (j1 + k1 + 6 > this.field_73881_g) {
                j1 = this.field_73881_g - k1 - 6;
            }
            this.field_73735_i = 300.0f;
            AdaptiveSmelteryGui.itemRenderer.field_77023_b = 300.0f;
            int l1 = -267386864;
            this.func_73733_a(i1 - 3, j1 - 4, i1 + k + 3, j1 - 3, l1, l1);
            this.func_73733_a(i1 - 3, j1 + k1 + 3, i1 + k + 3, j1 + k1 + 4, l1, l1);
            this.func_73733_a(i1 - 3, j1 - 3, i1 + k + 3, j1 + k1 + 3, l1, l1);
            this.func_73733_a(i1 - 4, j1 - 3, i1 - 3, j1 + k1 + 3, l1, l1);
            this.func_73733_a(i1 + k + 3, j1 - 3, i1 + k + 4, j1 + k1 + 3, l1, l1);
            int i2 = 0x505000FF;
            int j2 = (i2 & 0xFEFEFE) >> 1 | i2 & 0xFF000000;
            this.func_73733_a(i1 - 3, j1 - 3 + 1, i1 - 3 + 1, j1 + k1 + 3 - 1, i2, j2);
            this.func_73733_a(i1 + k + 2, j1 - 3 + 1, i1 + k + 3, j1 + k1 + 3 - 1, i2, j2);
            this.func_73733_a(i1 - 3, j1 - 3, i1 + k + 3, j1 - 3 + 1, i2, i2);
            this.func_73733_a(i1 - 3, j1 + k1 + 2, i1 + k + 3, j1 + k1 + 3, j2, j2);
            for (int k2 = 0; k2 < par1List.size(); ++k2) {
                String s1 = (String)par1List.get(k2);
                this.field_73886_k.func_78261_a(s1, i1, j1, -1);
                if (k2 == 0) {
                    j1 += 2;
                }
                j1 += 10;
            }
            this.field_73735_i = 0.0f;
            AdaptiveSmelteryGui.itemRenderer.field_77023_b = 0.0f;
        }
    }

    public void drawLiquidRect(int startU, int startV, Icon par3Icon, int endU, int endV) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(startU + 0), (double)(startV + endV), (double)this.field_73735_i, (double)par3Icon.func_94209_e(), (double)par3Icon.func_94210_h());
        tessellator.func_78374_a((double)(startU + endU), (double)(startV + endV), (double)this.field_73735_i, (double)par3Icon.func_94212_f(), (double)par3Icon.func_94210_h());
        tessellator.func_78374_a((double)(startU + endU), (double)(startV + 0), (double)this.field_73735_i, (double)par3Icon.func_94212_f(), (double)par3Icon.func_94206_g());
        tessellator.func_78374_a((double)(startU + 0), (double)(startV + 0), (double)this.field_73735_i, (double)par3Icon.func_94209_e(), (double)par3Icon.func_94206_g());
        tessellator.func_78381_a();
    }

    @Override
    public void func_73874_b() {
        super.func_73874_b();
        this.logic.field_70331_k.func_72845_h(this.logic.field_70329_l, this.logic.field_70330_m, this.logic.field_70327_n);
    }
}

