/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.blocks;

import java.util.List;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tconstruct.TConstruct;
import tconstruct.blocks.logic.AdaptiveDrainLogic;
import tconstruct.blocks.logic.AdaptiveSmelteryLogic;
import tconstruct.blocks.logic.MultiServantLogic;
import tconstruct.blocks.logic.SmelteryDrainLogic;
import tconstruct.blocks.logic.SmelteryLogic;
import tconstruct.client.block.SmelteryRender;
import tconstruct.common.TProxyCommon;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.blocks.InventoryBlock;
import tconstruct.library.util.IFacingLogic;
import tconstruct.library.util.IMasterLogic;
import tconstruct.library.util.IServantLogic;
import tconstruct.util.config.PHConstruct;

public class SmelteryBlock
extends InventoryBlock {
    Random rand;
    String texturePrefix = "";

    public SmelteryBlock(int id) {
        super(id, Material.field_76246_e);
        this.func_71848_c(3.0f);
        this.func_71894_b(20.0f);
        this.func_71884_a(field_71977_i);
        this.rand = new Random();
        this.func_71849_a(TConstructRegistry.blockTab);
        this.func_71864_b("tconstruct.Smeltery");
    }

    public SmelteryBlock(int id, String prefix) {
        this(id);
        this.texturePrefix = prefix;
    }

    public int func_71857_b() {
        return PHConstruct.newSmeltery ? 0 : SmelteryRender.smelteryModel;
    }

    @Override
    public String[] getTextureNames() {
        String[] textureNames = new String[]{"smeltery_side", "smeltery_inactive", "smeltery_active", "drain_side", "drain_out", "drain_basin", "searedbrick", "searedstone", "searedcobble", "searedpaver", "searedbrickcracked", "searedroad", "searedbrickfancy", "searedbricksquare", "searedcreeper"};
        if (!this.texturePrefix.equals("")) {
            for (int i = 0; i < textureNames.length; ++i) {
                textureNames[i] = this.texturePrefix + "_" + textureNames[i];
            }
        }
        return textureNames;
    }

    public Icon func_71858_a(int side, int meta) {
        if (meta < 2) {
            int sideTex = side == 3 ? 1 : 0;
            return this.icons[sideTex + meta * 3];
        }
        if (meta == 2) {
            return this.icons[6];
        }
        if (meta == 11 && (side == 0 || side == 1)) {
            return this.icons[9];
        }
        return this.icons[3 + meta];
    }

    public Icon func_71895_b(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity logic = world.func_72796_p(x, y, z);
        int direction = logic instanceof IFacingLogic ? (int)((IFacingLogic)logic).getRenderDirection() : 0;
        int meta = world.func_72805_g(x, y, z);
        if (meta == 0) {
            if (side == direction) {
                if (SmelteryBlock.isActive(world, x, y, z)) {
                    return this.icons[2];
                }
                return this.icons[1];
            }
            return this.icons[0];
        }
        if (meta == 1) {
            if (side == direction) {
                return this.icons[5];
            }
            if (side / 2 == direction / 2) {
                return this.icons[4];
            }
            return this.icons[3];
        }
        if (meta == 2) {
            return this.icons[6];
        }
        if (meta == 11 && (side == 0 || side == 1)) {
            return this.icons[9];
        }
        return this.icons[3 + meta];
    }

    @Override
    public int func_71899_b(int meta) {
        return meta;
    }

    public int func_71925_a(Random random) {
        return 1;
    }

    @Override
    public Integer getGui(World world, int x, int y, int z, EntityPlayer entityplayer) {
        return TProxyCommon.smelteryGuiID;
    }

    public void func_71862_a(World world, int x, int y, int z, Random random) {
        if (SmelteryBlock.isActive((IBlockAccess)world, x, y, z)) {
            TileEntity logic = world.func_72796_p(x, y, z);
            byte face = 0;
            if (logic instanceof IFacingLogic) {
                face = ((IFacingLogic)logic).getRenderDirection();
            }
            float f = (float)x + 0.5f;
            float f1 = (float)y + 0.5f + random.nextFloat() * 6.0f / 16.0f;
            float f2 = (float)z + 0.5f;
            float f3 = 0.52f;
            float f4 = random.nextFloat() * 0.6f - 0.3f;
            switch (face) {
                case 4: {
                    world.func_72869_a("smoke", (double)(f - f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
                    world.func_72869_a("flame", (double)(f - f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
                    break;
                }
                case 5: {
                    world.func_72869_a("smoke", (double)(f + f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
                    world.func_72869_a("flame", (double)(f + f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
                    break;
                }
                case 2: {
                    world.func_72869_a("smoke", (double)(f + f4), (double)f1, (double)(f2 - f3), 0.0, 0.0, 0.0);
                    world.func_72869_a("flame", (double)(f + f4), (double)f1, (double)(f2 - f3), 0.0, 0.0, 0.0);
                    break;
                }
                case 3: {
                    world.func_72869_a("smoke", (double)(f + f4), (double)f1, (double)(f2 + f3), 0.0, 0.0, 0.0);
                    world.func_72869_a("flame", (double)(f + f4), (double)f1, (double)(f2 + f3), 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        return !SmelteryBlock.isActive(world, x, y, z) ? 0 : 9;
    }

    @Override
    public Object getModInstance() {
        return TConstruct.instance;
    }

    @Override
    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int side, float clickX, float clickY, float clickZ) {
        if (player.func_70093_af() || world.func_72805_g(x, y, z) != 0) {
            return false;
        }
        Integer integer = this.getGui(world, x, y, z, player);
        if (integer == null || integer == -1) {
            return false;
        }
        player.openGui(this.getModInstance(), integer.intValue(), world, x, y, z);
        return true;
    }

    @Override
    public TileEntity createTileEntity(World world, int metadata) {
        switch (metadata) {
            case 0: {
                if (PHConstruct.newSmeltery) {
                    return new AdaptiveSmelteryLogic();
                }
                return new SmelteryLogic();
            }
            case 1: {
                if (PHConstruct.newSmeltery) {
                    return new AdaptiveDrainLogic();
                }
                return new SmelteryDrainLogic();
            }
            case 3: {
                return null;
            }
        }
        return new MultiServantLogic();
    }

    @Override
    public void func_71860_a(World world, int x, int y, int z, EntityLivingBase entityliving, ItemStack stack) {
        super.func_71860_a(world, x, y, z, entityliving, stack);
        if (world.func_72805_g(x, y, z) == 0 && !PHConstruct.newSmeltery) {
            this.onBlockPlacedElsewhere(world, x, y, z, entityliving);
        }
    }

    public void onBlockPlacedElsewhere(World world, int x, int y, int z, EntityLivingBase entityliving) {
        SmelteryLogic logic = (SmelteryLogic)world.func_72796_p(x, y, z);
        logic.checkValidPlacement();
    }

    public void func_71879_a(int id, CreativeTabs tab, List list) {
        for (int iter = 0; iter < 12; ++iter) {
            if (iter == 3) continue;
            list.add(new ItemStack(id, 1, iter));
        }
    }

    public void func_71863_a(World world, int x, int y, int z, int nBlockID) {
        TileEntity logic = world.func_72796_p(x, y, z);
        if (logic instanceof IServantLogic) {
            ((IServantLogic)logic).notifyMasterOfChange();
        } else if (logic instanceof IMasterLogic) {
            ((IMasterLogic)logic).notifyChange(null, x, y, z);
        }
    }

    @Override
    public void func_71852_a(World world, int x, int y, int z, int blockID, int meta) {
        TileEntity logic = world.func_72796_p(x, y, z);
        if (logic instanceof IServantLogic) {
            ((IServantLogic)logic).notifyMasterOfChange();
        }
        super.func_71852_a(world, x, y, z, blockID, meta);
    }
}

