/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.blocks;

import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tconstruct.TConstruct;
import tconstruct.blocks.logic.FurnaceLogic;
import tconstruct.common.TProxyCommon;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.blocks.InventorySlab;
import tconstruct.library.util.IActiveLogic;
import tconstruct.library.util.IFacingLogic;

public class FurnaceSlab
extends InventorySlab {
    public FurnaceSlab(int id, Material material) {
        super(id, material);
        this.func_71849_a(TConstructRegistry.blockTab);
        this.func_71848_c(3.5f);
    }

    @Override
    public TileEntity createTileEntity(World world, int metadata) {
        switch (metadata % 8) {
            case 0: {
                return new FurnaceLogic();
            }
        }
        return null;
    }

    @Override
    public Integer getGui(World world, int x, int y, int z, EntityPlayer entityplayer) {
        return TProxyCommon.furnaceID;
    }

    @Override
    public Object getModInstance() {
        return TConstruct.instance;
    }

    @Override
    public String[] getTextureNames() {
        String[] textureNames = new String[]{"furnaceslab_front", "furnaceslab_front_active", "furnaceslab_side", "furnace_top"};
        return textureNames;
    }

    public Icon func_71858_a(int side, int meta) {
        return this.icons[meta % 8 * 3 + this.getTextureIndex(side)];
    }

    public Icon func_71895_b(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity logic = world.func_72796_p(x, y, z);
        int direction = logic instanceof IFacingLogic ? (int)((IFacingLogic)logic).getRenderDirection() : 0;
        int meta = world.func_72805_g(x, y, z) % 8;
        if (meta == 0) {
            if (side == direction) {
                if (((IActiveLogic)logic).getActive()) {
                    return this.icons[1];
                }
                return this.icons[0];
            }
            if (side > 1) {
                return this.icons[2];
            }
            return this.icons[3];
        }
        return this.icons[0];
    }

    public int getTextureIndex(int side) {
        if (side == 0 || side == 1) {
            return 3;
        }
        if (side == 3) {
            return 0;
        }
        return 2;
    }

    @Override
    public void func_94332_a(IconRegister iconRegister) {
        String[] textureNames = this.getTextureNames();
        this.icons = new Icon[textureNames.length];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = i == 3 ? iconRegister.func_94245_a("minecraft:" + textureNames[i]) : iconRegister.func_94245_a("tinker:" + textureNames[i]);
        }
    }
}

