/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tconstruct.TConstruct;
import tconstruct.blocks.logic.EquipLogic;
import tconstruct.blocks.logic.FrypanLogic;
import tconstruct.client.block.FrypanRender;
import tconstruct.common.TProxyCommon;
import tconstruct.library.blocks.InventoryBlock;

public class EquipBlock
extends InventoryBlock {
    public EquipBlock(int id, Material material) {
        super(id, material);
        this.func_71848_c(0.3f);
        this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 0.25f, 1.0f);
    }

    @Override
    public String[] getTextureNames() {
        return new String[]{"toolstation_top"};
    }

    public Icon func_71858_a(int side, int meta) {
        return Block.field_72083_ai.func_71858_a(side, meta);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister par1IconRegister) {
    }

    public boolean func_71886_c() {
        return false;
    }

    public boolean func_71926_d() {
        return false;
    }

    public int func_71857_b() {
        return FrypanRender.frypanModelID;
    }

    public int func_71885_a(int par1, Random par2Random, int par3) {
        return 0;
    }

    @Override
    public TileEntity createTileEntity(World world, int metadata) {
        return new FrypanLogic();
    }

    public void func_71862_a(World world, int x, int y, int z, Random random) {
        if (EquipBlock.isActive((IBlockAccess)world, x, y, z)) {
            float f = (float)x + 0.5f;
            float f1 = (float)y + 0.25f + random.nextFloat() * 6.0f / 16.0f;
            float f2 = (float)z + 0.5f;
            float f4 = random.nextFloat() * 0.6f - 0.3f;
            world.func_72869_a("smoke", (double)f, (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
            world.func_72869_a("flame", (double)f, (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void func_71860_a(World par1World, int par2, int par3, int par4, EntityLivingBase par5EntityLivingBase, ItemStack par6ItemStack) {
        super.func_71860_a(par1World, par2, par3, par4, par5EntityLivingBase, par6ItemStack);
        int i3 = MathHelper.func_76128_c((double)((double)(par5EntityLivingBase.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int newMeta = 0;
        switch (i3) {
            case 3: {
                newMeta = 0;
                break;
            }
            case 0: {
                newMeta = 3;
                break;
            }
            case 1: {
                newMeta = 1;
                break;
            }
            case 2: {
                newMeta = 2;
            }
        }
        par1World.func_72921_c(par2, par3, par4, newMeta, 2);
    }

    @Override
    public void func_71852_a(World par1World, int x, int y, int z, int par5, int meta) {
        TileEntity te = par1World.func_72796_p(x, y, z);
        if (te != null && te instanceof EquipLogic) {
            EquipLogic logic = (EquipLogic)te;
            for (int iter = 0; iter < logic.func_70302_i_(); ++iter) {
                ItemStack stack;
                ItemStack itemStack = stack = iter == 0 ? logic.getEquipmentItem() : logic.func_70301_a(iter);
                if (stack == null || !logic.canDropInventorySlot(iter)) continue;
                float jumpX = this.rand.nextFloat() * 0.8f + 0.1f;
                float jumpY = this.rand.nextFloat() * 0.8f + 0.1f;
                float jumpZ = this.rand.nextFloat() * 0.8f + 0.1f;
                while (stack.field_77994_a > 0) {
                    int itemSize = this.rand.nextInt(21) + 10;
                    if (itemSize > stack.field_77994_a) {
                        itemSize = stack.field_77994_a;
                    }
                    stack.field_77994_a -= itemSize;
                    EntityItem entityitem = new EntityItem(par1World, (double)((float)x + jumpX), (double)((float)y + jumpY), (double)((float)z + jumpZ), new ItemStack(stack.field_77993_c, itemSize, stack.func_77960_j()));
                    if (stack.func_77942_o()) {
                        entityitem.func_92059_d().func_77982_d((NBTTagCompound)stack.func_77978_p().func_74737_b());
                    }
                    float offset = 0.05f;
                    entityitem.field_70159_w = (float)this.rand.nextGaussian() * offset;
                    entityitem.field_70181_x = (float)this.rand.nextGaussian() * offset + 0.2f;
                    entityitem.field_70179_y = (float)this.rand.nextGaussian() * offset;
                    par1World.func_72838_d((Entity)entityitem);
                }
            }
        }
        super.func_71852_a(par1World, x, y, z, par5, meta);
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        return !EquipBlock.isActive(world, x, y, z) ? 0 : 9;
    }

    @Override
    public Integer getGui(World world, int x, int y, int z, EntityPlayer entityplayer) {
        return TProxyCommon.frypanGuiID;
    }

    @Override
    public Object getModInstance() {
        return TConstruct.instance;
    }
}

