/*
 * Decompiled with CFR 0.152.
 */
package openmods.codecs.adapters;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.sound.sampled.AudioFormat;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.BitstreamException;
import javazoom.jl.decoder.Decoder;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.SampleBuffer;
import openmods.codecs.Log;
import paulscode.sound.ICodec;
import paulscode.sound.SoundBuffer;
import paulscode.sound.SoundSystemConfig;

public class CodecMp3
implements ICodec {
    private boolean initialized;
    private boolean streamClosed;
    private Bitstream bitstream;
    private Decoder decoder;
    private AudioFormat audioFormat;
    private SampleBuffer buffer;

    public void reverseByteOrder(boolean b) {
    }

    public boolean initialize(URL url) {
        try {
            URLConnection conn = url.openConnection();
            conn.connect();
            this.bitstream = new Bitstream(conn.getInputStream());
            this.decoder = new Decoder();
            this.initialized = true;
            this.updateBuffer();
            this.audioFormat = new AudioFormat(this.decoder.getOutputFrequency(), 16, this.decoder.getOutputChannels(), true, false);
            return true;
        }
        catch (Throwable t) {
            Log.warn(t, "Failed to initalize codec for url '%s'", url);
            return false;
        }
    }

    private boolean updateBuffer() throws Exception {
        Header h = this.bitstream.readFrame();
        if (h == null) {
            return false;
        }
        this.buffer = (SampleBuffer)this.decoder.decodeFrame(h, this.bitstream);
        this.bitstream.closeFrame();
        return true;
    }

    public boolean initialized() {
        return this.initialized;
    }

    public SoundBuffer read() {
        if (!this.initialized || this.streamClosed) {
            return null;
        }
        int limit = SoundSystemConfig.getStreamingBufferSize();
        ByteArrayOutputStream output = new ByteArrayOutputStream(limit);
        try {
            do {
                this.readBytes(output);
            } while (this.updateBuffer() && !this.streamClosed && output.size() < limit);
        }
        catch (Throwable t) {
            Log.warn(t, "Error in stream decoding, aborting", new Object[0]);
            this.streamClosed = true;
        }
        return new SoundBuffer(output.toByteArray(), this.audioFormat);
    }

    public SoundBuffer readAll() {
        if (!this.initialized || this.streamClosed) {
            return null;
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            do {
                this.readBytes(output);
            } while (this.updateBuffer() && !this.streamClosed);
        }
        catch (Throwable t) {
            Log.warn(t, "Error in stream decoding, aborting", new Object[0]);
            this.streamClosed = true;
        }
        return new SoundBuffer(output.toByteArray(), this.audioFormat);
    }

    private void readBytes(OutputStream output) throws IOException {
        short[] samples = this.buffer.getBuffer();
        int len = this.buffer.getBufferLength();
        int idx = 0;
        while (len-- > 0) {
            short s = samples[idx++];
            output.write(s);
            output.write(s >>> 8);
        }
    }

    public boolean endOfStream() {
        return this.streamClosed;
    }

    public void cleanup() {
        this.streamClosed = true;
        this.initialized = false;
        this.decoder = null;
        try {
            this.bitstream.close();
        }
        catch (BitstreamException e) {
            Log.warn(e, "Failed to close bitstream", new Object[0]);
        }
        this.bitstream = null;
        this.buffer = null;
    }

    public AudioFormat getAudioFormat() {
        return this.audioFormat;
    }
}

