/*
 * Decompiled with CFR 0.152.
 */
package openmods.codecs.adapters;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import javax.sound.sampled.AudioFormat;
import net.sourceforge.jaad.aac.Decoder;
import net.sourceforge.jaad.aac.SampleBuffer;
import net.sourceforge.jaad.adts.ADTSDemultiplexer;
import openmods.codecs.Log;
import openmods.codecs.Utils;
import paulscode.sound.ICodec;
import paulscode.sound.SoundBuffer;
import paulscode.sound.SoundSystemConfig;

public class CodecAac
implements ICodec {
    private boolean initialized;
    private ADTSDemultiplexer adts;
    private AudioFormat format;
    private Decoder decoder;
    private boolean streamClosed;
    private SampleBuffer buf;
    private DataInputStream in;
    private boolean reverseBytes;
    private boolean endianessConflict;
    private int sampleInBytes;

    public void reverseByteOrder(boolean b) {
        this.reverseBytes = b;
    }

    public boolean initialize(URL url) {
        try {
            URLConnection conn = url.openConnection();
            conn.connect();
            this.in = new DataInputStream(conn.getInputStream());
            this.adts = new ADTSDemultiplexer(this.in);
            this.format = new AudioFormat(this.adts.getSampleFrequency(), 16, this.adts.getChannelCount(), true, true);
            this.decoder = new Decoder(this.adts.getDecoderSpecificInfo());
            this.buf = new SampleBuffer();
            this.initialized = true;
            this.updateBuffer();
            if (CodecAac.formatChanged(this.format, this.buf)) {
                Log.warn("Stream %s header declared different format than buffer", url);
                this.format = new AudioFormat(this.buf.getSampleRate(), this.buf.getBitsPerSample(), this.buf.getChannels(), true, this.buf.isBigEndian());
            }
            this.sampleInBytes = this.format.getSampleSizeInBits() / 8;
            this.endianessConflict = this.format.isBigEndian() && this.reverseBytes;
            return true;
        }
        catch (Throwable t) {
            Log.warn(t, "Failed to initalize codec for url '%s'", url);
            return false;
        }
    }

    private static boolean formatChanged(AudioFormat af, SampleBuffer buf) {
        return af.getSampleRate() != (float)buf.getSampleRate() || af.getChannels() != buf.getChannels() || af.getSampleSizeInBits() != buf.getBitsPerSample() || af.isBigEndian() != buf.isBigEndian();
    }

    public boolean initialized() {
        return this.initialized;
    }

    public boolean endOfStream() {
        return this.streamClosed;
    }

    public AudioFormat getAudioFormat() {
        return this.format;
    }

    private void updateBuffer() throws IOException {
        byte[] b = this.adts.readNextFrame();
        this.decoder.decodeFrame(b, this.buf);
    }

    private boolean appendBytes(ByteArrayOutputStream output) throws IOException {
        byte[] data = this.buf.getData();
        if (this.endianessConflict) {
            Utils.convertEndianness(data, this.sampleInBytes);
        }
        output.write(data);
        this.updateBuffer();
        if (CodecAac.formatChanged(this.format, this.buf)) {
            Log.warn("Stream format changed, aborting", new Object[0]);
            this.streamClosed = true;
            return false;
        }
        return true;
    }

    public SoundBuffer read() {
        if (!this.initialized || this.streamClosed) {
            return null;
        }
        int limit = SoundSystemConfig.getStreamingBufferSize();
        ByteArrayOutputStream output = new ByteArrayOutputStream(limit);
        try {
            while (this.appendBytes(output) && !this.streamClosed && output.size() < limit) {
            }
        }
        catch (Throwable t) {
            Log.warn(t, "Error in stream decoding, aborting", new Object[0]);
            this.streamClosed = true;
        }
        return new SoundBuffer(output.toByteArray(), this.format);
    }

    public SoundBuffer readAll() {
        if (!this.initialized || this.streamClosed) {
            return null;
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            while (this.appendBytes(output) && !this.streamClosed) {
            }
        }
        catch (Throwable t) {
            Log.warn(t, "Error in stream decoding, aborting", new Object[0]);
            this.streamClosed = true;
        }
        return new SoundBuffer(output.toByteArray(), this.format);
    }

    public void cleanup() {
        this.streamClosed = true;
        this.initialized = false;
        this.adts = null;
        this.decoder = null;
        try {
            this.in.close();
        }
        catch (IOException e) {
            Log.warn(e, "Can't close stream", new Object[0]);
        }
    }
}

