/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaad.aac.sbr;

import java.util.Arrays;
import java.util.logging.Level;
import net.sourceforge.jaad.aac.AACException;
import net.sourceforge.jaad.aac.SampleFrequency;
import net.sourceforge.jaad.aac.ps.PS;
import net.sourceforge.jaad.aac.sbr.Calculation;
import net.sourceforge.jaad.aac.sbr.ChannelData;
import net.sourceforge.jaad.aac.sbr.Filterbank;
import net.sourceforge.jaad.aac.sbr.HFAdjustment;
import net.sourceforge.jaad.aac.sbr.HFGeneration;
import net.sourceforge.jaad.aac.sbr.QMFAnalysis;
import net.sourceforge.jaad.aac.sbr.QMFSynthesis;
import net.sourceforge.jaad.aac.sbr.SBRConstants;
import net.sourceforge.jaad.aac.sbr.SBRHeader;
import net.sourceforge.jaad.aac.sbr.SBRTables;
import net.sourceforge.jaad.aac.syntax.BitStream;
import net.sourceforge.jaad.aac.syntax.Constants;

public class SBR
implements Constants,
SBRConstants,
SBRTables {
    private final ChannelData[] cd;
    int sampleRate;
    boolean reset;
    private final SBRHeader header;
    private boolean coupling;
    int extensionID;
    int extensionData;
    int k0;
    int kx;
    int kxPrev;
    int[] mft;
    int[][] ftRes;
    int[] ftNoise;
    int[][] ftLim;
    int N_master;
    int N_high;
    int N_low;
    int N_Q;
    int M;
    int Mprev;
    int[] N_L;
    int[] n;
    int[] tableMapKToG;
    int patches;
    int[] patchNoSubbands;
    int[] patchStartSubband;
    private final Filterbank filterBank;
    private final QMFAnalysis[] qmfa;
    private final QMFSynthesis[] qmfs;
    private final HFAdjustment hfAdj;
    private final HFGeneration hfGen;
    private float[][][] buffer;
    private float[][][] bufLeftPS;
    private float[][][] bufRightPS;
    private PS ps;
    private boolean psUsed;
    private boolean psExtensionRead;

    public SBR(SampleFrequency sf, boolean downSampled) {
        this.sampleRate = 2 * sf.getFrequency();
        this.cd = new ChannelData[2];
        this.cd[0] = new ChannelData();
        this.cd[1] = new ChannelData();
        this.filterBank = new Filterbank();
        this.qmfa = new QMFAnalysis[2];
        this.qmfa[0] = new QMFAnalysis(this.filterBank, 32);
        this.qmfs = new QMFSynthesis[2];
        this.qmfs[0] = new QMFSynthesis(this.filterBank, downSampled ? 32 : 64);
        this.hfAdj = new HFAdjustment(this);
        this.hfGen = new HFGeneration(this);
        this.patchNoSubbands = new int[64];
        this.patchStartSubband = new int[64];
        this.N_L = new int[4];
        this.n = new int[2];
        this.tableMapKToG = new int[64];
        this.mft = new int[64];
        this.ftRes = new int[2][64];
        this.ftNoise = new int[64];
        this.ftLim = new int[4][64];
        this.header = new SBRHeader();
        this.Mprev = 0;
    }

    public void decode(BitStream in, int count, boolean stereo, boolean crc) throws AACException {
        int len;
        int bitsLeft;
        int pos = in.getPosition();
        if (crc) {
            LOGGER.info("SBR CRC bits present");
            in.skipBits(10);
        }
        if (in.readBool()) {
            this.header.decode(in);
        }
        if (this.reset) {
            this.calculateTables();
        }
        if (this.header.isDecoded()) {
            this.decodeData(in, stereo);
        }
        if ((bitsLeft = count - (len = in.getPosition() - pos)) >= 8) {
            LOGGER.log(Level.WARNING, "SBR: bits left: {0}", bitsLeft);
        } else if (bitsLeft < 0) {
            throw new AACException("SBR data overread: " + bitsLeft);
        }
        in.skipBits(bitsLeft);
    }

    private void calculateTables() throws AACException {
        int maxLen;
        this.k0 = Calculation.getStartChannel(this.header.getStartFrequency(false), this.sampleRate);
        int k2 = Calculation.getStopChannel(this.header.getStopFrequency(false), this.sampleRate, this.k0);
        int len = k2 - this.k0;
        if (len <= (maxLen = this.sampleRate >= 48000 ? 32 : (this.sampleRate <= 32000 ? 48 : 45))) {
            int[] table = this.header.getFrequencyScale(false) == 0 ? Calculation.calculateMasterFrequencyTableFS0(this.k0, k2, this.header.isAlterScale(false)) : Calculation.calculateMasterFrequencyTable(this.k0, k2, this.header.getFrequencyScale(false), this.header.isAlterScale(false));
            if (table != null) {
                this.mft = table;
                this.N_master = table.length - 1;
            }
        } else {
            throw new AACException("SBR: master frequency table too long: " + len + ", max. length: " + maxLen);
        }
        this.calculateDerivedFrequencyTable(k2);
    }

    private void calculateDerivedFrequencyTable(int k2) throws AACException {
        int i;
        int xOverBand = this.header.getXOverBand(false);
        if (this.N_master <= xOverBand) {
            throw new AACException("SBR: derived frequency table: N_master=" + this.N_master + ", xOverBand=" + xOverBand);
        }
        this.N_high = this.N_master - xOverBand;
        this.n[0] = this.N_low = (this.N_high >> 1) + (this.N_high - (this.N_high >> 1 << 1));
        this.n[1] = this.N_high;
        for (i = 0; i <= this.N_high; ++i) {
            this.ftRes[1][i] = this.mft[i + xOverBand];
        }
        this.M = this.ftRes[1][this.N_high] - this.ftRes[1][0];
        this.kx = this.ftRes[1][0];
        if (this.kx > 32) {
            throw new AACException("SBR: kx>32: " + this.kx);
        }
        if (this.kx + this.M > 64) {
            throw new AACException("SBR: kx+M>64: " + (this.kx + this.M));
        }
        int minus = this.N_high & 1;
        int x = 0;
        for (i = 0; i <= this.N_low; ++i) {
            x = i == 0 ? 0 : 2 * i - minus;
            this.ftRes[0][i] = this.ftRes[1][x];
        }
        int noiseBands = this.header.getNoiseBands(false);
        this.N_Q = noiseBands == 0 ? 1 : Math.min(5, Math.max(1, Calculation.findBands(false, noiseBands, this.kx, k2)));
        for (i = 0; i <= this.N_Q; ++i) {
            x = i == 0 ? 0 : x + (this.N_low - x) / (this.N_Q + 1 - i);
            this.ftNoise[i] = this.ftRes[0][x];
        }
        block3: for (i = 0; i < 64; ++i) {
            for (int j = 0; j < this.N_Q; ++j) {
                if (this.ftNoise[j] > i || i >= this.ftNoise[j + 1]) continue;
                this.tableMapKToG[i] = j;
                continue block3;
            }
        }
    }

    void calculateLimiterFrequencyTable() {
        int j;
        this.ftLim[0][0] = this.ftRes[0][0] - this.kx;
        this.ftLim[0][1] = this.ftRes[0][this.N_low] - this.kx;
        this.N_L[0] = 1;
        int[] patchBorders = new int[this.patches + 1];
        patchBorders[0] = this.kx;
        for (j = 1; j <= this.patches; ++j) {
            patchBorders[j] = patchBorders[j - 1] + this.patchNoSubbands[j - 1];
        }
        int[] limTable = new int[this.patches + this.N_low];
        for (int i = 1; i < 4; ++i) {
            System.arraycopy(this.ftRes[0], 0, limTable, 0, this.N_low + 1);
            System.arraycopy(patchBorders, 1, limTable, this.N_low + 1, this.patches - 1);
            Arrays.sort(limTable, 0, this.patches + this.N_low);
            j = 1;
            int limCount = this.patches + this.N_low - 1;
            if (limCount < 0) {
                return;
            }
            while (j <= limCount) {
                float octaves;
                float f = octaves = limTable[j - 1] == 0 ? 0.0f : (float)limTable[j] / (float)limTable[j - 1];
                if (octaves < LIMITER_BANDS_COMPARE[i - 1]) {
                    if (limTable[j] != limTable[j - 1]) {
                        boolean found = false;
                        for (int k = 0; k <= this.patches; ++k) {
                            if (limTable[j] != patchBorders[k]) continue;
                            found = false;
                            for (k = 0; k <= this.patches; ++k) {
                                if (limTable[j - 1] != patchBorders[k]) continue;
                                found = true;
                            }
                            if (found) {
                                ++j;
                                continue;
                            }
                            limTable[j - 1] = this.ftRes[0][this.N_low];
                            Arrays.sort(limTable, 0, this.patches + this.N_low);
                            --limCount;
                        }
                    }
                    limTable[j] = this.ftRes[0][this.N_low];
                    Arrays.sort(limTable, 0, limCount);
                    --limCount;
                    continue;
                }
                ++j;
            }
            this.N_L[i] = limCount;
            for (j = 0; j <= limCount; ++j) {
                this.ftLim[i][j] = limTable[j] - this.kx;
            }
        }
    }

    private void decodeData(BitStream in, boolean stereo) throws AACException {
        if (stereo) {
            this.decodeChannelPairElement(in);
        } else {
            this.decodeSingleChannelElement(in);
        }
        if (in.readBool()) {
            int bitsLeft;
            this.psExtensionRead = false;
            int count = in.readBits(4);
            if (count == 15) {
                count += in.readBits(8);
            }
            for (bitsLeft = 8 * count; bitsLeft > 7; bitsLeft -= this.decodeExtension(in, this.extensionID)) {
                bitsLeft -= 2;
                this.extensionID = in.readBits(2);
                if (this.extensionID != 2 || !this.psExtensionRead) continue;
                this.extensionID = 3;
            }
            if (bitsLeft > 0) {
                in.skipBits(bitsLeft);
            }
        }
    }

    private void decodeSingleChannelElement(BitStream in) throws AACException {
        if (in.readBool()) {
            in.skipBits(4);
        }
        this.cd[0].decodeGrid(in);
        this.cd[0].decodeDTDF(in);
        this.cd[0].decodeInvfMode(in, this.N_Q);
        this.cd[0].decodeEnvelope(in, this, 0, this.coupling, this.header.getAmpRes());
        this.cd[0].decodeNoise(in, this, 0, this.coupling);
        this.cd[0].decodeSinusoidalCoding(in, this.N_high);
        this.dequantEnvelopeNoise(0);
    }

    private void decodeChannelPairElement(BitStream in) throws AACException {
        if (in.readBool()) {
            in.skipBits(8);
        }
        boolean ampRes = this.header.getAmpRes();
        this.coupling = in.readBool();
        if (this.coupling) {
            this.cd[0].decodeGrid(in);
            this.cd[1].copyGrid(this.cd[0]);
            this.cd[0].decodeDTDF(in);
            this.cd[1].decodeDTDF(in);
            this.cd[0].decodeInvfMode(in, this.N_Q);
            this.cd[1].copyInvfMode(this.cd[0], this.N_Q);
            this.cd[0].decodeEnvelope(in, this, 0, this.coupling, ampRes);
            this.cd[0].decodeNoise(in, this, 0, this.coupling);
            this.cd[1].decodeEnvelope(in, this, 1, this.coupling, ampRes);
            this.cd[1].decodeNoise(in, this, 1, this.coupling);
        } else {
            this.cd[0].decodeGrid(in);
            this.cd[1].decodeGrid(in);
            this.cd[0].decodeDTDF(in);
            this.cd[1].decodeDTDF(in);
            this.cd[0].decodeInvfMode(in, this.N_Q);
            this.cd[1].decodeInvfMode(in, this.N_Q);
            this.cd[0].decodeEnvelope(in, this, 0, this.coupling, ampRes);
            this.cd[1].decodeEnvelope(in, this, 1, this.coupling, ampRes);
            this.cd[0].decodeNoise(in, this, 0, this.coupling);
            this.cd[1].decodeNoise(in, this, 1, this.coupling);
        }
        this.cd[0].decodeSinusoidalCoding(in, this.N_high);
        this.cd[1].decodeSinusoidalCoding(in, this.N_high);
        this.dequantEnvelopeNoise(0);
        this.dequantEnvelopeNoise(1);
        if (this.coupling) {
            this.unmapEnvelopeNoise();
        }
    }

    private int decodeExtension(BitStream in, int extensionID) throws AACException {
        int ret;
        switch (extensionID) {
            case 2: {
                if (!this.psExtensionRead) {
                    this.psExtensionRead = true;
                    if (this.ps == null) {
                        this.ps = new PS();
                    }
                    ret = this.ps.decode(in);
                    if (this.psUsed || !this.ps.hasHeader()) break;
                    this.psUsed = true;
                    break;
                }
                ret = 0;
                break;
            }
            default: {
                this.extensionData = in.readBits(6);
                ret = 6;
            }
        }
        return ret;
    }

    private void dequantEnvelopeNoise(int ch) {
        ChannelData c = this.cd[ch];
        if (!this.coupling) {
            int j;
            int i;
            int amp = c.ampRes ? 0 : 1;
            for (i = 0; i < c.L_E; ++i) {
                for (j = 0; j < this.n[c.f[i] ? 1 : 0]; ++j) {
                    int exp = c.E[j][i] >> amp;
                    if (exp < 0 || exp >= 64) {
                        c.E_orig[j][i] = 0.0f;
                        continue;
                    }
                    c.E_orig[j][i] = ENVELOPE_DEQUANT_TABLE[exp];
                    if (amp == 0 || (c.E[j][i] & 1) != 1) continue;
                    float[] fArray = c.E_orig[j];
                    int n = i;
                    fArray[n] = fArray[n] * 1.4142135f;
                }
            }
            for (i = 0; i < c.L_Q; ++i) {
                for (j = 0; j < this.N_Q; ++j) {
                    c.Q_div[j][i] = this.calculateQDiv(ch, j, i);
                    c.Q_div2[j][i] = this.calculateQDiv2(ch, j, i);
                }
            }
        }
    }

    private void unmapEnvelopeNoise() {
        int j;
        int i;
        int amp0 = this.cd[0].ampRes ? 0 : 1;
        int amp1 = this.cd[1].ampRes ? 0 : 1;
        for (i = 0; i < this.cd[0].L_E; ++i) {
            for (j = 0; j < this.n[this.cd[0].f[i] ? 1 : 0]; ++j) {
                int exp0 = (this.cd[0].E[j][i] >> amp0) + 1;
                int exp1 = this.cd[1].E[j][i] >> amp1;
                if (exp0 < 0 || exp0 >= 64 || exp1 < 0 || exp1 > 24) {
                    this.cd[1].E_orig[j][i] = 0.0f;
                    this.cd[0].E_orig[j][i] = 0.0f;
                    continue;
                }
                float tmp = ENVELOPE_DEQUANT_TABLE[exp0];
                if (amp0 != 0 && (this.cd[0].E[j][i] & 1) == 1) {
                    tmp *= 1.4142135f;
                }
                this.cd[0].E_orig[j][i] = tmp * ENVELOPE_PANNING_TABLE[exp1];
                this.cd[1].E_orig[j][i] = tmp * ENVELOPE_PANNING_TABLE[24 - exp1];
            }
        }
        for (i = 0; i < this.cd[0].L_Q; ++i) {
            for (j = 0; j < this.N_Q; ++j) {
                this.cd[0].Q_div[j][i] = this.calculateQDiv(0, j, i);
                this.cd[1].Q_div[j][i] = this.calculateQDiv(1, j, i);
                this.cd[0].Q_div2[j][i] = this.calculateQDiv2(0, j, i);
                this.cd[1].Q_div2[j][i] = this.calculateQDiv2(1, j, i);
            }
        }
    }

    private float calculateQDiv(int ch, int m, int l) {
        if (this.coupling) {
            if (this.cd[0].Q[m][l] < 0 || this.cd[0].Q[m][l] > 30 || this.cd[1].Q[m][l] < 0 || this.cd[1].Q[m][l] > 24) {
                return 0.0f;
            }
            if (ch == 0) {
                return Q_DIV_TABLE_LEFT[this.cd[0].Q[m][l]][this.cd[1].Q[m][l] >> 1];
            }
            return Q_DIV_TABLE_RIGHT[this.cd[0].Q[m][l]][this.cd[1].Q[m][l] >> 1];
        }
        if (this.cd[ch].Q[m][l] < 0 || this.cd[ch].Q[m][l] > 30) {
            return 0.0f;
        }
        return Q_DIV_TABLE[this.cd[ch].Q[m][l]];
    }

    private float calculateQDiv2(int ch, int m, int l) {
        if (this.coupling) {
            if (this.cd[0].Q[m][l] < 0 || this.cd[0].Q[m][l] > 30 || this.cd[1].Q[m][l] < 0 || this.cd[1].Q[m][l] > 24) {
                return 0.0f;
            }
            if (ch == 0) {
                return Q_DIV2_TABLE_LEFT[this.cd[0].Q[m][l]][this.cd[1].Q[m][l] >> 1];
            }
            return Q_DIV2_TABLE_RIGHT[this.cd[0].Q[m][l]][this.cd[1].Q[m][l] >> 1];
        }
        if (this.cd[ch].Q[m][l] < 0 || this.cd[ch].Q[m][l] > 30) {
            return 0.0f;
        }
        return Q_DIV2_TABLE[this.cd[ch].Q[m][l]];
    }

    public boolean isPSUsed() {
        return this.psUsed;
    }

    public void processSingleFrame(float[] channel, boolean downSampled) {
        if (this.buffer == null) {
            this.buffer = new float[32][64][2];
        }
        boolean process = true;
        if (!this.header.isDecoded()) {
            process = false;
        }
        this.processChannel(channel, this.buffer, 0, process);
        if (downSampled) {
            this.qmfs[0].performSynthesis32(this.buffer, channel, 32);
        } else {
            this.qmfs[0].performSynthesis64(this.buffer, channel, 32);
        }
        if (this.header.isDecoded()) {
            this.savePreviousData(0);
        }
        this.cd[0].saveMatrix();
    }

    public void processCoupleFrame(float[] left, float[] right, boolean downSampled) {
        if (this.buffer == null) {
            this.buffer = new float[32][64][2];
        }
        boolean process = true;
        if (!this.header.isDecoded()) {
            process = false;
        }
        this.processChannel(left, this.buffer, 0, process);
        if (downSampled) {
            this.qmfs[0].performSynthesis32(this.buffer, left, 32);
        } else {
            this.qmfs[0].performSynthesis64(this.buffer, left, 32);
        }
        if (this.qmfs[1] == null) {
            this.qmfs[1] = new QMFSynthesis(this.filterBank, downSampled ? 32 : 64);
        }
        this.processChannel(right, this.buffer, 1, process);
        if (downSampled) {
            this.qmfs[1].performSynthesis32(this.buffer, right, 32);
        } else {
            this.qmfs[1].performSynthesis64(this.buffer, right, 32);
        }
        if (this.header.isDecoded()) {
            this.savePreviousData(0);
            this.savePreviousData(1);
        }
        this.cd[0].saveMatrix();
        this.cd[1].saveMatrix();
    }

    public void processSingleFramePS(float[] left, float[] right, boolean downSampled) throws AACException {
        if (this.bufLeftPS == null) {
            this.bufLeftPS = new float[38][64][2];
            this.bufRightPS = new float[38][64][2];
        }
        boolean process = true;
        if (!this.header.isDecoded()) {
            process = false;
        }
        this.processChannel(left, this.bufLeftPS, 0, process);
        for (int l = 32; l < 38; ++l) {
            for (int k = 0; k < 5; ++k) {
                this.bufLeftPS[l][k][0] = this.cd[0].Xsbr[2 + l][k][0];
                this.bufLeftPS[l][k][1] = this.cd[0].Xsbr[2 + l][k][1];
            }
        }
        this.ps.process(this.bufLeftPS, this.bufRightPS, this.kx + this.M);
        if (this.qmfs[1] == null) {
            this.qmfs[1] = new QMFSynthesis(this.filterBank, downSampled ? 32 : 64);
        }
        if (downSampled) {
            this.qmfs[0].performSynthesis32(this.bufLeftPS, left, 32);
            this.qmfs[1].performSynthesis32(this.bufRightPS, right, 32);
        } else {
            this.qmfs[0].performSynthesis64(this.bufLeftPS, left, 32);
            this.qmfs[1].performSynthesis64(this.bufRightPS, right, 32);
        }
        if (this.header.isDecoded()) {
            this.savePreviousData(0);
        }
        this.cd[0].saveMatrix();
    }

    private void processChannel(float[] channel, float[][][] X, int ch, boolean process) {
        int param;
        int n = param = process ? this.kx : 32;
        if (this.qmfa[ch] == null) {
            this.qmfa[ch] = new QMFAnalysis(this.filterBank, 32);
        }
        this.qmfa[ch].performAnalysis32(channel, this.cd[ch].Xsbr, 8, param, 32);
        if (process) {
            this.hfGen.process(this.cd[ch].Xsbr, this.cd[ch].Xsbr, ch, this.cd[ch]);
            this.hfAdj.process(this.cd[ch].Xsbr, this.cd[ch], this.header);
            for (int i = 0; i < 32; ++i) {
                int j;
                int M_band;
                int kx_band;
                if (i < this.cd[ch].t_E[0]) {
                    kx_band = this.kxPrev;
                    M_band = this.Mprev;
                } else {
                    kx_band = this.kx;
                    M_band = this.M;
                }
                for (j = 0; j < kx_band; ++j) {
                    X[i][j][0] = this.cd[ch].Xsbr[i + 2][j][0];
                    X[i][j][1] = this.cd[ch].Xsbr[i + 2][j][1];
                }
                for (j = kx_band; j < kx_band + M_band; ++j) {
                    X[i][j][0] = this.cd[ch].Xsbr[i + 2][j][0];
                    X[i][j][1] = this.cd[ch].Xsbr[i + 2][j][1];
                }
                for (j = kx_band + M_band; j < 64; ++j) {
                    X[i][j][0] = 0.0f;
                    X[i][j][1] = 0.0f;
                }
            }
        } else {
            for (int i = 0; i < 32; ++i) {
                int j;
                for (j = 0; j < 32; ++j) {
                    X[i][j][0] = this.cd[ch].Xsbr[i + 2][j][0];
                    X[i][j][1] = this.cd[ch].Xsbr[i + 2][j][1];
                }
                for (j = 32; j < 64; ++j) {
                    X[i][j][0] = 0.0f;
                    X[i][j][1] = 0.0f;
                }
            }
        }
    }

    private void savePreviousData(int ch) {
        this.kxPrev = this.kx;
        this.Mprev = this.M;
        this.cd[ch].savePreviousData();
    }
}

