/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaad.aac.ps2;

import java.util.Arrays;
import net.sourceforge.jaad.aac.AACException;
import net.sourceforge.jaad.aac.ps2.HuffmanTables;
import net.sourceforge.jaad.aac.ps2.HybridFilterbank;
import net.sourceforge.jaad.aac.ps2.PSConstants;
import net.sourceforge.jaad.aac.ps2.PSHeader;
import net.sourceforge.jaad.aac.ps2.PSTables;
import net.sourceforge.jaad.aac.ps2.TableGenerator;
import net.sourceforge.jaad.aac.ps2.Utils;
import net.sourceforge.jaad.aac.syntax.BitStream;

public class PS
implements PSConstants,
PSTables,
HuffmanTables {
    private final float[][][] HA = new float[46][8][4];
    private final float[][][] HB = new float[46][8][4];
    private final float[][] PHI_FRACT_20;
    private final float[][] PHI_FRACT_34;
    private final float[][][] Q_FRACT_ALLPASS_20;
    private final float[][][] Q_FRACT_ALLPASS_34;
    private final float[][] SMOOTHING_TABLE;
    private boolean headerEnabled;
    private final PSHeader header;
    private boolean frameClass;
    private int envCount;
    private int envCountPrev;
    private final int[] borderPositions;
    private final int[][] iidPars;
    private final int[][] iccPars;
    private final int[][] ipdPars;
    private final int[][] opdPars;
    private final int[][] iidMapped;
    private final int[][] iccMapped;
    private final int[][] ipdMapped;
    private final int[][] opdMapped;
    private final int[] ipdPrev;
    private final int[] opdPrev;
    private final float[][][] lBuf;
    private final float[][][] rBuf;
    private final float[] peakDecayNrg;
    private final float[] smoothNrg;
    private final float[] smoothPeakDecayDiffNrg;
    private final float[][][] delay;
    private final float[][][][] apDelay;
    private final float[][][] H11;
    private final float[][][] H12;
    private final float[][][] H21;
    private final float[][][] H22;

    public PS() {
        TableGenerator.generateMixingTables(this.HA, this.HB);
        this.PHI_FRACT_20 = new float[30][2];
        this.Q_FRACT_ALLPASS_20 = new float[30][3][2];
        TableGenerator.generateFractTables20(this.PHI_FRACT_20, this.Q_FRACT_ALLPASS_20);
        this.PHI_FRACT_34 = new float[50][2];
        this.Q_FRACT_ALLPASS_34 = new float[50][3][2];
        TableGenerator.generateFractTables34(this.PHI_FRACT_34, this.Q_FRACT_ALLPASS_34);
        this.SMOOTHING_TABLE = new float[512][2];
        TableGenerator.generateIPDOPDSmoothingTables(this.SMOOTHING_TABLE);
        this.headerEnabled = false;
        this.header = new PSHeader();
        this.borderPositions = new int[4];
        this.iidPars = new int[4][34];
        this.iccPars = new int[4][34];
        this.ipdPars = new int[4][17];
        this.opdPars = new int[4][17];
        this.iidMapped = new int[4][34];
        this.iccMapped = new int[4][34];
        this.ipdMapped = new int[4][17];
        this.opdMapped = new int[4][17];
        this.ipdPrev = new int[17];
        this.opdPrev = new int[17];
        this.lBuf = new float[91][32][2];
        this.rBuf = new float[91][32][2];
        this.peakDecayNrg = new float[34];
        this.smoothNrg = new float[34];
        this.smoothPeakDecayDiffNrg = new float[34];
        this.delay = new float[91][46][2];
        this.apDelay = new float[50][3][46][2];
        this.H11 = new float[2][5][34];
        this.H12 = new float[2][5][34];
        this.H21 = new float[2][5][34];
        this.H22 = new float[2][5][34];
    }

    public void decode(BitStream in) throws AACException {
        int[][] table;
        boolean dt;
        int len;
        int e;
        this.header.startNewFrame();
        this.headerEnabled = in.readBool();
        if (this.headerEnabled) {
            this.header.decode(in);
        }
        this.frameClass = in.readBool();
        int envIdx = in.readBits(2);
        this.envCountPrev = this.envCount;
        this.envCount = envIdx + (this.frameClass ? 1 : 0);
        if (envIdx == 3 && !this.frameClass) {
            ++this.envCount;
        }
        if (this.envCount == 0) {
            this.envCount = this.envCountPrev;
        }
        if (this.frameClass) {
            for (e = 0; e < this.envCount; ++e) {
                this.borderPositions[e] = in.readBits(5);
            }
        } else {
            for (e = 0; e < this.envCount; ++e) {
                this.borderPositions[e] = 32 * (e + 1) / this.envCount - 1;
            }
        }
        if (this.header.isIIDEnabled()) {
            len = this.header.getIIDPars();
            boolean fine = this.header.useIIDQuantFine();
            for (e = 0; e < this.envCount; ++e) {
                dt = in.readBool();
                table = dt ? (fine ? HUFF_IID_FINE_DT : HUFF_IID_DEFAULT_DT) : (fine ? HUFF_IID_FINE_DF : HUFF_IID_DEFAULT_DF);
                this.decodePars(in, table, this.iidPars, e, len, dt, false);
            }
        }
        if (this.header.isICCEnabled()) {
            len = this.header.getICCPars();
            for (e = 0; e < this.envCount; ++e) {
                dt = in.readBool();
                table = dt ? HUFF_ICC_DT : HUFF_ICC_DF;
                this.decodePars(in, table, this.iccPars, e, len, dt, false);
            }
        }
        if (this.header.isExtEnabled()) {
            int left = in.readBits(4);
            if (left == 15) {
                left += in.readBits(8);
            }
            left *= 8;
            while (left > 7) {
                int id = in.readBits(2);
                left -= 2;
                left -= this.decodeExtension(in, id);
            }
            in.skipBits(left);
        }
    }

    private void decodePars(BitStream in, int[][] table, int[][] pars, int env, int len, boolean dt, boolean mod) throws AACException {
        if (dt) {
            int prev = env > 0 ? env - 1 : this.envCountPrev - 1;
            for (int i = 0; i < len; ++i) {
                pars[env][i] = pars[prev][i] + this.decodeHuffman(in, table);
                if (!mod) continue;
                int[] nArray = pars[env];
                int n = i;
                nArray[n] = nArray[n] & 7;
            }
        } else {
            pars[env][0] = this.decodeHuffman(in, table);
            for (int i = 1; i < len; ++i) {
                pars[env][i] = pars[env][i - 1] + this.decodeHuffman(in, table);
                if (!mod) continue;
                int[] nArray = pars[env];
                int n = i;
                nArray[n] = nArray[n] & 7;
            }
        }
    }

    private int decodeHuffman(BitStream in, int[][] table) throws AACException {
        int j;
        int off = 0;
        int len = table[off][0];
        for (int cw = in.readBits(len); cw != table[off][1]; cw |= in.readBits(j)) {
            j = table[++off][0] - len;
            len = table[off][0];
            cw <<= j;
        }
        return table[off][2];
    }

    private int decodeExtension(BitStream in, int id) throws AACException {
        int start = in.getPosition();
        if (id == 0) {
            boolean b = in.readBool();
            this.header.setIPDOPDEnabled(b);
            if (b) {
                int len = this.header.getIPDOPDPars();
                for (int e = 0; e < this.envCount; ++e) {
                    boolean dt = in.readBool();
                    int[][] table = dt ? HUFF_IPD_DT : HUFF_IPD_DF;
                    this.decodePars(in, table, this.ipdPars, e, len, dt, true);
                    dt = in.readBool();
                    table = dt ? HUFF_OPD_DT : HUFF_OPD_DF;
                    this.decodePars(in, table, this.opdPars, e, len, dt, true);
                }
            }
            in.skipBit();
        }
        return in.getPosition() - start;
    }

    public boolean hasHeader() {
        return this.headerEnabled;
    }

    public void process(float[][][] left, float[][][] right) {
        HybridFilterbank.analyze(left, this.lBuf, this.header.use34Bands(false));
        this.decorrelate();
        this.performStereoProcessing();
        HybridFilterbank.synthesize(this.lBuf, left, this.header.use34Bands(false));
        HybridFilterbank.synthesize(this.rBuf, right, this.header.use34Bands(false));
    }

    private void decorrelate() {
        int b;
        int n;
        int k;
        boolean use34 = this.header.use34Bands(false);
        if (this.header.use34Bands(true) != use34) {
            Arrays.fill(this.peakDecayNrg, 0.0f);
            Arrays.fill(this.smoothNrg, 0.0f);
            Arrays.fill(this.smoothPeakDecayDiffNrg, 0.0f);
            for (int i = 0; i < this.delay.length; ++i) {
                for (int j = 0; j < this.delay[i].length; ++j) {
                    this.delay[i][j][0] = 0.0f;
                    this.delay[i][j][1] = 0.0f;
                }
            }
        }
        int mode = this.header.getBandMode();
        int[] map = use34 ? K_TO_BK_34 : K_TO_BK_20;
        int parBands = PAR_BANDS[mode];
        float[][] power = new float[parBands][32];
        for (k = 0; k < parBands; ++k) {
            Arrays.fill(power[k], 0.0f);
        }
        for (k = 0; k < parBands; ++k) {
            for (n = 0; n < 32; ++n) {
                b = map[k];
                float[] fArray = power[b];
                int n2 = n;
                fArray[n2] = fArray[n2] + (this.lBuf[k][n][0] * this.lBuf[k][n][0] + this.lBuf[k][n][1] * this.lBuf[k][n][1]);
            }
        }
        float[][] gTransientRatio = new float[parBands][32];
        for (k = 0; k < parBands; ++k) {
            this.peakDecayNrg[k] = power[k][0];
            for (n = 0; n < 32; ++n) {
                int n3 = k;
                this.peakDecayNrg[n3] = this.peakDecayNrg[n3] * 0.7659283f;
                this.peakDecayNrg[k] = Math.max(this.peakDecayNrg[k], power[k][n]);
                int n4 = k;
                this.smoothNrg[n4] = this.smoothNrg[n4] + 0.25f * (power[k][n] - this.smoothNrg[k]);
                int n5 = k;
                this.smoothPeakDecayDiffNrg[n5] = this.smoothPeakDecayDiffNrg[n5] + 0.25f * (this.peakDecayNrg[k] - power[k][n] - this.smoothPeakDecayDiffNrg[k]);
                float tmp = 1.5f * this.smoothPeakDecayDiffNrg[k];
                gTransientRatio[k][n] = tmp > this.smoothNrg[k] ? this.smoothNrg[k] / tmp : 1.0f;
            }
        }
        float[][] transientGain = new float[parBands][32];
        for (k = 0; k < parBands; ++k) {
            for (n = 0; n < 32; ++n) {
                transientGain[k][n] = gTransientRatio[map[k]][n];
            }
        }
        int allpassBands = ALLPASS_BANDS[mode];
        float[][] phiFract = use34 ? this.PHI_FRACT_34 : this.PHI_FRACT_20;
        float[][][] qFract = use34 ? this.Q_FRACT_ALLPASS_34 : this.Q_FRACT_ALLPASS_20;
        float[][][] H = new float[allpassBands][32][2];
        float[] ag = new float[3];
        for (k = 0; k < allpassBands; ++k) {
            int m;
            b = map[k];
            float gDecaySlope = k > DECAY_CUTOFF[mode] ? Math.max(0.0f, 1.0f - 0.05f * (float)(k - DECAY_CUTOFF[mode])) : 1.0f;
            for (m = 0; m < 3; ++m) {
                for (n = 0; n < 5; ++n) {
                    this.apDelay[k][m][n][0] = this.apDelay[k][m][32][0];
                    this.apDelay[k][m][n][1] = this.apDelay[k][m][32][1];
                }
                ag[m] = FILTER_COEFFICIENTS[m] * gDecaySlope;
            }
            this.addNewSamples(k);
            for (n = 0; n < 32; ++n) {
                float re = this.delay[k][n + 14 - 2][0] * phiFract[k][0] - this.delay[k][n + 14 - 2][1] * phiFract[k][1];
                float im = this.delay[k][n + 14 - 2][0] * phiFract[k][1] + this.delay[k][n + 14 - 2][1] * phiFract[k][0];
                for (m = 0; m < 3; ++m) {
                    float a_re = ag[m] * re;
                    float a_im = ag[m] * im;
                    float link_delay_re = this.apDelay[k][m][n + 5 - LINK_DELAY[m]][0];
                    float link_delay_im = this.apDelay[k][m][n + 5 - LINK_DELAY[m]][1];
                    float fractional_delay_re = qFract[k][m][0];
                    float fractional_delay_im = qFract[k][m][1];
                    this.apDelay[k][m][n + 5][0] = re;
                    this.apDelay[k][m][n + 5][1] = im;
                    re = link_delay_re * fractional_delay_re - link_delay_im * fractional_delay_im - a_re;
                    im = link_delay_re * fractional_delay_im + link_delay_im * fractional_delay_re - a_im;
                    float[] fArray = this.apDelay[k][m][n + 5];
                    fArray[0] = fArray[0] + ag[m] * re;
                    float[] fArray2 = this.apDelay[k][m][n + 5];
                    fArray2[1] = fArray2[1] + ag[m] * im;
                }
                this.rBuf[k][n][0] = transientGain[b][n] * re;
                this.rBuf[k][n][1] = transientGain[b][n] * im;
            }
        }
        for (k = allpassBands; k < SHORT_DELAY_BANDS[mode]; ++k) {
            this.addNewSamples(k);
            for (n = 0; n < 32; ++n) {
                this.rBuf[k][n][0] = transientGain[map[k]][n] * this.delay[k][n + 14 - 14][0];
                this.rBuf[k][n][1] = transientGain[map[k]][n] * this.delay[k][n + 14 - 14][1];
            }
        }
        for (k = SHORT_DELAY_BANDS[mode]; k < BANDS[mode]; ++k) {
            this.addNewSamples(k);
            for (n = 0; n < 32; ++n) {
                this.rBuf[k][n][0] = transientGain[map[k]][n] * this.delay[k][n + 14 - 1][0];
                this.rBuf[k][n][1] = transientGain[map[k]][n] * this.delay[k][n + 14 - 1][1];
            }
        }
    }

    private void addNewSamples(int k) {
        int n;
        for (n = 0; n < 14; ++n) {
            this.delay[k][n][0] = this.delay[k][n + 32][0];
            this.delay[k][n][1] = this.delay[k][n + 32][1];
        }
        for (n = 0; n < 32; ++n) {
            this.delay[k][n + 14][0] = this.lBuf[k][n][0];
            this.delay[k][n + 14][1] = this.lBuf[k][n][1];
        }
    }

    private void performStereoProcessing() {
        this.mapPars(this.iidPars, this.iidMapped, this.header.getIIDPars(), true);
        this.mapPars(this.iccPars, this.iccMapped, this.header.getICCPars(), true);
        if (this.header.isIPDOPDEnabled()) {
            int pars = this.header.getIPDOPDPars();
            this.mapPars(this.ipdPars, this.ipdMapped, pars, true);
            this.mapPars(this.opdPars, this.opdMapped, pars, true);
        }
        System.arraycopy(this.H11[0][this.envCountPrev], 0, this.H11[0][0], 0, 34);
        System.arraycopy(this.H11[1][this.envCountPrev], 0, this.H11[0][0], 0, 34);
        System.arraycopy(this.H12[0][this.envCountPrev], 0, this.H12[0][0], 0, 34);
        System.arraycopy(this.H12[1][this.envCountPrev], 0, this.H12[0][0], 0, 34);
        System.arraycopy(this.H21[0][this.envCountPrev], 0, this.H21[0][0], 0, 34);
        System.arraycopy(this.H21[1][this.envCountPrev], 0, this.H21[0][0], 0, 34);
        System.arraycopy(this.H22[0][this.envCountPrev], 0, this.H22[0][0], 0, 34);
        System.arraycopy(this.H22[1][this.envCountPrev], 0, this.H22[0][0], 0, 34);
        boolean use34 = this.header.use34Bands(false);
        boolean use34Prev = this.header.use34Bands(true);
        if (use34 && !use34Prev) {
            Utils.map20To34(this.H11[0][0]);
            Utils.map20To34(this.H11[1][0]);
            Utils.map20To34(this.H12[0][0]);
            Utils.map20To34(this.H12[1][0]);
            Utils.map20To34(this.H21[0][0]);
            Utils.map20To34(this.H21[1][0]);
            Utils.map20To34(this.H22[0][0]);
            Utils.map20To34(this.H22[1][0]);
            Arrays.fill(this.ipdPrev, 0);
            Arrays.fill(this.opdPrev, 0);
        } else if (!use34 && use34Prev) {
            Utils.map34To20(this.H11[0][0]);
            Utils.map34To20(this.H11[1][0]);
            Utils.map34To20(this.H12[0][0]);
            Utils.map34To20(this.H12[1][0]);
            Utils.map34To20(this.H21[0][0]);
            Utils.map34To20(this.H21[1][0]);
            Utils.map34To20(this.H22[0][0]);
            Utils.map34To20(this.H22[1][0]);
            Arrays.fill(this.ipdPrev, 0);
            Arrays.fill(this.opdPrev, 0);
        }
        boolean ipdopd = this.header.isIPDOPDEnabled();
        int mode = this.header.getBandMode();
        float[][][] filter = this.header.useICCMixingB() ? this.HB : this.HA;
        int[] map = this.header.use34Bands(false) ? PARAMETER_MAP_34 : PARAMETER_MAP_20;
        int iidQuant = this.header.useIIDQuantFine() ? 1 : 0;
        float[] h11 = new float[2];
        float[] h12 = new float[2];
        float[] h21 = new float[2];
        float[] h22 = new float[2];
        float[] h11Step = new float[2];
        float[] h12Step = new float[2];
        float[] h21Step = new float[2];
        float[] h22Step = new float[2];
        float[] tmp = new float[2];
        float[] l = new float[2];
        float[] r = new float[2];
        for (int e = 0; e < this.envCount; ++e) {
            int b;
            for (b = 0; b < PAR_BANDS[mode]; ++b) {
                h11[0] = filter[this.iidMapped[e][b] + 7 + 23 * iidQuant][this.iccMapped[e][b]][0];
                h12[0] = filter[this.iidMapped[e][b] + 7 + 23 * iidQuant][this.iccMapped[e][b]][1];
                h21[0] = filter[this.iidMapped[e][b] + 7 + 23 * iidQuant][this.iccMapped[e][b]][2];
                h22[0] = filter[this.iidMapped[e][b] + 7 + 23 * iidQuant][this.iccMapped[e][b]][3];
                if (ipdopd && b < this.header.getIPDOPDPars()) {
                    int ipdIndex = this.ipdPrev[b] * 8 + this.ipdMapped[e][b];
                    int opdIndex = this.opdPrev[b] * 8 + this.opdMapped[e][b];
                    this.opdPrev[b] = opdIndex & 0x3F;
                    this.ipdPrev[b] = ipdIndex & 0x3F;
                    float[] ipd = this.SMOOTHING_TABLE[ipdIndex];
                    float[] opd = this.SMOOTHING_TABLE[opdIndex];
                    tmp[0] = opd[0] * ipd[0] + opd[1] * ipd[1];
                    tmp[1] = opd[1] * ipd[0] - opd[0] * ipd[1];
                    h11[1] = h11[0] * opd[1];
                    h11[0] = h11[0] * opd[0];
                    h12[1] = h12[0] * tmp[1];
                    h12[0] = h12[0] * tmp[0];
                    h21[1] = h21[0] * opd[1];
                    h21[0] = h21[0] * opd[0];
                    h22[1] = h22[0] * tmp[1];
                    h22[0] = h22[0] * tmp[0];
                    this.H11[1][e + 1][b] = h11[1];
                    this.H12[1][e + 1][b] = h12[1];
                    this.H21[1][e + 1][b] = h21[1];
                    this.H22[1][e + 1][b] = h22[1];
                }
                this.H11[0][e + 1][b] = h11[0];
                this.H12[0][e + 1][b] = h12[0];
                this.H21[0][e + 1][b] = h21[0];
                this.H22[0][e + 1][b] = h22[0];
            }
            for (int k = 0; k < BANDS[mode]; ++k) {
                float width = 1.0f / (float)(this.borderPositions[e] + 1 - this.borderPositions[e + 1]);
                b = map[k];
                h11[0] = this.H11[0][e][b];
                h12[0] = this.H12[0][e][b];
                h21[0] = this.H21[0][e][b];
                h22[0] = this.H22[0][e][b];
                if (ipdopd) {
                    if (use34 && k >= 9 && k <= 13 || !use34 && k <= 1) {
                        h11[1] = -this.H11[1][e][b];
                        h12[1] = -this.H12[1][e][b];
                        h21[1] = -this.H21[1][e][b];
                        h22[1] = -this.H22[1][e][b];
                    } else {
                        h11[1] = this.H11[1][e][b];
                        h12[1] = this.H12[1][e][b];
                        h21[1] = this.H21[1][e][b];
                        h22[1] = this.H22[1][e][b];
                    }
                }
                h11Step[0] = (this.H11[0][e + 1][b] - h11[0]) * width;
                h12Step[0] = (this.H12[0][e + 1][b] - h12[0]) * width;
                h21Step[0] = (this.H21[0][e + 1][b] - h21[0]) * width;
                h22Step[0] = (this.H22[0][e + 1][b] - h22[0]) * width;
                if (ipdopd) {
                    h11Step[1] = (this.H11[1][e + 1][b] - h11[1]) * width;
                    h12Step[1] = (this.H12[1][e + 1][b] - h12[1]) * width;
                    h21Step[1] = (this.H21[1][e + 1][b] - h21[1]) * width;
                    h22Step[1] = (this.H22[1][e + 1][b] - h22[1]) * width;
                }
                for (int n = this.borderPositions[e] + 1; n <= this.borderPositions[e + 1]; ++n) {
                    l[0] = this.lBuf[k][n][0];
                    l[1] = this.lBuf[k][n][1];
                    r[0] = this.rBuf[k][n][0];
                    r[1] = this.rBuf[k][n][1];
                    h11[0] = h11[0] + h11Step[0];
                    h12[0] = h12[0] + h12Step[0];
                    h21[0] = h21[0] + h21Step[0];
                    h22[0] = h22[0] + h22Step[0];
                    this.lBuf[k][n][0] = h11[0] * l[0] + h21[0] * r[0];
                    this.lBuf[k][n][1] = h11[0] * l[1] + h21[0] * r[1];
                    this.rBuf[k][n][0] = h12[0] * l[0] + h22[0] * r[0];
                    this.rBuf[k][n][1] = h12[0] * l[1] + h22[0] * r[1];
                    if (!ipdopd) continue;
                    h11[1] = h11[1] + h11Step[1];
                    h12[1] = h12[1] + h12Step[1];
                    h21[1] = h21[1] + h21Step[1];
                    h22[1] = h22[1] + h22Step[1];
                    float[] fArray = this.lBuf[k][n];
                    fArray[0] = fArray[0] - (h11[1] * l[1] - h21[1] * r[1]);
                    float[] fArray2 = this.lBuf[k][n];
                    fArray2[1] = fArray2[1] + (h11[1] * l[0] + h21[1] * r[0]);
                    float[] fArray3 = this.rBuf[k][n];
                    fArray3[0] = fArray3[0] - (h12[1] * l[1] - h22[1] * r[1]);
                    float[] fArray4 = this.rBuf[k][n];
                    fArray4[1] = fArray4[1] + (h12[1] * l[0] + h22[1] * r[0]);
                }
            }
        }
    }

    private void mapPars(int[][] in, int[][] out, int len, boolean full) {
        block9: {
            block7: {
                block8: {
                    if (!this.header.use34Bands(false)) break block7;
                    if (len != 10) break block8;
                    for (int i = 0; i < this.envCount; ++i) {
                        Utils.map10To34(in[i], out[i], full);
                    }
                    break block9;
                }
                if (len != 20) break block9;
                for (int i = 0; i < this.envCount; ++i) {
                    Utils.map20To34(in[i], out[i], full);
                }
                break block9;
            }
            if (len == 10) {
                for (int i = 0; i < this.envCount; ++i) {
                    Utils.map10To20(in[i], out[i], full);
                }
            } else if (len == 34) {
                for (int i = 0; i < this.envCount; ++i) {
                    Utils.map34To20(in[i], out[i], full);
                }
            }
        }
    }
}

