/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins.ic2_exp;

import codechicken.core.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import ic2.api.recipe.ICannerEnrichRecipeManager;
import ic2.api.recipe.Recipes;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mods.neiplugins.common.ICachedRecipeWithLiquidTank;
import mods.neiplugins.common.LiquidHelper;
import mods.neiplugins.common.LiquidTank;
import mods.neiplugins.common.LiquidTemplateRecipeHandler;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class CannerEnrichRecipeHandler
extends LiquidTemplateRecipeHandler {
    static Rectangle _inputTank = new Rectangle(38, 35, 12, 47);
    static Rectangle _outputTank = new Rectangle(116, 35, 12, 47);
    static Rectangle frameSource = new Rectangle(176, 14, 20, 55);
    static Point _overlayTank = new Point(176, 69);

    @Override
    public String getRecipeId() {
        return "ic2.canner";
    }

    public String getRecipeName() {
        return "Canning Machine";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(69, 11, 22, 15), this.getRecipeId(), new Object[0]));
    }

    public Set<Map.Entry<ICannerEnrichRecipeManager.Input, FluidStack>> getRecipes() {
        return Recipes.cannerEnrich.getRecipes().entrySet();
    }

    @Override
    public void loadCraftingRecipes(FluidStack result) {
        for (Map.Entry<ICannerEnrichRecipeManager.Input, FluidStack> irecipe : this.getRecipes()) {
            if (!LiquidHelper.areSameLiquid(result, irecipe.getValue())) continue;
            this.arecipes.add(new CachedCannerEnrichRecipe(irecipe));
        }
    }

    @Override
    public void loadUsageRecipes(FluidStack ingredient) {
        for (Map.Entry<ICannerEnrichRecipeManager.Input, FluidStack> irecipe : this.getRecipes()) {
            if (!LiquidHelper.areSameLiquid(ingredient, irecipe.getKey().fluid)) continue;
            this.arecipes.add(new CachedCannerEnrichRecipe(irecipe));
        }
    }

    @Override
    public void loadSameRecipeId() {
        for (Map.Entry<ICannerEnrichRecipeManager.Input, FluidStack> irecipe : this.getRecipes()) {
            this.arecipes.add(new CachedCannerEnrichRecipe(irecipe));
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        FluidStack t = LiquidHelper.getFluidStack(result);
        if (t != null) {
            for (Map.Entry<ICannerEnrichRecipeManager.Input, FluidStack> irecipe : this.getRecipes()) {
                if (!LiquidHelper.areSameLiquid(t, irecipe.getValue())) continue;
                this.arecipes.add(new CachedCannerEnrichRecipe(irecipe));
            }
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        FluidStack t = LiquidHelper.getFluidStack(ingredient);
        for (Map.Entry<ICannerEnrichRecipeManager.Input, FluidStack> irecipe : this.getRecipes()) {
            if ((t == null || !LiquidHelper.areSameLiquid(t, irecipe.getKey().fluid)) && (irecipe.getKey().additive == null || !irecipe.getKey().additive.matches(ingredient))) continue;
            CachedCannerEnrichRecipe recipe = new CachedCannerEnrichRecipe(irecipe);
            this.setIngredientPermutationNBT(recipe.slot_input, ingredient);
            this.arecipes.add(recipe);
        }
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)34, (int)4, (int)39, (int)15, (int)98, (int)82);
        GuiDraw.drawTexturedModalRect((int)58, (int)70, (int)196, (int)65, (int)50, (int)14);
    }

    public int recipiesPerPage() {
        return 1;
    }

    public String getGuiTexture() {
        return "ic2:textures/gui/GUICanner.png";
    }

    public class CachedCannerEnrichRecipe
    extends TemplateRecipeHandler.CachedRecipe
    implements ICachedRecipeWithLiquidTank {
        ArrayList<PositionedStack> slot_input;
        LiquidTank inputTank;
        LiquidTank outputTank;

        public CachedCannerEnrichRecipe(Map.Entry<ICannerEnrichRecipeManager.Input, FluidStack> recipe) {
            this(recipe.getKey(), recipe.getValue());
        }

        public CachedCannerEnrichRecipe(ICannerEnrichRecipeManager.Input input, FluidStack output) {
            super((TemplateRecipeHandler)CannerEnrichRecipeHandler.this);
            this.inputTank = new LiquidTank(input.fluid, 8000, _inputTank, _overlayTank);
            this.outputTank = new LiquidTank(output, 8000, _outputTank, _overlayTank);
            this.inputTank.framePos = new Point(34, 31);
            this.inputTank.frameSource = frameSource;
            this.outputTank.framePos = new Point(112, 31);
            this.outputTank.frameSource = frameSource;
            PositionedStack[] input_cont = LiquidHelper.generateStacksForLiquid(this.inputTank.liquid, 36, 6, 36, 6);
            this.slot_input = new ArrayList();
            if (input_cont[1] != null) {
                this.slot_input.add(input_cont[1]);
            }
            if (input.additive != null) {
                this.slot_input.add(new PositionedStack((Object)input.additive.getInputs(), 75, 33));
            }
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(CannerEnrichRecipeHandler.this.cycleticks / 20, this.slot_input);
        }

        public PositionedStack getResult() {
            return null;
        }

        @Override
        public ArrayList<LiquidTank> getLiquidTanks() {
            ArrayList<LiquidTank> res = new ArrayList<LiquidTank>();
            res.add(this.inputTank);
            res.add(this.outputTank);
            return res;
        }
    }
}

