/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins.gregtech;

import gregtechmod.api.util.GT_Recipe;
import gregtechmod.api.util.GT_Utility;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import mods.neiplugins.common.FuelTooltip;
import mods.neiplugins.common.IFuelContextHelper;
import mods.neiplugins.common.SimpleFuelContextHelper;
import mods.neiplugins.common.SimpleFuelHelper;
import mods.neiplugins.common.Utils;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class GregTechFuelHelper
implements IFuelContextHelper {
    public static FuelMap sDieselFuels = new FuelMap();
    public static FuelMap sTurbineFuels = new FuelMap();
    public static FuelMap sHotFuels = new FuelMap();
    public static FuelMap sDenseLiquidFuels = new FuelMap();
    public static FuelMap sPlasmaFuels = new FuelMap();
    public static FuelMap sMagicFuels = new FuelMap();

    @Override
    public String getName() {
        return "Gregtech Generators";
    }

    @Override
    public String getKey() {
        return "gregtech.fuels";
    }

    @Override
    public List<String> getDescription() {
        return null;
    }

    @Override
    public List<String> getContextTooltip(GuiContainer gui, ItemStack stack, List<String> currenttip) {
        return currenttip;
    }

    @Override
    public boolean haveContextTooltip(GuiContainer gui) {
        return false;
    }

    @Override
    public boolean displayFuelTooltip(GuiContainer gui) {
        return true;
    }

    public static void registerFuelHelpers() {
        FuelTooltip.addFuelHelper(new GTFuelHelper("gregtech.diesel", "Diesel Generator", null, sDieselFuels, "at 12 EU/t (Diesel Generator)"));
        FuelTooltip.addFuelHelper(new GTFuelHelper("gregtech.turbine", "Gas Turbine", null, sTurbineFuels, "at 16 EU/t (Gas Turbine)"));
        FuelTooltip.addFuelHelper(new GTFuelHelper("gregtech.hot", "Thermal Generator", null, sHotFuels, "at 24 EU/t (Thermal Generator)"));
        FuelTooltip.addFuelHelper(new GTFuelHelper("gregtech.denseliquid", "Semi Fluid Generator", null, sDenseLiquidFuels, "at 8 EU/t (Semi Fluid Generator)"));
        FuelTooltip.addFuelHelper(new GTFuelHelper("gregtech.plasma", "Plasma Generator", null, sPlasmaFuels, "at 2048 EU/t (Plasma Generator)"));
        FuelTooltip.addFuelHelper(new GTFuelHelper("gregtech.magic", "Magic Energy Converter", null, sMagicFuels, "at 24 EU/t (Magic Energy Converter)"));
        HashMap<Class, String> map = new HashMap<Class, String>();
        Class cls = Utils.findClass("gregtechmod.common.gui.GT_GUIContainer_DieselGenerator");
        if (cls != null) {
            map.put(cls, "gregtech.diesel");
        }
        if ((cls = Utils.findClass("gregtechmod.common.gui.GT_GUIContainer_GasTurbine")) != null) {
            map.put(cls, "gregtech.turbine");
        }
        if ((cls = Utils.findClass("gregtechmod.common.gui.GT_GUIContainer_ThermalGenerator")) != null) {
            map.put(cls, "gregtech.hot");
        }
        if ((cls = Utils.findClass("gregtechmod.common.gui.GT_GUIContainer_SemifluidGenerator")) != null) {
            map.put(cls, "gregtech.denseliquid");
        }
        if ((cls = Utils.findClass("gregtechmod.common.gui.GT_GUIContainer_PlasmaGenerator")) != null) {
            map.put(cls, "gregtech.plasma");
        }
        if ((cls = Utils.findClass("gregtechmod.common.gui.GT_GUIContainer_MagicEnergyConverter")) != null) {
            map.put(cls, "gregtech.magic");
        }
        if (!map.isEmpty()) {
            FuelTooltip.addContextFuelHelper(new SimpleFuelContextHelper("gregtech.all", "GregTech", null, map));
        }
    }

    public static List<String> findFuelTooltip(GT_Recipe recipe, int amount, String suffix, List<String> currenttip) {
        if (recipe != null) {
            currenttip.add("\u00a77" + FuelTooltip.compactValue(recipe.mStartEU * amount) + " EU " + suffix);
        }
        return currenttip;
    }

    public static boolean buildCache() {
        for (GT_Recipe recipe : GT_Recipe.sDieselFuels) {
            sDieselFuels.add(recipe);
        }
        for (GT_Recipe recipe : GT_Recipe.sTurbineFuels) {
            sTurbineFuels.add(recipe);
        }
        for (GT_Recipe recipe : GT_Recipe.sHotFuels) {
            sHotFuels.add(recipe);
        }
        for (GT_Recipe recipe : GT_Recipe.sDenseLiquidFuels) {
            sDenseLiquidFuels.add(recipe);
        }
        for (GT_Recipe recipe : GT_Recipe.sPlasmaFuels) {
            sPlasmaFuels.add(recipe);
        }
        for (GT_Recipe recipe : GT_Recipe.sMagicFuels) {
            sMagicFuels.add(recipe);
        }
        return true;
    }

    static class GTFuelHelper
    extends SimpleFuelHelper {
        FuelMap map;
        String suffix;

        public GTFuelHelper(String key, String name, List<String> desc, FuelMap map, String suffix) {
            super(key, name, desc);
            this.map = map;
            this.suffix = suffix;
        }

        @Override
        public List<String> getFluidStackFuelTooltip(FluidStack fluid, List<String> currenttip) {
            GregTechFuelHelper.findFuelTooltip(this.map.getFluid(fluid), fluid.amount, this.suffix, currenttip);
            return currenttip;
        }

        @Override
        public List<String> getItemStackFuelTooltip(ItemStack stack, List<String> currenttip) {
            GregTechFuelHelper.findFuelTooltip(this.map.getItem(stack), 1000, this.suffix, currenttip);
            return currenttip;
        }
    }

    public static class FuelMap {
        public HashMap<List<Integer>, GT_Recipe> items = new HashMap();
        public HashMap<FluidStack, GT_Recipe> fluids = new HashMap();

        public void add(GT_Recipe recipe) {
            FluidStack liquid = GT_Utility.getFluidForFilledItem((ItemStack)recipe.getRepresentativeInput1());
            if (liquid != null) {
                this.fluids.put(liquid, recipe);
            } else {
                this.items.put(Arrays.asList(recipe.getRepresentativeInput1().field_77993_c, recipe.getRepresentativeInput1().func_77960_j()), recipe);
            }
        }

        public GT_Recipe getFluid(FluidStack fluid) {
            return this.fluids.get(fluid);
        }

        public GT_Recipe getItem(ItemStack stack) {
            return this.items.get(Arrays.asList(stack.field_77993_c, stack.func_77960_j()));
        }
    }
}

