/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins.forestry;

import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import forestry.api.recipes.RecipeManagers;
import forestry.factory.gadgets.MachineBottler;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import mods.neiplugins.common.ICachedRecipeWithLiquidTank;
import mods.neiplugins.common.LiquidHelper;
import mods.neiplugins.common.LiquidTank;
import mods.neiplugins.forestry.ForestryRecipeHandler;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class BottlerRecipeHandler
extends ForestryRecipeHandler {
    static Rectangle inputTank = new Rectangle(48, 6, 16, 58);
    static Point overlayTank = new Point(176, 0);

    @Override
    public String getRecipeId() {
        return "forestry.bottler";
    }

    public String getRecipeName() {
        return "Bottler";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(76, 28, 22, 15), this.getRecipeId(), new Object[0]));
    }

    public ArrayList<MachineBottler.Recipe> getRecipes() {
        MachineBottler.RecipeManager cfr_ignored_0 = (MachineBottler.RecipeManager)RecipeManagers.bottlerManager;
        return MachineBottler.RecipeManager.recipes;
    }

    @Override
    public void loadUsageRecipes(FluidStack ingredient) {
        for (MachineBottler.Recipe irecipe : this.getRecipes()) {
            if (!LiquidHelper.areSameLiquid(ingredient, irecipe.input)) continue;
            this.arecipes.add(new CachedBottlerRecipe(irecipe));
        }
    }

    @Override
    public void loadSameRecipeId() {
        for (MachineBottler.Recipe irecipe : this.getRecipes()) {
            this.arecipes.add(new CachedBottlerRecipe(irecipe));
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (MachineBottler.Recipe irecipe : this.getRecipes()) {
            if (!NEIClientUtils.areStacksSameTypeCrafting((ItemStack)irecipe.bottled, (ItemStack)result)) continue;
            this.arecipes.add(new CachedBottlerRecipe(irecipe));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        FluidStack t = LiquidHelper.getFluidStack(ingredient);
        for (MachineBottler.Recipe irecipe : this.getRecipes()) {
            if (!NEIClientUtils.areStacksSameTypeCrafting((ItemStack)irecipe.can, (ItemStack)ingredient) && (t == null || !LiquidHelper.areSameLiquid(t, irecipe.input))) continue;
            this.arecipes.add(new CachedBottlerRecipe(irecipe));
        }
    }

    public String getGuiTexture() {
        return "forestry:textures/gui/bottler.png";
    }

    public class CachedBottlerRecipe
    extends TemplateRecipeHandler.CachedRecipe
    implements ICachedRecipeWithLiquidTank {
        int timePerUnit;
        ArrayList<PositionedStack> slot_input;
        PositionedStack slot_output;
        PositionedStack slot_can;
        LiquidTank input;

        public CachedBottlerRecipe(MachineBottler.Recipe recipe) {
            super((TemplateRecipeHandler)BottlerRecipeHandler.this);
            this.input = new LiquidTank(recipe.input, 10000, inputTank, overlayTank);
            PositionedStack[] input_cont = LiquidHelper.generateStacksForLiquid(this.input.liquid, 21, 10, 21, 27);
            this.slot_input = new ArrayList();
            this.slot_input.add(input_cont[1]);
            this.slot_can = new PositionedStack((Object)recipe.can, 111, 8);
            this.slot_output = new PositionedStack((Object)recipe.bottled, 111, 44);
        }

        public List<PositionedStack> getOtherStacks() {
            return this.getCycledIngredients(BottlerRecipeHandler.this.cycleticks / 20, this.slot_input);
        }

        public PositionedStack getResult() {
            return this.slot_output;
        }

        public PositionedStack getIngredient() {
            return this.slot_can;
        }

        @Override
        public ArrayList<LiquidTank> getLiquidTanks() {
            ArrayList<LiquidTank> res = new ArrayList<LiquidTank>();
            res.add(this.input);
            return res;
        }
    }
}

