/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins.common;

import codechicken.nei.ItemRange;
import codechicken.nei.MultiItemRange;
import codechicken.nei.api.API;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.logging.Level;
import mods.neiplugins.NEIPlugins;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemApiHelper {
    public static void hideItem(ItemStack itemstack) {
        if (itemstack != null) {
            API.hideItem((int)itemstack.field_77993_c);
        }
    }

    public static void addItemStackToRange(MultiItemRange range, ItemStack itemstack) {
        if (itemstack != null) {
            range.add(itemstack.field_77993_c);
        }
    }

    public static void addSetRangeFromItem(String setname, ItemStack stack) {
        MultiItemRange t = new MultiItemRange();
        if (stack != null) {
            t.add(stack.field_77993_c);
            API.addSetRange((String)setname, (MultiItemRange)t);
        }
    }

    public static void addItemToRangeWithNBT(MultiItemRange range, Item item) {
        if (item != null) {
            ItemStack stack = new ItemStack(item.field_77779_bT, 1, 0);
            range.add(stack.field_77993_c);
            if (stack.func_77942_o()) {
                range.addItemIfInRange(stack.field_77993_c, 0, stack.func_77978_p());
            }
        }
    }

    public static void addSetRangeFromItem(String setname, Class cls, String fieldName) {
        MultiItemRange range = new MultiItemRange();
        ItemApiHelper.addByFieldNameToRange(range, cls, fieldName);
        API.addSetRange((String)setname, (MultiItemRange)range);
    }

    public static void addByFieldNameToRange(MultiItemRange range, Class cls, String fieldName) {
        ItemApiHelper.addByFieldNameToRange(range, cls, null, fieldName, false);
    }

    public static void addByFieldNameToRange(MultiItemRange range, Class cls, Object instance, String fieldName, boolean useNBT) {
        ItemRange irange = ItemApiHelper.getItemRangeByFieldName(cls, instance, fieldName, useNBT, false);
        if (irange != null) {
            range.add(irange);
        }
    }

    public static void setOverrideNameByFieldName(String itemName, Class cls, String fieldName) {
        ItemApiHelper.setOverrideNameByFieldName(itemName, cls, null, fieldName, false);
    }

    public static void setOverrideNameByFieldName(String itemName, Class cls, Object instance, String fieldName, boolean force) {
        ItemStack item;
        ItemRange irange = ItemApiHelper.getItemRangeByFieldName(cls, instance, fieldName, false, true);
        if (irange != null && ((item = new ItemStack(irange.firstID, 1, irange.firstDamage)).func_82833_r().isEmpty() || force)) {
            API.setOverrideName((int)irange.firstID, (int)irange.firstDamage, (String)itemName);
        }
    }

    public static void hideItemByFieldName(Class cls, String fieldName) {
        ItemApiHelper.hideItemByFieldName(cls, null, fieldName);
    }

    public static void hideItemByFieldName(Class cls, Object instance, String fieldName) {
        ItemRange irange = ItemApiHelper.getItemRangeByFieldName(cls, instance, fieldName, false, true);
        if (irange != null) {
            API.hideItem((int)irange.firstID);
        }
    }

    public static ItemRange getSubItemsByItem(Item item) {
        int itemDmg;
        if (item == null) {
            return null;
        }
        if (item.func_77645_m()) {
            return new ItemRange(item.field_77779_bT);
        }
        ArrayList sublist = new ArrayList();
        item.func_77633_a(item.field_77779_bT, null, sublist);
        if (sublist.size() == 0) {
            return new ItemRange(item.field_77779_bT);
        }
        int dmgMin = itemDmg = ((ItemStack)sublist.get(0)).func_77960_j();
        int dmgMax = itemDmg;
        for (ItemStack stack : sublist) {
            itemDmg = stack.func_77960_j();
            if (itemDmg > dmgMax) {
                dmgMax = itemDmg;
            }
            if (itemDmg >= dmgMin) continue;
            dmgMin = itemDmg;
        }
        ItemRange irange = new ItemRange(item.field_77779_bT, dmgMin, dmgMax);
        for (ItemStack stack : sublist) {
            if (!stack.func_77942_o()) continue;
            irange.addItemIfInRange(stack.field_77993_c, stack.func_77960_j(), stack.func_77978_p());
        }
        return irange;
    }

    public static ItemStack getItemStackByFieldName(Class cls, Object instance, String fieldName) {
        Object result = null;
        try {
            Field field = cls.getDeclaredField(fieldName);
            field.setAccessible(true);
            result = field.get(instance);
        }
        catch (NoSuchFieldException e) {
            NEIPlugins.log(Level.FINE, "Failed to get field \"{1}\" from class \"{0}\"", cls.getCanonicalName(), fieldName);
            return null;
        }
        catch (Exception e) {
            NEIPlugins.log(Level.FINE, "Failed to get field \"{1}\" from class \"{0}\": {2}", cls.getCanonicalName(), fieldName, e.getMessage());
            return null;
        }
        if (result == null) {
            return null;
        }
        if (result instanceof Item) {
            return new ItemStack((Item)result);
        }
        if (result instanceof Block) {
            return new ItemStack((Block)result);
        }
        if (result instanceof ItemStack) {
            return (ItemStack)result;
        }
        NEIPlugins.log(Level.FINE, "Unknown class type for field \"{1}\" from class \"{0}\": {2}", cls.getCanonicalName(), fieldName, result.getClass().getCanonicalName());
        return null;
    }

    public static ItemRange getItemRangeByFieldName(Class cls, Object instance, String fieldName, boolean useNBT, boolean requireDamage) {
        Object result = null;
        try {
            Field field = cls.getDeclaredField(fieldName);
            field.setAccessible(true);
            result = field.get(instance);
        }
        catch (NoSuchFieldException e) {
            NEIPlugins.log(Level.FINE, "Failed to get field \"{1}\" from class \"{0}\"", cls.getCanonicalName(), fieldName);
            return null;
        }
        catch (Exception e) {
            NEIPlugins.log(Level.FINE, "Failed to get field \"{1}\" from class \"{0}\": {2}", cls.getCanonicalName(), fieldName, e.getMessage());
            return null;
        }
        if (result == null) {
            return null;
        }
        ItemRange irange = null;
        if (result instanceof Item) {
            irange = new ItemRange(((Item)result).field_77779_bT);
        } else if (result instanceof Block) {
            irange = new ItemRange(((Block)result).field_71990_ca);
        } else if (result instanceof ItemStack) {
            ItemStack item = (ItemStack)result;
            irange = item.func_77973_b().func_77645_m() ? new ItemRange(item.field_77993_c) : new ItemRange(item.field_77993_c, item.func_77960_j(), item.func_77960_j());
            if (useNBT && ((ItemStack)result).func_77942_o()) {
                irange.addItemIfInRange(irange.firstID, irange.firstDamage, item.func_77978_p());
            }
        } else {
            NEIPlugins.log(Level.FINE, "Unknown class type for field \"{1}\" from class \"{0}\": {2}", cls.getCanonicalName(), fieldName, result.getClass().getCanonicalName());
            return null;
        }
        if (requireDamage && irange.firstID == irange.lastID && irange.firstDamage == -1) {
            irange.firstDamage = 0;
            irange.lastDamage = 0;
        }
        return irange;
    }
}

