/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins.common;

import cpw.mods.fml.common.IScheduledTickHandler;
import cpw.mods.fml.common.TickType;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import mods.neiplugins.NEIPlugins;
import mods.neiplugins.common.IFirstTickHandler;

public class FirstTickHandler
implements IScheduledTickHandler {
    private boolean firstServerTick = true;
    private boolean firstClientTick = true;
    private static List<IFirstTickHandler> clientHandlers = new ArrayList<IFirstTickHandler>();
    private static List<IFirstTickHandler> serverHandlers = new ArrayList<IFirstTickHandler>();
    public static List<IFirstTickHandler> handlers = new ArrayList<IFirstTickHandler>();
    public static final int interval = 30;

    public void tickStart(EnumSet type, Object ... tickData) {
        ArrayList<IFirstTickHandler> t;
        if (type.contains(TickType.CLIENT)) {
            if (this.firstClientTick) {
                this.firstClientTick = false;
                for (IFirstTickHandler handler : handlers) {
                    if (handler.firstClientTick()) continue;
                    clientHandlers.add(handler);
                }
                if (clientHandlers.isEmpty()) {
                    NEIPlugins.logFine("FirstTickHandler - client side finish", new Object[0]);
                }
            } else if (!clientHandlers.isEmpty()) {
                t = new ArrayList<IFirstTickHandler>();
                for (IFirstTickHandler handler : clientHandlers) {
                    if (handler.firstClientTick()) continue;
                    t.add(handler);
                }
                clientHandlers = t;
                if (clientHandlers.isEmpty()) {
                    NEIPlugins.logFine("FirstTickHandler - client side finish", new Object[0]);
                }
            }
        }
        if (type.contains(TickType.SERVER)) {
            if (this.firstServerTick) {
                this.firstServerTick = false;
                for (IFirstTickHandler handler : handlers) {
                    if (handler.firstServerTick()) continue;
                    serverHandlers.add(handler);
                }
                if (serverHandlers.isEmpty()) {
                    NEIPlugins.logFine("FirstTickHandler - server side finish", new Object[0]);
                }
            } else if (!serverHandlers.isEmpty()) {
                t = new ArrayList();
                for (IFirstTickHandler handler : serverHandlers) {
                    if (handler.firstServerTick()) continue;
                    t.add(handler);
                }
                serverHandlers = t;
                if (serverHandlers.isEmpty()) {
                    NEIPlugins.logFine("FirstTickHandler - server side finish", new Object[0]);
                }
            }
        }
    }

    public void tickEnd(EnumSet type, Object ... tickData) {
    }

    public EnumSet ticks() {
        return EnumSet.of(TickType.CLIENT, TickType.SERVER);
    }

    public String getLabel() {
        return "NEIPlugins FirstTickHandler";
    }

    public int nextTickSpacing() {
        return this.firstClientTick | this.firstServerTick | !clientHandlers.isEmpty() | !serverHandlers.isEmpty() ? 30 : 1200;
    }
}

